# - Try to find KOffice Libraries
# Once done this will define
#
#  KOFFICELIBS_FOUND - system has KOffice
#  KOFFICELIBS_INCLUDE_DIR - the Koffice include directory
# KOMAIN_LIBRARY
# KOTEXT_LIBRARY
# KOODF_LIBRARY
# KOPAGEAPP_LIBRARY
# KOKROSS_LIBRARY
# FLAKE_LIBRARY
# KOWIDGETS_LIBRARY
# PIGMENTCMS_LIBRARY
#  KOFFICELIBS_DEFINITIONS - Compiler switches required for using Koffice
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.
#

find_package(KDE4 REQUIRED)

if ( KOFFICELIBS_INCLUDE_DIR AND KOFFICELIBS_LIBRARIES )
   # in cache already
   SET( KOFFICELIBS_FIND_QUIETLY TRUE )
endif ( KOFFICELIBS_INCLUDE_DIR AND KOFFICELIBS_LIBRARIES )

FIND_PATH( KOFFICELIBS_INCLUDE_DIR NAMES KoDocument.h)# HINTS ${CMAKE_INSTALL_PREFIX}/include)

FIND_LIBRARY(KOMAIN_LIBRARY NAMES komain)
FIND_LIBRARY(KOTEXT_LIBRARY NAMES kotext)
FIND_LIBRARY(KOPLUGIN_LIBRARY NAMES koplugin)
FIND_LIBRARY(KOODF_LIBRARY NAMES koodf)
FIND_LIBRARY(KOPAGEAPP_LIBRARY NAMES kopageapp)
FIND_LIBRARY(KOKROSS_LIBRARY NAMES kokross)
FIND_LIBRARY(FLAKE_LIBRARY NAMES flake)
FIND_LIBRARY(PIGMENTCMS_LIBRARY NAMES pigmentcms)
FIND_LIBRARY(KOWIDGETS_LIBRARY NAMES kowidgets)

#following are the LIBS with dependencies fulfilled (naming scheme recycled from kde)

SET (KOODF_LIBS
    ${KDE4_KIO_LIBS}
    ${KOPLUGIN_LIBRARY}
    ${KOODF_LIBRARY}
)

SET (PIGMENTCMS_LIBS
    ${PIGMENTCMS_LIBRARY}
    ${KOPLUGIN_LIBRARY}
    ${QT_QTXML_LIBRARY} ${QT_QTGUI_LIBRARY}
)

SET (FLAKE_LIBS
    ${FLAKE_LIBRARY}
    ${PIGMENTCMS_LIBS}
    ${KOODF_LIBS}
)

SET (KOTEXT_LIBS
    ${KOTEXT_LIBRARY}
    ${FLAKE_LIBS}
)

SET (KOWIDGETS_LIBS
    ${KOTEXT_LIBS}
    ${PIGMENTCMS_LIBS}
    ${KDE4_KDEUI_LIBS}
)

SET (KOMAIN_LIBS
    ${KOMAIN_LIBRARY}
    ${KOTEXT_LIBS}
    ${KOWIDGETS_LIBS}
    ${KDE4_KPARTS_LIBS}
)

# legacy;
SET( KOFFICECORE_LIBRARIES
    ${KOODF_LIBRARY}
    ${FLAKE_LIBRARY}
    ${KOTEXT_LIBRARY}
    ${KOPAGEAPP_LIBRARY}
    ${KOPLUGIN_LIBRARY}
    ${KOMAIN_LIBRARY}
)
# legacy;
SET( KOFFICELIBS_LIBRARIES
    ${KOKROSS_LIBRARY}
    ${PIGMENTCMS_LIBRARY}
    ${KOWIDGETS_LIBRARY}
)

# these are defined inside of KOffice, so lets define them for people using koffice too
set(KOPLUGIN_INCLUDES ${KOFFICELIBS_INCLUDE_DIR})
set(KOODF_INCLUDES ${KOFFICELIBS_INCLUDE_DIR})
set(PIGMENT_INCLUDES ${KOFFICELIBS_INCLUDE_DIR})
set(FLAKE_INCLUDES ${KOFFICELIBS_INCLUDE_DIR})
set(KOTEXT_INCLUDES ${KOFFICELIBS_INCLUDE_DIR})
set(KOMAIN_INCLUDES ${KOFFICELIBS_INCLUDE_DIR})

include( FindPackageHandleStandardArgs )

FIND_PACKAGE_HANDLE_STANDARD_ARGS( KOfficeLibs DEFAULT_MSG KOFFICELIBS_INCLUDE_DIR KOFFICECORE_LIBRARIES )

# show the KOFFICELIBS_INCLUDE_DIR and KOFFICELIBS_LIBRARIES variables only in the advanced view
MARK_AS_ADVANCED(KOFFICELIBS_INCLUDE_DIR
    KOMAIN_LIBRARY
    KOTEXT_LIBRARY
    KOPLUGIN_LIBRARY
    KOODF_LIBRARY
    KOPAGEAPP_LIBRARY
    KOKROSS_LIBRARY
    FLAKE_LIBRARY
    KOWIDGETS_LIBRARY
    PIGMENTCMS_LIBRARY
    KOFFICELIBS_LIBRARIES )

# define the generic version of the KOffice libraries here
# this makes it easy to advance it when the next KOffice release comes
set(GENERIC_KOFFICE_LIB_VERSION "8.0.0")
set(GENERIC_KOFFICE_LIB_SOVERSION "8")
