/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.javah;

import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public class PathOptionGroup
extends OptionGroup {
    ArrayList classpath = new ArrayList();
    ArrayList bootclasspath = new ArrayList();

    void setPath(ArrayList list, String path) {
        list.clear();
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
    }

    void addExtDirs(ArrayList list, String path) {
        StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            File dir = new File(tok.nextToken());
            list.addAll(Arrays.asList(dir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".zip") || name.endsWith(".jar");
                }
            })));
        }
    }

    public PathOptionGroup() {
        super("Class path options");
        String boot = System.getProperty("sun.boot.class.path");
        if (boot != null) {
            this.setPath(this.bootclasspath, boot);
        }
        this.add(new Option("classpath", "Set the class path", "PATH"){

            public void parsed(String path) throws OptionException {
                PathOptionGroup.this.setPath(PathOptionGroup.this.classpath, path);
            }
        });
        this.add(new Option("cp", "Set the class path", "PATH"){

            public void parsed(String path) throws OptionException {
                PathOptionGroup.this.setPath(PathOptionGroup.this.classpath, path);
            }
        });
        this.add(new Option('I', "Add directory to class path", "DIR", true){

            public void parsed(String path) throws OptionException {
                PathOptionGroup.this.classpath.add(path);
            }
        });
        this.add(new Option("bootclasspath", "Set the boot class path", "PATH"){

            public void parsed(String path) throws OptionException {
                PathOptionGroup.this.setPath(PathOptionGroup.this.bootclasspath, path);
            }
        });
        this.add(new Option("extdirs", "Set the extension directory path", "PATH"){

            public void parsed(String path) throws OptionException {
                PathOptionGroup.this.addExtDirs(PathOptionGroup.this.classpath, path);
            }
        });
    }

    public URLClassLoader getLoader() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        this.classpath.addAll(this.bootclasspath);
        for (String f : this.classpath) {
            urls.add(new File(f).toURL());
        }
        URL[] urlArray = urls.toArray(new URL[0]);
        return new URLClassLoader(urlArray);
    }
}

