/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class CompoundBorder
extends AbstractBorder {
    static final long serialVersionUID = 9054540377030555103L;
    protected Border insideBorder;
    protected Border outsideBorder;

    public CompoundBorder() {
        this(null, null);
    }

    public CompoundBorder(Border outsideBorder, Border insideBorder) {
        this.outsideBorder = outsideBorder;
        this.insideBorder = insideBorder;
    }

    public boolean isBorderOpaque() {
        if (this.insideBorder == null && this.outsideBorder == null) {
            return true;
        }
        if (this.insideBorder == null) {
            return this.outsideBorder.isBorderOpaque();
        }
        if (this.outsideBorder == null) {
            return this.insideBorder.isBorderOpaque();
        }
        return this.insideBorder.isBorderOpaque() && this.outsideBorder.isBorderOpaque();
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.outsideBorder != null) {
            this.outsideBorder.paintBorder(c, g, x, y, width, height);
            Insets outsideInsets = this.outsideBorder.getBorderInsets(c);
            x += outsideInsets.left;
            y += outsideInsets.top;
            width -= outsideInsets.left + outsideInsets.right;
            height -= outsideInsets.top + outsideInsets.bottom;
        }
        if (this.insideBorder != null) {
            this.insideBorder.paintBorder(c, g, x, y, width, height);
        }
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        Insets borderInsets;
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        } else {
            insets.bottom = 0;
            insets.top = 0;
            insets.right = 0;
            insets.left = 0;
        }
        if (this.outsideBorder != null) {
            borderInsets = this.outsideBorder.getBorderInsets(c);
            insets.left += borderInsets.left;
            insets.right += borderInsets.right;
            insets.top += borderInsets.top;
            insets.bottom += borderInsets.bottom;
        }
        if (this.insideBorder != null) {
            borderInsets = this.insideBorder.getBorderInsets(c);
            insets.left += borderInsets.left;
            insets.right += borderInsets.right;
            insets.top += borderInsets.top;
            insets.bottom += borderInsets.bottom;
        }
        return insets;
    }

    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, null);
    }

    public Border getOutsideBorder() {
        return this.outsideBorder;
    }

    public Border getInsideBorder() {
        return this.insideBorder;
    }
}

