/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class SealedObject
implements Serializable {
    protected byte[] encodedParams;
    private byte[] encryptedContent;
    private String sealAlg;
    private String paramsAlg;
    private transient Cipher sealCipher;
    private static final long serialVersionUID = 4482838265551344752L;

    public SealedObject(Serializable object, Cipher cipher) throws IOException, IllegalBlockSizeException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.flush();
        try {
            this.encryptedContent = cipher.doFinal(baos.toByteArray());
        }
        catch (IllegalStateException illegalStateException) {
            throw new IOException("cipher not in proper state");
        }
        catch (BadPaddingException badPaddingException) {
            throw new IOException("encrypting but got javax.crypto.BadPaddingException");
        }
        this.sealAlg = cipher.getAlgorithm();
        this.encodedParams = cipher.getParameters().getEncoded();
        this.paramsAlg = cipher.getParameters().getAlgorithm();
    }

    protected SealedObject(SealedObject so) {
        this.encodedParams = (byte[])so.encodedParams.clone();
        this.encryptedContent = (byte[])so.encryptedContent.clone();
        this.sealAlg = so.sealAlg;
        this.paramsAlg = so.paramsAlg;
    }

    public final String getAlgorithm() {
        return this.sealAlg;
    }

    public final Object getObject(Cipher cipher) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        this.sealCipher = cipher;
        return this.unseal();
    }

    public final Object getObject(Key key) throws IOException, ClassNotFoundException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            if (this.sealCipher == null) {
                this.sealCipher = Cipher.getInstance(this.sealAlg);
            }
        }
        catch (NoSuchPaddingException nspe) {
            throw new NoSuchAlgorithmException(nspe.getMessage());
        }
        AlgorithmParameters params = null;
        if (this.encodedParams != null) {
            params = AlgorithmParameters.getInstance(this.paramsAlg);
            params.init(this.encodedParams);
        }
        try {
            this.sealCipher.init(2, key, params);
            return this.unseal();
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IOException("bad parameters");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new IOException("illegal block size");
        }
        catch (BadPaddingException badPaddingException) {
            throw new IOException("bad padding");
        }
    }

    public final Object getObject(Key key, String provider) throws IOException, ClassNotFoundException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            this.sealCipher = Cipher.getInstance(this.sealAlg, provider);
        }
        catch (NoSuchPaddingException nspe) {
            throw new NoSuchAlgorithmException(nspe.getMessage());
        }
        AlgorithmParameters params = null;
        if (this.encodedParams != null) {
            params = AlgorithmParameters.getInstance(this.paramsAlg, provider);
            params.init(this.encodedParams);
        }
        try {
            this.sealCipher.init(2, key, params);
            return this.unseal();
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IOException("bad parameters");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new IOException("illegal block size");
        }
        catch (BadPaddingException badPaddingException) {
            throw new IOException("bad padding");
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.encodedParams = (byte[])ois.readObject();
        this.encryptedContent = (byte[])ois.readObject();
        this.sealAlg = (String)ois.readObject();
        this.paramsAlg = (String)ois.readObject();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.encodedParams);
        oos.writeObject(this.encryptedContent);
        oos.writeObject(this.sealAlg);
        oos.writeObject(this.paramsAlg);
    }

    private Object unseal() throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(this.sealCipher.doFinal(this.encryptedContent));
        }
        catch (IllegalStateException illegalStateException) {
            throw new IOException("cipher not initialized");
        }
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }
}

