/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.libxmlj.sax;

import gnu.xml.libxmlj.sax.GnomeXMLReader;
import gnu.xml.libxmlj.sax.XMLName;
import org.xml.sax.Attributes;

class StringArrayAttributes
implements Attributes {
    private int len;
    private XMLName[] keys;
    private String[] values;

    StringArrayAttributes(GnomeXMLReader parser, String[] pairs) {
        this.len = pairs == null ? 0 : pairs.length / 2;
        this.keys = new XMLName[this.len];
        this.values = new String[this.len];
        int i = 0;
        while (i < this.len) {
            int pairIndex = i * 2;
            this.keys[i] = new XMLName(parser, pairs[pairIndex]);
            this.values[i] = pairs[pairIndex + 1];
            ++i;
        }
    }

    public int getLength() {
        return this.len;
    }

    public String getURI(int index) {
        if (index < 0 || index >= this.len) {
            return null;
        }
        return this.keys[index].uri;
    }

    public String getLocalName(int index) {
        if (index < 0 || index >= this.len) {
            return null;
        }
        return this.keys[index].localName;
    }

    public String getQName(int index) {
        if (index < 0 || index >= this.len) {
            return null;
        }
        return this.keys[index].qName;
    }

    public String getType(int index) {
        if (index < 0 || index >= this.len) {
            return null;
        }
        return "CDATA";
    }

    public String getValue(int index) {
        if (index < 0 || index >= this.len) {
            return null;
        }
        return this.values[index];
    }

    public int getIndex(String uri, String localName) {
        int i = 0;
        while (i < this.len) {
            XMLName key = this.keys[i];
            if (key.localName.equals(localName) && (key.uri == null && uri == null || key.uri != null && key.uri.equals(uri))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getIndex(String qName) {
        int i = 0;
        while (i < this.len) {
            if (this.keys[i].qName.equals(qName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getType(String uri, String localName) {
        return this.getType(this.getIndex(uri, localName));
    }

    public String getType(String qName) {
        return this.getType(this.getIndex(qName));
    }

    public String getValue(String uri, String localName) {
        return this.getValue(this.getIndex(uri, localName));
    }

    public String getValue(String qName) {
        return this.getValue(this.getIndex(qName));
    }
}

