/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.security.auth.login;

import gnu.java.lang.CPStringBuilder;
import gnu.javax.security.auth.login.ConfigFileParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Logger;

public class ConfigFileTokenizer {
    private static final Logger log = Logger.getLogger(ConfigFileParser.class.getName());
    public static final int TT_EOF = -1;
    public static final int TT_WORD = -3;
    private static final int TT_NONE = -4;
    public String sval;
    public int ttype;
    private BufferedReader br;
    boolean initialised;
    private CPStringBuilder sb;
    private int sbNdx;

    ConfigFileTokenizer(Reader r) {
        this.br = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        this.initialised = false;
    }

    public int nextToken() throws IOException {
        if (!this.initialised) {
            this.init();
        }
        if (this.sbNdx >= this.sb.length()) {
            return -1;
        }
        this.skipWhitespace();
        if (this.sbNdx >= this.sb.length()) {
            return -1;
        }
        if (Character.isJavaIdentifierPart(this.sb.charAt(this.sbNdx))) {
            int endNdx = this.sbNdx + 1;
            while (Character.isJavaIdentifierPart(this.sb.charAt(endNdx)) || this.sb.charAt(endNdx) == '.') {
                ++endNdx;
            }
            this.ttype = -3;
            this.sval = this.sb.substring(this.sbNdx, endNdx);
            this.sbNdx = endNdx;
            return this.ttype;
        }
        char c = this.sb.charAt(this.sbNdx);
        if (c == '{' || c == '}' || c == ';' || c == '=') {
            this.ttype = c;
            ++this.sbNdx;
            return this.ttype;
        }
        if (c == '\"' || c == '\'') {
            int endNdx;
            this.ttype = c;
            String quote = this.sb.substring(this.sbNdx, this.sbNdx + 1);
            int i = this.sbNdx + 1;
            while (true) {
                if ((endNdx = this.sb.indexOf(quote, i)) == -1) {
                    this.abort("Missing closing quote: " + quote);
                }
                if (this.sb.charAt(endNdx - 1) != '\\') break;
                ++i;
            }
            this.sval = this.sb.substring(this.sbNdx, ++endNdx);
            this.sbNdx = endNdx;
            return this.ttype;
        }
        this.abort("Unknown character: " + this.sb.charAt(this.sbNdx));
        return Integer.MIN_VALUE;
    }

    public void pushBack() {
        this.sbNdx -= this.ttype != -3 ? 1 : this.sval.length();
    }

    private void init() throws IOException {
        String line;
        this.sb = new CPStringBuilder();
        while ((line = this.br.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("//")) continue;
            this.sb.append(line).append(" ");
        }
        this.sbNdx = 0;
        this.sval = null;
        this.ttype = -4;
        this.initialised = true;
    }

    private void skipWhitespace() throws IOException {
        while (this.sbNdx < this.sb.length()) {
            if (Character.isWhitespace(this.sb.charAt(this.sbNdx))) {
                ++this.sbNdx;
                while (this.sbNdx < this.sb.length() && Character.isWhitespace(this.sb.charAt(this.sbNdx))) {
                    ++this.sbNdx;
                }
                continue;
            }
            if (this.sb.charAt(this.sbNdx) != '/' || this.sb.charAt(this.sbNdx + 1) != '*') break;
            int endNdx = this.sb.indexOf("*/", this.sbNdx + 2);
            if (endNdx == -1) {
                this.abort("Missing closing */ sequence");
            }
            this.sbNdx = endNdx + 2;
        }
    }

    private void abort(String m) throws IOException {
        throw new IOException(m);
    }
}

