/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.UnicastConnection;
import gnu.java.rmi.server.UnicastRef;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationID;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;

public class ActivatableRef
extends UnicastRef {
    private static final long serialVersionUID = 1L;
    ActivationID actId;

    public ActivatableRef() {
    }

    public ActivatableRef(ObjID objid, String host, int port, RMIClientSocketFactory csf) {
        super(objid, host, port, csf);
    }

    public ActivatableRef(ObjID objid) {
        super(objid);
    }

    public String getRefClass(ObjectOutput out) {
        return "ActivatableRef";
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.actId = (ActivationID)in.readObject();
        in.readUTF();
        super.readExternal(in);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.actId);
        out.writeUTF("UnicastRef2");
        super.writeExternal(out);
    }

    protected Object invokeCommon(Remote obj, Method method, Object[] params, int opnum, long hash) throws Exception {
        UnicastConnection conn;
        try {
            conn = this.manager.getConnection();
        }
        catch (IOException e1) {
            Remote reactivated = this.actId.activate(false);
            if (reactivated instanceof RemoteObject) {
                RemoteRef ref = ((RemoteObject)reactivated).getRef();
                this.manager = ((UnicastRef)ref).manager;
            } else if (Proxy.isProxyClass(reactivated.getClass())) {
                RemoteObjectInvocationHandler hander = (RemoteObjectInvocationHandler)Proxy.getInvocationHandler(reactivated);
                RemoteRef ref = hander.getRef();
                this.manager = ((UnicastRef)ref).manager;
            } else {
                throw new ActivationException("Activating into unsupported class " + reactivated.getClass());
            }
            try {
                conn = this.manager.getConnection();
            }
            catch (IOException iOException) {
                throw new RemoteException("connection failed to host: " + this.manager.serverName, e1);
            }
        }
        return this.invokeCommon(conn, obj, method, params, opnum, hash);
    }
}

