/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.ClasspathToolkit;
import gnu.java.awt.peer.gtk.AsyncImage;
import gnu.java.awt.peer.gtk.BufferedImageGraphics;
import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.FreetypeGlyphVector;
import gnu.java.awt.peer.gtk.GdkFontPeer;
import java.awt.AWTPermission;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.ImagingOpException;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CairoGraphics2D
extends Graphics2D {
    long nativePointer;
    Paint paint;
    boolean customPaint;
    Stroke stroke;
    Color fg;
    Color bg;
    Shape clip;
    AffineTransform transform;
    Font font;
    Composite comp;
    CompositeContext compCtx;
    private RenderingHints hints;
    private boolean antialias = false;
    private boolean ignoreAA = false;
    protected boolean shiftDrawCalls = false;
    private boolean firstClip = true;
    private Shape originalClip;
    private static BasicStroke draw3DRectStroke;
    static ColorModel rgb32;
    static ColorModel argb32;
    public static final int INTERPOLATION_NEAREST = 0;
    public static final int INTERPOLATION_BILINEAR = 1;
    public static final int INTERPOLATION_BICUBIC = 5;
    public static final int ALPHA_INTERPOLATION_SPEED = 2;
    public static final int ALPHA_INTERPOLATION_QUALITY = 3;
    public static final int ALPHA_INTERPOLATION_DEFAULT = 4;

    static {
        System.loadLibrary("gtkpeer");
        draw3DRectStroke = new BasicStroke();
        rgb32 = new DirectColorModel(32, 0xFF0000, 65280, 255);
        argb32 = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    }

    public void setup(long cairo_t_pointer) {
        this.nativePointer = this.init(cairo_t_pointer);
        this.setRenderingHints(new RenderingHints(this.getDefaultHints()));
        this.setFont(new Font("SansSerif", 0, 12));
        this.setColor(Color.black);
        this.setBackground(Color.white);
        this.setPaint(Color.black);
        this.setStroke(new BasicStroke());
        this.setTransform(new AffineTransform());
        this.cairoSetAntialias(this.nativePointer, this.antialias);
    }

    public void copy(CairoGraphics2D g, long cairo_t_pointer) {
        this.nativePointer = this.init(cairo_t_pointer);
        this.paint = g.paint;
        this.stroke = g.stroke;
        this.setRenderingHints(g.hints);
        Color foreground = g.fg.getAlpha() != -1 ? new Color(g.fg.getRed(), g.fg.getGreen(), g.fg.getBlue(), g.fg.getAlpha()) : new Color(g.fg.getRGB());
        if (g.bg != null) {
            this.bg = g.bg.getAlpha() != -1 ? new Color(g.bg.getRed(), g.bg.getGreen(), g.bg.getBlue(), g.bg.getAlpha()) : new Color(g.bg.getRGB());
        }
        this.firstClip = g.firstClip;
        this.originalClip = g.originalClip;
        this.clip = g.getClip();
        this.transform = g.transform == null ? null : new AffineTransform(g.transform);
        this.setFont(g.font);
        this.setColor(foreground);
        this.setBackground(this.bg);
        this.setPaint(this.paint);
        this.setStroke(this.stroke);
        this.setTransformImpl(this.transform);
        this.setClip(this.clip);
        this.setComposite(this.comp);
        this.antialias = !g.antialias;
        this.setAntialias(g.antialias);
    }

    @Override
    public void finalize() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.disposeNative(this.nativePointer);
        this.nativePointer = 0L;
        if (this.compCtx != null) {
            this.compCtx.dispose();
        }
    }

    protected native long init(long var1);

    @Override
    public abstract Graphics create();

    @Override
    public abstract GraphicsConfiguration getDeviceConfiguration();

    protected abstract void copyAreaImpl(int var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract Rectangle2D getRealBounds();

    public native void disposeNative(long var1);

    protected native void drawPixels(long var1, int[] var3, int var4, int var5, int var6, double[] var7, double var8, int var10);

    protected native void setGradient(long var1, double var3, double var5, double var7, double var9, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, boolean var19);

    protected native void setPaintPixels(long var1, int[] var3, int var4, int var5, int var6, boolean var7, int var8, int var9);

    protected native void cairoSetMatrix(long var1, double[] var3);

    protected native void cairoScale(long var1, double var3, double var5);

    protected native void cairoSetOperator(long var1, int var3);

    protected native void cairoSetRGBAColor(long var1, double var3, double var5, double var7, double var9);

    protected native void cairoSetFillRule(long var1, int var3);

    protected native void cairoSetLine(long var1, double var3, int var5, int var6, double var7);

    protected native void cairoSetDash(long var1, double[] var3, int var4, double var5);

    protected native void cairoDrawGlyphVector(long var1, GdkFontPeer var3, float var4, float var5, int var6, int[] var7, float[] var8, long[] var9);

    protected native void cairoSetFont(long var1, GdkFontPeer var3);

    protected native void cairoRectangle(long var1, double var3, double var5, double var7, double var9);

    protected native void cairoArc(long var1, double var3, double var5, double var7, double var9, double var11);

    protected native void cairoSave(long var1);

    protected native void cairoRestore(long var1);

    protected native void cairoNewPath(long var1);

    protected native void cairoClosePath(long var1);

    protected native void cairoMoveTo(long var1, double var3, double var5);

    protected native void cairoLineTo(long var1, double var3, double var5);

    protected native void cairoCurveTo(long var1, double var3, double var5, double var7, double var9, double var11, double var13);

    protected native void cairoStroke(long var1);

    protected native void cairoFill(long var1, double var3);

    protected native void cairoClip(long var1);

    protected native void cairoResetClip(long var1);

    protected native void cairoSetAntialias(long var1, boolean var3);

    @Override
    public void setTransform(AffineTransform tx) {
        this.updateClip(this.transform);
        this.setTransformImpl(tx);
        try {
            this.updateClip(this.transform.createInverse());
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        if (this.clip != null) {
            this.setClip(this.clip);
        }
    }

    private void setTransformImpl(AffineTransform tx) {
        this.transform = tx;
        if (this.transform != null) {
            double[] m = new double[6];
            this.transform.getMatrix(m);
            this.cairoSetMatrix(this.nativePointer, m);
        }
    }

    @Override
    public void transform(AffineTransform tx) {
        if (this.transform == null) {
            this.transform = new AffineTransform(tx);
        } else {
            this.transform.concatenate(tx);
        }
        if (this.clip != null) {
            try {
                AffineTransform clipTransform = tx.createInverse();
                this.updateClip(clipTransform);
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        this.setTransformImpl(this.transform);
    }

    @Override
    public void rotate(double theta) {
        this.transform(AffineTransform.getRotateInstance(theta));
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.transform(AffineTransform.getRotateInstance(theta, x, y));
    }

    @Override
    public void scale(double sx, double sy) {
        this.transform(AffineTransform.getScaleInstance(sx, sy));
    }

    @Override
    public void translate(double tx, double ty) {
        if (this.transform != null) {
            this.transform.translate(tx, ty);
        } else {
            this.transform = AffineTransform.getTranslateInstance(tx, ty);
        }
        if (this.clip != null) {
            if (this.clip instanceof Rectangle2D) {
                Rectangle2D r = (Rectangle2D)this.clip;
                r.setRect(r.getX() - tx, r.getY() - ty, r.getWidth(), r.getHeight());
            } else {
                AffineTransform clipTransform = AffineTransform.getTranslateInstance(-tx, -ty);
                this.updateClip(clipTransform);
            }
        }
        this.setTransformImpl(this.transform);
    }

    @Override
    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    @Override
    public void shear(double shearX, double shearY) {
        this.transform(AffineTransform.getShearInstance(shearX, shearY));
    }

    @Override
    public void clip(Shape s) {
        if (s == null) {
            this.setClip(null);
            return;
        }
        if (this.clip == null) {
            this.clip = this.getRealBounds();
        }
        if (this.clip instanceof Rectangle2D && s instanceof Rectangle2D) {
            Rectangle2D clipRect = (Rectangle2D)this.clip;
            Rectangle2D r = (Rectangle2D)s;
            Rectangle2D.intersect(clipRect, r, clipRect);
            this.setClip(clipRect);
        } else {
            Area current = this.clip instanceof Area ? (Area)this.clip : new Area(this.clip);
            Area intersect = s instanceof Area ? (Area)s : new Area(s);
            current.intersect(intersect);
            this.clip = current;
            this.setClip(this.clip);
        }
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    @Override
    public void setPaint(Paint p) {
        if (p == null) {
            return;
        }
        this.paint = p;
        if (this.paint instanceof Color) {
            this.setColor((Color)this.paint);
            this.customPaint = false;
        } else if (this.paint instanceof TexturePaint) {
            TexturePaint tp = (TexturePaint)this.paint;
            BufferedImage img = tp.getImage();
            int width = (int)tp.getAnchorRect().getWidth();
            int height = (int)tp.getAnchorRect().getHeight();
            double scaleX = (double)width / (double)img.getWidth();
            double scaleY = (double)height / (double)img.getHeight();
            AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, scaleY, 0.0, 0.0);
            AffineTransformOp op = new AffineTransformOp(at, this.getRenderingHints());
            BufferedImage texture = op.filter(img, null);
            int[] pixels = texture.getRGB(0, 0, width, height, null, 0, width);
            this.setPaintPixels(this.nativePointer, pixels, width, height, width, true, 0, 0);
            this.customPaint = false;
        } else if (this.paint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)this.paint;
            Point2D p1 = gp.getPoint1();
            Point2D p2 = gp.getPoint2();
            Color c1 = gp.getColor1();
            Color c2 = gp.getColor2();
            this.setGradient(this.nativePointer, p1.getX(), p1.getY(), p2.getX(), p2.getY(), c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha(), c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha(), gp.isCyclic());
            this.customPaint = false;
        } else {
            this.customPaint = true;
        }
    }

    protected void setCustomPaint(Rectangle bounds) {
        if (this.paint instanceof Color || this.paint instanceof TexturePaint || this.paint instanceof GradientPaint) {
            return;
        }
        int cfr_ignored_0 = bounds.x;
        int cfr_ignored_1 = bounds.y;
        int cfr_ignored_2 = bounds.width;
        int cfr_ignored_3 = bounds.height;
        Rectangle2D bounds2D = CairoGraphics2D.getTransformedBounds(bounds, this.transform);
        int deviceX = (int)bounds2D.getX();
        int deviceY = (int)bounds2D.getY();
        int deviceWidth = (int)Math.ceil(bounds2D.getWidth());
        int deviceHeight = (int)Math.ceil(bounds2D.getHeight());
        PaintContext pc = this.paint.createContext(CairoSurface.cairoColorModel, new Rectangle(deviceX, deviceY, deviceWidth, deviceHeight), bounds, this.transform, this.hints);
        Raster raster = pc.getRaster(deviceX, deviceY, deviceWidth, deviceHeight);
        AffineTransform oldTx = new AffineTransform(this.transform);
        this.setTransformImpl(new AffineTransform());
        if (pc.getColorModel().equals(CairoSurface.cairoColorModel) && raster.getSampleModel().getTransferType() == 3) {
            this.setPaintPixels(this.nativePointer, (int[])raster.getDataElements(0, 0, deviceWidth, deviceHeight, null), deviceWidth, deviceHeight, deviceWidth, false, deviceX, deviceY);
        } else if (pc.getColorModel().equals(CairoSurface.cairoCM_opaque) && raster.getSampleModel().getTransferType() == 3) {
            int[] pixels = (int[])raster.getDataElements(0, 0, deviceWidth, deviceHeight, null);
            int i = 0;
            while (i < pixels.length) {
                pixels[i] = 0xFF000000 | pixels[i] & 0xFFFFFF;
                ++i;
            }
            this.setPaintPixels(this.nativePointer, pixels, deviceWidth, deviceHeight, deviceWidth, false, deviceX, deviceY);
        } else {
            WritableRaster wr = Raster.createWritableRaster(raster.getSampleModel(), new Point(raster.getMinX(), raster.getMinY()));
            wr.setRect(raster);
            BufferedImage img2 = new BufferedImage(pc.getColorModel(), wr, pc.getColorModel().isAlphaPremultiplied(), null);
            this.setPaintPixels(this.nativePointer, img2.getRGB(0, 0, deviceWidth, deviceHeight, null, 0, deviceWidth), deviceWidth, deviceHeight, deviceWidth, false, deviceX, deviceY);
        }
        this.setTransformImpl(oldTx);
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(Stroke st) {
        this.stroke = st;
        if (this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            this.cairoSetLine(this.nativePointer, bs.getLineWidth(), bs.getEndCap(), bs.getLineJoin(), bs.getMiterLimit());
            float[] dashes = bs.getDashArray();
            if (dashes != null) {
                double[] double_dashes = new double[dashes.length];
                int i = 0;
                while (i < dashes.length) {
                    double_dashes[i] = dashes[i];
                    ++i;
                }
                this.cairoSetDash(this.nativePointer, double_dashes, double_dashes.length, bs.getDashPhase());
            } else {
                this.cairoSetDash(this.nativePointer, new double[0], 0, 0.0);
            }
        }
    }

    protected Rectangle findStrokedBounds(Shape s) {
        Rectangle r = s.getBounds();
        if (this.stroke instanceof BasicStroke) {
            int strokeWidth = (int)Math.ceil(((BasicStroke)this.stroke).getLineWidth());
            r.x -= strokeWidth / 2;
            r.y -= strokeWidth / 2;
            r.height += strokeWidth;
            r.width += strokeWidth;
        } else {
            Shape s2 = this.stroke.createStrokedShape(s);
            r = s2.getBounds();
        }
        return r;
    }

    @Override
    public void setPaintMode() {
        this.setComposite(AlphaComposite.SrcOver);
    }

    @Override
    public void setXORMode(Color c) {
    }

    @Override
    public void setColor(Color c) {
        if (c == null) {
            c = Color.BLACK;
        }
        this.fg = c;
        this.paint = c;
        this.updateColor();
    }

    void updateColor() {
        if (this.fg == null) {
            this.fg = Color.BLACK;
        }
        this.cairoSetRGBAColor(this.nativePointer, (double)this.fg.getRed() / 255.0, (double)this.fg.getGreen() / 255.0, (double)this.fg.getBlue() / 255.0, (double)this.fg.getAlpha() / 255.0);
    }

    @Override
    public Color getColor() {
        return this.fg;
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        if (this.clip == null) {
            this.setClip(new Rectangle(x, y, width, height));
        } else if (this.clip instanceof Rectangle) {
            CairoGraphics2D.computeIntersection(x, y, width, height, (Rectangle)this.clip);
            this.setClip(this.clip);
        } else {
            this.clip(new Rectangle(x, y, width, height));
        }
    }

    @Override
    public Shape getClip() {
        if (this.clip == null) {
            return null;
        }
        if (this.clip instanceof Rectangle2D) {
            return this.clip.getBounds2D();
        }
        GeneralPath p = new GeneralPath();
        PathIterator pi = this.clip.getPathIterator(null);
        p.append(pi, false);
        return p;
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.clip == null) {
            return null;
        }
        return this.clip.getBounds();
    }

    protected Rectangle2D getClipInDevSpace() {
        Rectangle2D uclip = this.clip.getBounds2D();
        if (this.transform == null) {
            return uclip;
        }
        return CairoGraphics2D.getTransformedBounds(this.clip.getBounds2D(), this.transform);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        if (width < 0 || height < 0) {
            return;
        }
        this.setClip(new Rectangle2D.Double(x, y, width, height));
    }

    @Override
    public void setClip(Shape s) {
        if (this.firstClip) {
            this.originalClip = s;
            this.firstClip = false;
        }
        this.clip = s;
        this.cairoResetClip(this.nativePointer);
        if (this.clip != null) {
            this.cairoNewPath(this.nativePointer);
            if (this.clip instanceof Rectangle2D) {
                Rectangle2D r = (Rectangle2D)this.clip;
                this.cairoRectangle(this.nativePointer, r.getX(), r.getY(), r.getWidth(), r.getHeight());
            } else {
                this.walkPath(this.clip.getPathIterator(null), false);
            }
            this.cairoClip(this.nativePointer);
        }
    }

    @Override
    public void setBackground(Color c) {
        if (c == null) {
            c = Color.WHITE;
        }
        this.bg = c;
    }

    @Override
    public Color getBackground() {
        return this.bg;
    }

    @Override
    public Composite getComposite() {
        if (this.comp == null) {
            return AlphaComposite.SrcOver;
        }
        return this.comp;
    }

    @Override
    public void setComposite(Composite comp) {
        if (this.comp == comp) {
            return;
        }
        this.comp = comp;
        if (this.compCtx != null) {
            this.compCtx.dispose();
        }
        this.compCtx = null;
        if (comp instanceof AlphaComposite) {
            AlphaComposite a = (AlphaComposite)comp;
            this.cairoSetOperator(this.nativePointer, a.getRule());
        } else {
            this.cairoSetOperator(this.nativePointer, 3);
            if (comp != null) {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission(new AWTPermission("readDisplayPixels"));
                }
                this.compCtx = comp.createContext(this.getBufferCM(), this.getNativeCM(), this.hints);
            }
        }
    }

    protected abstract ColorModel getNativeCM();

    protected ColorModel getBufferCM() {
        return this.getNativeCM();
    }

    @Override
    public void draw(Shape s) {
        if (this.stroke != null && !(this.stroke instanceof BasicStroke) || this.comp instanceof AlphaComposite && (double)((AlphaComposite)this.comp).getAlpha() != 1.0) {
            this.fill(this.stroke.createStrokedShape(s));
            return;
        }
        if (this.customPaint) {
            Rectangle r = this.findStrokedBounds(s);
            this.setCustomPaint(r);
        }
        this.setAntialias(!this.hints.get(RenderingHints.KEY_ANTIALIASING).equals(RenderingHints.VALUE_ANTIALIAS_OFF));
        this.createPath(s, true);
        this.cairoStroke(this.nativePointer);
    }

    @Override
    public void fill(Shape s) {
        this.createPath(s, false);
        if (this.customPaint) {
            this.setCustomPaint(s.getBounds());
        }
        this.setAntialias(!this.hints.get(RenderingHints.KEY_ANTIALIASING).equals(RenderingHints.VALUE_ANTIALIAS_OFF));
        double alpha = 1.0;
        if (this.comp instanceof AlphaComposite) {
            alpha = ((AlphaComposite)this.comp).getAlpha();
        }
        this.cairoFill(this.nativePointer, alpha);
    }

    private void createPath(Shape s, boolean isDraw) {
        this.cairoNewPath(this.nativePointer);
        if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            double x = this.shiftX(r.getX(), this.shiftDrawCalls && isDraw);
            double y = this.shiftY(r.getY(), this.shiftDrawCalls && isDraw);
            double w = Math.round(r.getWidth());
            double h = Math.round(r.getHeight());
            this.cairoRectangle(this.nativePointer, x, y, w, h);
        } else if (s instanceof Line2D) {
            Line2D l = (Line2D)s;
            this.cairoMoveTo(this.nativePointer, this.shiftX(l.getX1(), this.shiftDrawCalls && isDraw), this.shiftY(l.getY1(), this.shiftDrawCalls && isDraw));
            this.cairoLineTo(this.nativePointer, this.shiftX(l.getX2(), this.shiftDrawCalls && isDraw), this.shiftY(l.getY2(), this.shiftDrawCalls && isDraw));
        } else if (s instanceof Ellipse2D) {
            Ellipse2D e = (Ellipse2D)s;
            double radius = Math.min(e.getHeight(), e.getWidth()) / 2.0;
            double xscale = 1.0;
            double yscale = 1.0;
            if (e.getHeight() != e.getWidth()) {
                this.cairoSave(this.nativePointer);
                if (e.getHeight() < e.getWidth()) {
                    xscale = e.getWidth() / (radius * 2.0);
                } else {
                    yscale = e.getHeight() / (radius * 2.0);
                }
                if (xscale != 1.0 || yscale != 1.0) {
                    this.cairoScale(this.nativePointer, xscale, yscale);
                }
            }
            this.cairoArc(this.nativePointer, this.shiftX(e.getCenterX() / xscale, this.shiftDrawCalls && isDraw), this.shiftY(e.getCenterY() / yscale, this.shiftDrawCalls && isDraw), radius, 0.0, Math.PI * 2);
            if (xscale != 1.0 || yscale != 1.0) {
                this.cairoRestore(this.nativePointer);
            }
        } else {
            this.walkPath(s.getPathIterator(null), this.shiftDrawCalls && isDraw);
        }
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        if (this.bg != null) {
            this.cairoSetRGBAColor(this.nativePointer, (double)this.bg.getRed() / 255.0, (double)this.bg.getGreen() / 255.0, (double)this.bg.getBlue() / 255.0, (double)this.bg.getAlpha() / 255.0);
        }
        Composite oldcomp = this.comp;
        this.setComposite(AlphaComposite.Src);
        this.fillRect(x, y, width, height);
        this.setComposite(oldcomp);
        this.updateColor();
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        Stroke tmp = this.stroke;
        this.setStroke(draw3DRectStroke);
        super.draw3DRect(x, y, width, height, raised);
        this.setStroke(tmp);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0));
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        if (x1 == x2 && y1 == y2) {
            this.fill(new Rectangle(x1, y1, 1, 1));
        } else {
            this.draw(new Line2D.Double(x1, y1, x2, y2));
        }
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.draw(new Rectangle(x, y, width, height));
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 2));
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.fill(new Rectangle(x, y, width, height));
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.fill(new Polygon(xPoints, yPoints, nPoints));
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.draw(new Polygon(xPoints, yPoints, nPoints));
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        int i = 1;
        while (i < nPoints) {
            this.draw(new Line2D.Double(xPoints[i - 1], yPoints[i - 1], xPoints[i], yPoints[i]));
            ++i;
        }
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.drawArc(x, y, width, height, 0, 360);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.fillArc(x, y, width, height, 0, 360);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void copyArea(int ox, int oy, int owidth, int oheight, int odx, int ody) {
        Point2D pos = this.transform.transform(new Point2D.Double(ox, oy), null);
        Point2D dim = this.transform.transform(new Point2D.Double(ox + owidth, oy + oheight), null);
        Point2D p2 = this.transform.transform(new Point2D.Double(ox + odx, oy + ody), null);
        int x = (int)pos.getX();
        int y = (int)pos.getY();
        int width = (int)(dim.getX() - pos.getX());
        int height = (int)(dim.getY() - pos.getY());
        int dx = (int)(p2.getX() - pos.getX());
        int dy = (int)(p2.getY() - pos.getY());
        Rectangle2D r = this.getRealBounds();
        if (width <= 0 || height <= 0) {
            return;
        }
        if ((double)(x + dx) > r.getWidth() || (double)(y + dy) > r.getHeight()) {
            return;
        }
        if ((double)(x + dx + width) < r.getX() || (double)(y + dy + height) < r.getY()) {
            return;
        }
        if ((double)(x + dx) < r.getX()) {
            width = x + dx + width;
            x = (int)r.getX() - dx;
        }
        if ((double)(y + dy) < r.getY()) {
            height = y + dy + height;
            y = (int)r.getY() - dy;
        }
        if ((double)(x + dx + width) >= r.getWidth()) {
            width = (int)r.getWidth() - dx - x;
        }
        if ((double)(y + dy + height) >= r.getHeight()) {
            height = (int)r.getHeight() - dy - y;
        }
        this.copyAreaImpl(x, y, width, height, dx, dy);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.hints.put(hintKey, hintValue);
        this.shiftDrawCalls = this.hints.containsValue(RenderingHints.VALUE_STROKE_NORMALIZE) || this.hints.containsValue(RenderingHints.VALUE_STROKE_DEFAULT);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.hints.get(hintKey);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.hints = new RenderingHints(this.getDefaultHints());
        this.hints.putAll(hints);
        boolean bl = this.shiftDrawCalls = hints.containsValue(RenderingHints.VALUE_STROKE_NORMALIZE) || hints.containsValue(RenderingHints.VALUE_STROKE_DEFAULT);
        if (this.compCtx != null) {
            this.compCtx.dispose();
            this.compCtx = this.comp.createContext(this.getNativeCM(), this.getNativeCM(), this.hints);
        }
    }

    public void addRenderingHints(Map hints) {
        this.hints.putAll((Map<?, ?>)hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    private int getInterpolation() {
        if (this.hints.containsValue(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR)) {
            return 0;
        }
        if (this.hints.containsValue(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
            return 1;
        }
        if (this.hints.containsValue(RenderingHints.VALUE_INTERPOLATION_BICUBIC)) {
            return 5;
        }
        if (this.hints.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED)) {
            return 2;
        }
        if (this.hints.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY)) {
            return 3;
        }
        if (this.hints.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT)) {
            return 4;
        }
        return 1;
    }

    private void setAntialias(boolean needAA) {
        if (this.ignoreAA) {
            return;
        }
        if (needAA != this.antialias) {
            this.antialias = !this.antialias;
            this.cairoSetAntialias(this.nativePointer, this.antialias);
        }
    }

    protected boolean drawImage(Image img, AffineTransform xform, Color bgcolor, ImageObserver obs) {
        Rectangle2D bounds;
        AffineTransform invertedXform;
        if (img == null) {
            return false;
        }
        if (xform == null) {
            xform = new AffineTransform();
        }
        try {
            invertedXform = xform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new ImagingOpException("Unable to invert transform " + xform.toString());
        }
        img = AsyncImage.realImage(img, obs);
        if (!(img instanceof BufferedImage)) {
            ImageProducer source = img.getSource();
            if (source == null) {
                return false;
            }
            img = Toolkit.getDefaultToolkit().createImage(source);
        }
        BufferedImage b = (BufferedImage)img;
        double[] i2u = new double[6];
        int width = b.getWidth();
        int height = b.getHeight();
        Raster raster = BufferedImageGraphics.bufferedImages.get(b) != null ? (Raster)BufferedImageGraphics.bufferedImages.get(b) : b.getRaster();
        invertedXform.getMatrix(i2u);
        double alpha = 1.0;
        if (this.comp instanceof AlphaComposite) {
            alpha = ((AlphaComposite)this.comp).getAlpha();
        }
        if (raster instanceof CairoSurface && ((CairoSurface)raster).sharedBuffer) {
            this.drawCairoSurface((CairoSurface)raster, xform, alpha, this.getInterpolation());
            this.updateColor();
            return true;
        }
        if (bgcolor != null) {
            Color oldColor = this.bg;
            this.setBackground(bgcolor);
            bounds = new Rectangle2D.Double(0.0, 0.0, width, height);
            bounds = CairoGraphics2D.getTransformedBounds(bounds, xform);
            this.clearRect((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
            this.setBackground(oldColor);
        }
        int[] pixels = b.getRGB(0, 0, width, height, null, 0, width);
        this.cairoSave(this.nativePointer);
        bounds = new Rectangle2D.Double(0.0, 0.0, width, height);
        bounds = CairoGraphics2D.getTransformedBounds(bounds, xform);
        this.cairoRectangle(this.nativePointer, bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        this.cairoClip(this.nativePointer);
        this.drawPixels(this.nativePointer, pixels, width, height, width, i2u, alpha, this.getInterpolation());
        this.cairoRestore(this.nativePointer);
        this.updateColor();
        return true;
    }

    @Override
    public void drawRenderedImage(RenderedImage image, AffineTransform xform) {
        this.drawRaster(image.getColorModel(), image.getData(), xform, null);
    }

    @Override
    public void drawRenderableImage(RenderableImage image, AffineTransform xform) {
        this.drawRenderedImage(image.createRendering(new RenderContext(xform)), xform);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.drawImage(img, xform, null, obs);
    }

    @Override
    public void drawImage(BufferedImage image, BufferedImageOp op, int x, int y) {
        BufferedImage filtered = image;
        if (op != null) {
            filtered = op.filter(image, null);
        }
        this.drawImage((Image)filtered, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null, null);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        double scaleX = (double)width / (double)img.getWidth(observer);
        double scaleY = (double)height / (double)img.getHeight(observer);
        if (scaleX == 0.0 || scaleY == 0.0) {
            return true;
        }
        return this.drawImage(img, new AffineTransform(scaleX, 0.0, 0.0, scaleY, (double)x, (double)y), bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, null, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        int ch;
        int cy;
        int cw;
        int cx;
        if (img == null) {
            return false;
        }
        int sourceWidth = sx2 - sx1;
        int sourceHeight = sy2 - sy1;
        int destWidth = dx2 - dx1;
        int destHeight = dy2 - dy1;
        if (destWidth == 0 || destHeight == 0 || sourceWidth == 0 || sourceHeight == 0) {
            return true;
        }
        double scaleX = (double)destWidth / (double)sourceWidth;
        double scaleY = (double)destHeight / (double)sourceHeight;
        Shape oldClip = this.getClip();
        if (dx1 < dx2) {
            cx = dx1;
            cw = dx2 - dx1;
        } else {
            cx = dx2;
            cw = dx1 - dx2;
        }
        if (dy1 < dy2) {
            cy = dy1;
            ch = dy2 - dy1;
        } else {
            cy = dy2;
            ch = dy1 - dy2;
        }
        this.clipRect(cx, cy, cw, ch);
        AffineTransform tx = new AffineTransform();
        tx.translate((double)dx1 - (double)sx1 * scaleX, (double)dy1 - (double)sy1 * scaleY);
        tx.scale(scaleX, scaleY);
        boolean retval = this.drawImage(img, tx, bgcolor, observer);
        this.setClip(oldClip);
        return retval;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    protected void drawCairoSurface(CairoSurface surface, AffineTransform tx, double alpha, int interpolation) {
        if (surface.getSampleModelTranslateX() != 0 || surface.getSampleModelTranslateY() != 0) {
            Point2D.Double origin = new Point2D.Double(0.0, 0.0);
            Point2D.Double offset = new Point2D.Double(surface.getSampleModelTranslateX(), surface.getSampleModelTranslateY());
            tx.transform(origin, origin);
            tx.transform(offset, offset);
            tx.translate(((Point2D)offset).getX() - ((Point2D)origin).getX(), ((Point2D)offset).getY() - ((Point2D)origin).getY());
        }
        Rectangle bounds = new Rectangle(-surface.getSampleModelTranslateX(), -surface.getSampleModelTranslateY(), surface.width, surface.height);
        Shape newBounds = tx.createTransformedShape(bounds);
        this.cairoSave(this.nativePointer);
        this.walkPath(newBounds.getPathIterator(null), false);
        this.cairoClip(this.nativePointer);
        try {
            double[] i2u = new double[6];
            tx.createInverse().getMatrix(i2u);
            surface.nativeDrawSurface(surface.surfacePointer, this.nativePointer, i2u, alpha, interpolation);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {}
        this.cairoRestore(this.nativePointer);
    }

    @Override
    public void drawString(String str, float x, float y) {
        if (str == null || str.length() == 0) {
            return;
        }
        GdkFontPeer fontPeer = (GdkFontPeer)this.font.getPeer();
        TextLayout tl = fontPeer.textLayoutCache.get(str);
        if (tl == null) {
            tl = new TextLayout(str, this.getFont(), this.getFontRenderContext());
            fontPeer.textLayoutCache.put(str, tl);
        }
        this.setAntialias(!this.hints.get(RenderingHints.KEY_TEXT_ANTIALIASING).equals(RenderingHints.VALUE_TEXT_ANTIALIAS_OFF));
        this.ignoreAA = true;
        tl.draw(this, x, y);
        this.ignoreAA = false;
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator ci, int x, int y) {
        this.drawString(ci, (float)x, (float)y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawGlyphVector(GlyphVector gv, float x, float y) {
        double alpha = 1.0;
        if (gv.getNumGlyphs() <= 0) {
            return;
        }
        if (this.customPaint) {
            this.setCustomPaint(gv.getOutline().getBounds());
        }
        if (this.comp instanceof AlphaComposite) {
            alpha = ((AlphaComposite)this.comp).getAlpha();
        }
        this.setAntialias(!this.hints.get(RenderingHints.KEY_TEXT_ANTIALIASING).equals(RenderingHints.VALUE_TEXT_ANTIALIAS_OFF));
        this.ignoreAA = true;
        if (gv instanceof FreetypeGlyphVector && alpha == 1.0 && !((FreetypeGlyphVector)gv).hasTransforms()) {
            GdkFontPeer fontPeer;
            int n = gv.getNumGlyphs();
            int[] codes = gv.getGlyphCodes(0, n, null);
            long[] fontset = ((FreetypeGlyphVector)gv).getGlyphFonts(0, n, null);
            float[] positions = gv.getGlyphPositions(0, n, null);
            this.setFont(gv.getFont());
            GdkFontPeer gdkFontPeer = fontPeer = (GdkFontPeer)this.font.getPeer();
            synchronized (gdkFontPeer) {
                this.cairoDrawGlyphVector(this.nativePointer, fontPeer, x, y, n, codes, positions, fontset);
            }
        } else {
            this.translate(x, y);
            this.fill(gv.getOutline());
            this.translate(-x, -y);
        }
        this.ignoreAA = false;
    }

    @Override
    public void drawString(AttributedCharacterIterator ci, float x, float y) {
        GlyphVector gv = this.getFont().createGlyphVector(this.getFontRenderContext(), ci);
        this.drawGlyphVector(gv, x, y);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(this.transform, true, true);
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return ((GdkFontPeer)f.getPeer()).getFontMetrics(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFont(Font f) {
        GdkFontPeer fontpeer;
        if (f == null) {
            return;
        }
        this.font = f.getPeer() instanceof GdkFontPeer ? f : ((ClasspathToolkit)Toolkit.getDefaultToolkit()).getFont(f.getName(), f.getAttributes());
        GdkFontPeer gdkFontPeer = fontpeer = (GdkFontPeer)this.getFont().getPeer();
        synchronized (gdkFontPeer) {
            this.cairoSetFont(this.nativePointer, fontpeer);
        }
    }

    @Override
    public Font getFont() {
        if (this.font == null) {
            return new Font("SansSerif", 0, 12);
        }
        return this.font;
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (onStroke) {
            Shape stroked = this.stroke.createStrokedShape(s);
            return stroked.intersects(rect.x, rect.y, rect.width, rect.height);
        }
        return s.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[font=" + this.getFont().toString() + ",color=" + this.fg.toString() + "]";
    }

    private boolean drawRaster(ColorModel cm, Raster r, AffineTransform imageToUser, Color bgcolor) {
        int i;
        if (r == null) {
            return false;
        }
        SampleModel sm = r.getSampleModel();
        DataBuffer db = r.getDataBuffer();
        if (db == null || sm == null) {
            return false;
        }
        if (cm == null) {
            cm = ColorModel.getRGBdefault();
        }
        double[] i2u = new double[6];
        if (imageToUser != null) {
            imageToUser.getMatrix(i2u);
        } else {
            i2u[0] = 1.0;
            i2u[1] = 0.0;
            i2u[2] = 0.0;
            i2u[3] = 1.0;
            i2u[4] = 0.0;
            i2u[5] = 0.0;
        }
        int[] pixels = CairoGraphics2D.findSimpleIntegerArray(cm, r);
        if (pixels == null) {
            if (sm instanceof MultiPixelPackedSampleModel) {
                pixels = r.getPixels(0, 0, r.getWidth(), r.getHeight(), pixels);
                i = 0;
                while (i < pixels.length) {
                    pixels[i] = cm.getRGB(pixels[i]);
                    ++i;
                }
            } else {
                pixels = new int[r.getWidth() * r.getHeight()];
                i = 0;
                while (i < pixels.length) {
                    pixels[i] = cm.getRGB(db.getElem(i));
                    ++i;
                }
            }
        }
        if (cm.hasAlpha()) {
            if (bgcolor != null && cm.hasAlpha()) {
                i = 0;
                while (i < pixels.length) {
                    if (cm.getAlpha(pixels[i]) == 0) {
                        pixels[i] = bgcolor.getRGB();
                    }
                    ++i;
                }
            }
        } else {
            i = 0;
            while (i < pixels.length) {
                int n = i++;
                pixels[n] = pixels[n] | 0xFF000000;
            }
        }
        double alpha = 1.0;
        if (this.comp instanceof AlphaComposite) {
            alpha = ((AlphaComposite)this.comp).getAlpha();
        }
        this.drawPixels(this.nativePointer, pixels, r.getWidth(), r.getHeight(), r.getWidth(), i2u, alpha, this.getInterpolation());
        this.updateColor();
        return true;
    }

    private double shiftX(double coord, boolean doShift) {
        if (doShift) {
            double shift = 0.5;
            if (!this.transform.isIdentity()) {
                shift /= this.transform.getScaleX();
            }
            return coord + shift;
        }
        return coord;
    }

    private double shiftY(double coord, boolean doShift) {
        if (doShift) {
            double shift = 0.5;
            if (!this.transform.isIdentity()) {
                shift /= this.transform.getScaleY();
            }
            return coord + shift;
        }
        return coord;
    }

    private void walkPath(PathIterator p, boolean doShift) {
        double x = 0.0;
        double y = 0.0;
        double[] coords = new double[6];
        this.cairoSetFillRule(this.nativePointer, p.getWindingRule());
        while (!p.isDone()) {
            int seg = p.currentSegment(coords);
            switch (seg) {
                case 0: {
                    x = this.shiftX(coords[0], doShift);
                    y = this.shiftY(coords[1], doShift);
                    this.cairoMoveTo(this.nativePointer, x, y);
                    break;
                }
                case 1: {
                    x = this.shiftX(coords[0], doShift);
                    y = this.shiftY(coords[1], doShift);
                    this.cairoLineTo(this.nativePointer, x, y);
                    break;
                }
                case 2: {
                    double x1 = x + 0.6666666666666666 * (this.shiftX(coords[0], doShift) - x);
                    double y1 = y + 0.6666666666666666 * (this.shiftY(coords[1], doShift) - y);
                    double x2 = x1 + 0.3333333333333333 * (this.shiftX(coords[2], doShift) - x);
                    double y2 = y1 + 0.3333333333333333 * (this.shiftY(coords[3], doShift) - y);
                    x = this.shiftX(coords[2], doShift);
                    y = this.shiftY(coords[3], doShift);
                    this.cairoCurveTo(this.nativePointer, x1, y1, x2, y2, x, y);
                    break;
                }
                case 3: {
                    x = this.shiftX(coords[4], doShift);
                    y = this.shiftY(coords[5], doShift);
                    this.cairoCurveTo(this.nativePointer, this.shiftX(coords[0], doShift), this.shiftY(coords[1], doShift), this.shiftX(coords[2], doShift), this.shiftY(coords[3], doShift), x, y);
                    break;
                }
                case 4: {
                    this.cairoClosePath(this.nativePointer);
                }
            }
            p.next();
        }
    }

    private Map<RenderingHints.Key, Object> getDefaultHints() {
        HashMap<RenderingHints.Key, Object> defaultHints = new HashMap<RenderingHints.Key, Object>();
        defaultHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        defaultHints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        defaultHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        defaultHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        defaultHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        return defaultHints;
    }

    public static int[] findSimpleIntegerArray(ColorModel cm, Raster raster) {
        if (cm == null || raster == null) {
            return null;
        }
        if (!cm.getColorSpace().isCS_sRGB()) {
            return null;
        }
        if (!(cm instanceof DirectColorModel)) {
            return null;
        }
        DirectColorModel dcm = (DirectColorModel)cm;
        if (dcm.getRedMask() != 0xFF0000 || dcm.getGreenMask() != 65280 || dcm.getBlueMask() != 255) {
            return null;
        }
        if (!(raster instanceof WritableRaster)) {
            return null;
        }
        if (raster.getSampleModel().getDataType() != 3) {
            return null;
        }
        if (!(raster.getDataBuffer() instanceof DataBufferInt)) {
            return null;
        }
        DataBufferInt db = (DataBufferInt)raster.getDataBuffer();
        if (db.getNumBanks() != 1) {
            return null;
        }
        return db.getData();
    }

    private void updateClip(AffineTransform t) {
        if (this.clip == null) {
            return;
        }
        double[] matrix = new double[4];
        t.getMatrix(matrix);
        if (this.clip instanceof Rectangle2D && matrix[1] == 0.0 && matrix[2] == 0.0) {
            Rectangle2D rect = (Rectangle2D)this.clip;
            double[] origin = new double[]{rect.getX(), rect.getY()};
            double[] dimensions = new double[]{rect.getWidth(), rect.getHeight()};
            t.transform(origin, 0, origin, 0, 1);
            t.deltaTransform(dimensions, 0, dimensions, 0, 1);
            rect.setRect(origin[0], origin[1], dimensions[0], dimensions[1]);
        } else {
            if (!(this.clip instanceof GeneralPath)) {
                this.clip = new GeneralPath(this.clip);
            }
            GeneralPath p = (GeneralPath)this.clip;
            p.transform(t);
        }
    }

    private static Rectangle computeIntersection(int x, int y, int w, int h, Rectangle rect) {
        int dh;
        int x2 = rect.x;
        int y2 = rect.y;
        int w2 = rect.width;
        int h2 = rect.height;
        int dx = x > x2 ? x : x2;
        int dy = y > y2 ? y : y2;
        int dw = x + w < x2 + w2 ? x + w - dx : x2 + w2 - dx;
        int n = dh = y + h < y2 + h2 ? y + h - dy : y2 + h2 - dy;
        if (dw >= 0 && dh >= 0) {
            rect.setBounds(dx, dy, dw, dh);
        } else {
            rect.setBounds(0, 0, 0, 0);
        }
        return rect;
    }

    static Rectangle2D getTransformedBounds(Rectangle2D bounds, AffineTransform tx) {
        double minY;
        double minX;
        double y3;
        double y1;
        double x1 = bounds.getX();
        double x2 = bounds.getX() + bounds.getWidth();
        double x3 = x1;
        double x4 = x2;
        double y2 = y1 = bounds.getY();
        double y4 = y3 = bounds.getY() + bounds.getHeight();
        double[] points = new double[]{x1, y1, x2, y2, x3, y3, x4, y4};
        tx.transform(points, 0, points, 0, 4);
        double maxX = minX = points[0];
        double maxY = minY = points[1];
        int i = 0;
        while (i < 8) {
            if (points[i] < minX) {
                minX = points[i];
            }
            if (points[i] > maxX) {
                maxX = points[i];
            }
            if (points[++i] < minY) {
                minY = points[i];
            }
            if (points[i] > maxY) {
                maxY = points[i];
            }
            ++i;
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }
}

