#!/bin/sh
config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config usr/share/ghostscript/8.71/Resource/Init/cidfmap.new
( cd usr/lib ; rm -rf libgs.so )
( cd usr/lib ; ln -sf libgs.so.8.71 libgs.so )
( cd usr/lib ; rm -rf libgs.so.8 )
( cd usr/lib ; ln -sf libgs.so.8.71 libgs.so.8 )
( cd usr/man/man1 ; rm -rf ps2pdf12.1.gz )
( cd usr/man/man1 ; ln -sf ps2pdf.1.gz ps2pdf12.1.gz )
( cd usr/man/man1 ; rm -rf eps2eps.1.gz )
( cd usr/man/man1 ; ln -sf ps2ps.1.gz eps2eps.1.gz )
( cd usr/man/man1 ; rm -rf ps2pdf13.1.gz )
( cd usr/man/man1 ; ln -sf ps2pdf.1.gz ps2pdf13.1.gz )
( cd usr/man/de/man1 ; rm -rf ps2pdf12.1.gz )
( cd usr/man/de/man1 ; ln -sf ps2pdf.1.gz ps2pdf12.1.gz )
( cd usr/man/de/man1 ; rm -rf eps2eps.1.gz )
( cd usr/man/de/man1 ; ln -sf ps2ps.1.gz eps2eps.1.gz )
( cd usr/man/de/man1 ; rm -rf ps2pdf13.1.gz )
( cd usr/man/de/man1 ; ln -sf ps2pdf.1.gz ps2pdf13.1.gz )
( cd usr/doc/ghostscript-8.71 ; rm -rf doc )
( cd usr/doc/ghostscript-8.71 ; ln -sf /usr/share/ghostscript/8.71/doc doc )
