#!/bin/sh
config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config var/lib/bsdgames/criblog.new
config var/lib/bsdgames/saillog.new
config var/lib/bsdgames/cfscores.new
config var/lib/bsdgames/atc_score.new
config var/lib/bsdgames/phantasia/gold.new
config var/lib/bsdgames/phantasia/mess.new
config var/lib/bsdgames/phantasia/motd.new
config var/lib/bsdgames/phantasia/void.new
config var/lib/bsdgames/phantasia/monsters.new
config var/lib/bsdgames/phantasia/lastdead.new
config var/lib/bsdgames/phantasia/characs.new
config var/lib/bsdgames/phantasia/scoreboard.new
config var/lib/bsdgames/battlestar.log.new
config var/lib/bsdgames/robots_roll.new
config var/lib/bsdgames/snakerawscores.new
config var/lib/bsdgames/snake.log.new
( cd var/lib/bsdgames
  rm -f criblog.new saillog.new cfscores.new atc_score.new 
  rm -f phantasia/gold.new phantasia/mess.new phantasia/motd.new phantasia/void.new phantasia/monsters.new phantasia/lastdead.new
  rm -f phantasia/characs.new phantasia/scoreboard.new battlestar.log.new robots_roll.new snakerawscores.new snake.log.new )
