#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/pine.conf.new

# Prevent sticker shock
if [ ! -e /usr/bin/pine ]; then
  ( cd usr/bin ; ln -sf alpine pine )
fi
( cd usr/bin ; rm -rf gpg-sign )
( cd usr/bin ; ln -sf pinegpg gpg-sign )
( cd usr/bin ; rm -rf gpg-encrypt )
( cd usr/bin ; ln -sf pinegpg gpg-encrypt )
( cd usr/bin ; rm -rf gpg-check )
( cd usr/bin ; ln -sf pinegpg gpg-check )
( cd usr/bin ; rm -rf pinegpg-install )
( cd usr/bin ; ln -sf pinepgpgpg-install pinegpg-install )
( cd usr/bin ; rm -rf gpg-sign+encrypt )
( cd usr/bin ; ln -sf pinegpg gpg-sign+encrypt )
