/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.BrlAPI;

import org.a11y.BrlAPI.Brlapi;
import org.a11y.BrlAPI.ConnectionSettings;
import org.a11y.BrlAPI.DisplaySize;
import org.a11y.BrlAPI.Error;
import org.a11y.BrlAPI.Key;
import org.a11y.BrlAPI.WriteArguments;

public class Test {
    public static void main(String[] stringArray) {
        Object object;
        ConnectionSettings connectionSettings = new ConnectionSettings();
        int n = 0;
        while (n < stringArray.length) {
            if (((String)(object = stringArray[n++])).equals("-host")) {
                if (n == stringArray.length) {
                    System.err.println("Missing host specification.");
                    System.exit(2);
                }
                connectionSettings.host = stringArray[n++];
                continue;
            }
            System.err.println("Invalid option: " + (String)object);
            System.exit(2);
        }
        try {
            System.loadLibrary("brlapi_java");
            System.out.print("Connecting to BrlAPI... ");
            Brlapi brlapi = new Brlapi(connectionSettings);
            System.out.println("done (fd=" + brlapi.getFileDescriptor() + ")");
            System.out.print("Connected to " + brlapi.getHost());
            System.out.print(" using key file " + brlapi.getAuth());
            System.out.println();
            System.out.print("Driver is " + brlapi.getDriverName());
            System.out.println();
            object = brlapi.getDisplaySize();
            System.out.println("Display size is " + ((DisplaySize)object).getWidth() + "x" + ((DisplaySize)object).getHeight());
            int n2 = brlapi.enterTtyMode();
            System.out.println("TTY is " + n2);
            brlapi.writeText("ok !! \u20ac", 0);
            brlapi.writeText(null, 1);
            long[] lArray = new long[]{0L};
            brlapi.ignoreKeys(0L, lArray);
            lArray[0] = 0x20000000L;
            brlapi.acceptKeys(1L, lArray);
            long[][] lArrayArray = new long[][]{{0L, 2}, {5, 7}};
            brlapi.ignoreKeyRanges(lArrayArray);
            Test.printKey(new Key(brlapi.readKey(true)));
            WriteArguments writeArguments = new WriteArguments();
            writeArguments.regionBegin = 10;
            writeArguments.regionSize = 20;
            writeArguments.text = "Key Pressed \u20ac       ";
            writeArguments.andMask = "????????????????????".getBytes();
            writeArguments.cursor = 3;
            brlapi.write(writeArguments);
            Test.printKey(new Key(brlapi.readKey(true)));
            brlapi.leaveTtyMode();
            brlapi.closeConnection();
        }
        catch (Error error) {
            System.out.println("got error: " + error);
            System.exit(3);
        }
    }

    private static void printKey(Key key) {
        System.out.println("got key " + Long.toHexString(key.getCode()) + " (" + Integer.toHexString(key.getType()) + "," + Integer.toHexString(key.getCommand()) + "," + Integer.toHexString(key.getArgument()) + "," + Integer.toHexString(key.getFlags()) + ")");
    }
}

