#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/X11/fvwm2/system.fvwm2rc.new
( cd usr/X11R6/bin ; rm -rf fvwm )
( cd usr/X11R6/bin ; ln -sf fvwm2 fvwm )
( cd usr/X11R6/bin ; rm -rf fvwm-root )
( cd usr/X11R6/bin ; ln -sf xpmroot fvwm-root )
( cd usr/X11R6/man/man1 ; rm -rf fvwm-root.1.gz )
( cd usr/X11R6/man/man1 ; ln -sf xpmroot.1.gz fvwm-root.1.gz )
( cd usr/X11R6/libexec/fvwm/2.4.19 ; rm -rf FvwmAudio )
( cd usr/X11R6/libexec/fvwm/2.4.19 ; ln -sf FvwmEvent FvwmAudio )
( cd usr/X11R6/lib/X11 ; rm -rf fvwm2 )
( cd usr/X11R6/lib/X11 ; ln -sf ../../../../etc/X11/fvwm2 fvwm2 )
