#!/bin/sh
# Handle the incoming configuration files:
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/rc.d/rc.inet1.new
config etc/rc.d/rc.inet1.conf.new
config etc/rc.d/rc.inet2.new
config etc/rc.d/rc.ip_forward.new
config etc/hosts.new
config etc/hosts.deny.new
config etc/hosts.equiv.new
config etc/networks.new
config etc/nntpserver.new
config etc/resolv.conf.new
config etc/HOSTNAME.new
config etc/host.conf.new
config etc/hosts.allow.new
config etc/protocols.new

# OK, some of these aren't useful as examples, and have to be
# considered clutter if you've already got the file.
# So out they go.
rm -f etc/HOSTNAME.new
rm -f etc/hosts.new
rm -f etc/resolv.conf.new
rm -f etc/nntpserver.new

( cd usr/sbin ; rm -rf in.ntalkd )
( cd usr/sbin ; ln -sf in.talkd in.ntalkd )
( cd usr/bin ; rm -rf ntalk )
( cd usr/bin ; ln -sf talk ntalk )
( cd usr/bin ; rm -rf inews )
( cd usr/bin ; ln -sf inews-nntp inews )
( cd bin ; rm -rf dnsdomainname )
( cd bin ; ln -sf hostname dnsdomainname )
( cd bin ; rm -rf nisdomainname )
( cd bin ; ln -sf hostname nisdomainname )
( cd bin ; rm -rf ypdomainname )
( cd bin ; ln -sf hostname ypdomainname )
( cd usr/man/man8 ; rm -rf ping6.8.gz )
( cd usr/man/man8 ; ln -sf ping.8.gz ping6.8.gz )
( cd usr/man/man8 ; rm -rf tracepath6.8.gz )
( cd usr/man/man8 ; ln -sf tracepath.8.gz tracepath6.8.gz )
