#!/bin/sh
NAME="$1"
COMMAND="$2"

getlock() {
	until (set -o noclobber ; echo $$ >/dev/net-lockfile ) 2>/dev/null
	do
	   sleep 1
	done
}

givelock() {
	rm /dev/net-lockfile
}

case $COMMAND in
	'start')
		case $NAME in
			ppp*|ippp*|isdn*|plip*|lo*|irda*|dummy*|tun*|tap*|sit*)
				exit 0
				;;
			*)
				ADDRESS=`cat /sys/class/net/${NAME}/address`
				if ! grep "$ADDRESS" /etc/udev/rules.d/* &>/dev/null ; then
					getlock
					if [ ! -e /etc/udev/rules.d/network-devices.rules ]; then
					   cat <<EOF > /etc/udev/rules.d/network-devices.rules
# Local network rules to name your network cards.
# These rules were generated by nethelper.sh, but you can
# customize them.  By default, all rules are commented out.
# You will need to uncomment and edit them as needed.
# (If, for example, your machine has more than one network
# card and you need to be sure they will always be given
# the same name, like eth0, based on the MAC address)
#
# If you delete this file, /lib/udev/nethelper.sh will try to
# generate it again the next time udev is started.

EOF
					fi
					KRN_NAME=`echo $NAME | sed -ne 's#\(\w*\)[0-9].*#\1#p'`
					if grep "\"$NAME\"" /etc/udev/rules.d/* &>/dev/null ; then
						NUMBER=`grep -c "NAME=\"${KRN_NAME}.\"" /etc/udev/rules.d/network-devices.rules`
						while [ `grep -c "\"${KRN_NAME}${NUMBER}\"" \
							/etc/udev/rules.d/network-devices.rules` -ne 0 ]; do 
							NUMBER=$(($NUMBER+1))
						done
						echo "#KERNEL==\"${KRN_NAME}?\", SYSFS{address}==\"$ADDRESS\", NAME=\"${KRN_NAME}${NUMBER}\"" >> /etc/udev/rules.d/network-devices.rules
					else
						echo "#KERNEL==\"${KRN_NAME}?\", SYSFS{address}==\"$ADDRESS\", NAME=\"${NAME}\"" >> /etc/udev/rules.d/network-devices.rules
					fi
					givelock
				fi
  				# Previously this lock file was /var/lock/subsys/coldplug...
                                # but we need to use /dev here since the / partition is read-only
				# and /var might not even be mounted at all.
				if [ -e /dev/coldplug ] ; then
					exit 1
				elif [ -x /etc/rc.d/rc.inet1 ]; then
					if ! /sbin/ifconfig | /bin/grep -q "^${NAME} "; then
						/etc/rc.d/rc.inet1 ${NAME}_start
						exit 0
					fi
				fi
				;;
		esac
		;;
	'stop')
		case $NAME in
			ppp*|ippp*|isdn*|plip*|lo*|irda*|dummy*|tun*|tap*)
				exit 0
				;;
			*)
				if [ -x /etc/rc.d/rc.inet1 ]; then
				     if /sbin/ifconfig | /bin/grep -q "^${NAME} "; then
					/etc/rc.d/rc.inet1 ${NAME}_stop
				     fi
				fi
				# Does dhcpcd appear to still be running on the interface?  If so, try to stop it.
				if [ -r /etc/dhcpc/dhcpcd-$NAME.pid -o -r /var/run/dhcpcd-$NAME.pid ]; then
				  /sbin/dhcpcd -k -d $NAME
				  # Force garbage removal, if needed:
				  if [ -r /etc/dhcpc/dhcpcd-$NAME.pid ]; then
				     /bin/rm -f /etc/dhcpc/dhcpcd-$NAME.pid
				  elif [ -r /var/run/dhcpcd-$NAME.pid ]; then
				     /bin/rm -f /var/run/dhcpcd-$NAME.pid
				  fi
				fi
			    	# If the interface is now down, exit with a status of 0:
			    	if /sbin/ifconfig | /bin/grep -q "^${NAME} " ; then
			    	  exit 0
			    	fi
				;;
		esac
		;;
	*)
		echo "usage $0 interface start|stop|restart"
		exit 1
		;;
esac
exit 0
