/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-  */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef _MORKARRAY_
#define _MORKARRAY_ 1

#ifndef _MORK_
#  include "mork.h"
#endif

#ifndef _MORKNODE_
#  include "morkNode.h"
#endif

// 456789_123456789_123456789_123456789_123456789_123456789_123456789_123456789

#define morkDerived_kArray /*i*/ 0x4179 /* ascii 'Ay' */

class morkArray : public morkNode {  // row iterator

  // public: // slots inherited from morkObject (meant to inform only)
  // nsIMdbHeap*     mNode_Heap;
  // mork_able    mNode_Mutable; // can this node be modified?
  // mork_load    mNode_Load;    // is this node clean or dirty?
  // mork_base    mNode_Base;    // must equal morkBase_kNode
  // mork_derived mNode_Derived; // depends on specific node subclass
  // mork_access  mNode_Access;  // kOpen, kClosing, kShut, or kDead
  // mork_usage   mNode_Usage;   // kHeap, kStack, kMember, kGlobal, kNone
  // mork_uses    mNode_Uses;    // refcount for strong refs
  // mork_refs    mNode_Refs;    // refcount for strong refs + weak refs

 public:  // state is public because the entire Mork system is private
  void** mArray_Slots;      // array of pointers
  nsIMdbHeap* mArray_Heap;  // required heap for allocating mArray_Slots
  mork_fill mArray_Fill;    // logical count of used slots in mArray_Slots
  mork_size mArray_Size;    // physical count of mArray_Slots ( >= Fill)
  mork_seed mArray_Seed;    // change counter for syncing with iterators

  // { ===== begin morkNode interface =====
 public:                                             // morkNode virtual methods
  virtual void CloseMorkNode(morkEnv* ev) override;  // CloseArray()
  virtual ~morkArray();  // assert that close executed earlier

 public:  // morkArray construction & destruction
  morkArray(morkEnv* ev, const morkUsage& inUsage, nsIMdbHeap* ioHeap,
            mork_size inSize, nsIMdbHeap* ioSlotHeap);
  void CloseArray(morkEnv* ev);  // called by CloseMorkNode();

 private:  // copying is not allowed
  morkArray(const morkArray& other);
  morkArray& operator=(const morkArray& other);

 public:  // dynamic type identification
  mork_bool IsArray() const {
    return IsNode() && mNode_Derived == morkDerived_kArray;
  }
  // } ===== end morkNode methods =====

 public:  // typing & errors
  static void NonArrayTypeError(morkEnv* ev);
  static void IndexBeyondEndError(morkEnv* ev);
  static void NilSlotsAddressError(morkEnv* ev);
  static void FillBeyondSizeError(morkEnv* ev);

 public:  // other table row cursor methods
  mork_fill Length() const { return mArray_Fill; }
  mork_size Capacity() const { return mArray_Size; }

  mork_bool Grow(morkEnv* ev, mork_size inNewSize);
  // Grow() returns true if capacity becomes >= inNewSize and ev->Good()

  void* At(mork_pos inPos) const { return mArray_Slots[inPos]; }
  void AtPut(mork_pos inPos, void* ioSlot) { mArray_Slots[inPos] = ioSlot; }

  void* SafeAt(morkEnv* ev, mork_pos inPos);
  void SafeAtPut(morkEnv* ev, mork_pos inPos, void* ioSlot);

  mork_pos AppendSlot(morkEnv* ev, void* ioSlot);
  void AddSlot(morkEnv* ev, mork_pos inPos, void* ioSlot);
  void CutSlot(morkEnv* ev, mork_pos inPos);
  void CutAllSlots(morkEnv* ev);

 public:  // typesafe refcounting inlines calling inherited morkNode methods
  static void SlotWeakArray(morkArray* me, morkEnv* ev, morkArray** ioSlot) {
    morkNode::SlotWeakNode((morkNode*)me, ev, (morkNode**)ioSlot);
  }

  static void SlotStrongArray(morkArray* me, morkEnv* ev, morkArray** ioSlot) {
    morkNode::SlotStrongNode((morkNode*)me, ev, (morkNode**)ioSlot);
  }
};

// 456789_123456789_123456789_123456789_123456789_123456789_123456789_123456789

#endif /* _MORKTABLEROWCURSOR_ */
