/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.server.repository;

import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.http.server.ProtocolUtil;
import org.openrdf.http.server.ServerHTTPException;
import org.openrdf.http.server.repository.TupleQueryResultView;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.impl.TupleQueryResultImpl;
import org.openrdf.query.resultio.TupleQueryResultWriterFactory;
import org.openrdf.query.resultio.TupleQueryResultWriterRegistry;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.manager.RepositoryManager;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class RepositoryListController
extends AbstractController {
    private static final String REPOSITORY_LIST_QUERY;
    private RepositoryManager repositoryManager;

    public RepositoryListController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET"});
    }

    public void setRepositoryManager(RepositoryManager repMan) {
        this.repositoryManager = repMan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView;
        Repository systemRepository = this.repositoryManager.getSystemRepository();
        ValueFactory vf = systemRepository.getValueFactory();
        RepositoryConnection con = systemRepository.getConnection();
        try {
            ArrayList<String> bindingNames = new ArrayList<String>();
            ArrayList<QueryBindingSet> bindingSets = new ArrayList<QueryBindingSet>();
            TupleQueryResult queryResult = con.prepareTupleQuery(QueryLanguage.SERQL, REPOSITORY_LIST_QUERY).evaluate();
            try {
                StringBuffer requestURL = request.getRequestURL();
                if (requestURL.charAt(requestURL.length() - 1) != '/') {
                    requestURL.append('/');
                }
                String namespace = requestURL.toString();
                while (queryResult.hasNext()) {
                    QueryBindingSet bindings = new QueryBindingSet((BindingSet)queryResult.next());
                    String id = bindings.getValue("id").stringValue();
                    bindings.addBinding("uri", vf.createURI(namespace, id));
                    bindingSets.add(bindings);
                }
                bindingNames.add("uri");
                bindingNames.addAll(queryResult.getBindingNames());
            }
            finally {
                queryResult.close();
            }
            TupleQueryResultWriterFactory factory = ProtocolUtil.getAcceptableService(request, response, TupleQueryResultWriterRegistry.getInstance());
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("queryResult", new TupleQueryResultImpl(bindingNames, bindingSets));
            model.put("filenameHint", "repositories");
            model.put("factory", factory);
            modelAndView = new ModelAndView((View)TupleQueryResultView.getInstance(), model);
        }
        catch (Throwable throwable) {
            try {
                con.close();
                throw throwable;
            }
            catch (RepositoryException e) {
                throw new ServerHTTPException(e.getMessage(), (Throwable)e);
            }
        }
        con.close();
        return modelAndView;
    }

    static {
        StringBuilder query = new StringBuilder(256);
        query.append("SELECT id, title, \"true\"^^xsd:boolean as \"readable\", \"true\"^^xsd:boolean as \"writable\"");
        query.append("FROM {} rdf:type {sys:Repository};");
        query.append("        [rdfs:label {title}];");
        query.append("        sys:repositoryID {id} ");
        query.append("USING NAMESPACE sys = <http://www.openrdf.org/config/repository#>");
        REPOSITORY_LIST_QUERY = query.toString();
    }
}

