/*
 * Copyright (C) 2008-2010  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/*
 * Authors:
 *   Richard Li <RichardZ.Li@amd.com>, <richardradeon@gmail.com> 
 */

#ifndef _EVERGREEN_OFF_H_
#define _EVERGREEN_OFF_H_

enum 
{
/* Registers from PA block: */ 	
  EG_PA_SC_SCREEN_SCISSOR_TL                    = 0x28030, // DIFF 
  EG_PA_SC_SCREEN_SCISSOR_BR                    = 0x28034, // DIFF 
  EG_PA_SC_WINDOW_OFFSET                        = 0x28200, // DIFF 
  EG_PA_SC_WINDOW_SCISSOR_TL                    = 0x28204, // DIFF 
  EG_PA_SC_WINDOW_SCISSOR_BR                    = 0x28208, // DIFF 
  EG_PA_SC_CLIPRECT_RULE                        = 0x2820C, // SAME 
  EG_PA_SC_CLIPRECT_0_TL                        = 0x28210, // DIFF 
  EG_PA_SC_CLIPRECT_0_BR                        = 0x28214, // DIFF 
  EG_PA_SC_CLIPRECT_1_TL                        = 0x28218, // DIFF 
  EG_PA_SC_CLIPRECT_1_BR                        = 0x2821C, // DIFF 
  EG_PA_SC_CLIPRECT_2_TL                        = 0x28220, // DIFF 
  EG_PA_SC_CLIPRECT_2_BR                        = 0x28224, // DIFF 
  EG_PA_SC_CLIPRECT_3_TL                        = 0x28228, // DIFF 
  EG_PA_SC_CLIPRECT_3_BR                        = 0x2822C, // DIFF 
  EG_PA_SC_EDGERULE                             = 0x28230, // SAME 
  EG_PA_SU_HARDWARE_SCREEN_OFFSET               = 0x28234, // 
  EG_PA_SC_GENERIC_SCISSOR_TL                   = 0x28240, // DIFF 
  EG_PA_SC_GENERIC_SCISSOR_BR                   = 0x28244, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_0_TL                   = 0x28250, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_0_BR                   = 0x28254, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_1_TL                   = 0x28258, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_1_BR                   = 0x2825C, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_2_TL                   = 0x28260, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_2_BR                   = 0x28264, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_3_TL                   = 0x28268, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_3_BR                   = 0x2826C, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_4_TL                   = 0x28270, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_4_BR                   = 0x28274, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_5_TL                   = 0x28278, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_5_BR                   = 0x2827C, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_6_TL                   = 0x28280, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_6_BR                   = 0x28284, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_7_TL                   = 0x28288, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_7_BR                   = 0x2828C, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_8_TL                   = 0x28290, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_8_BR                   = 0x28294, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_9_TL                   = 0x28298, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_9_BR                   = 0x2829C, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_10_TL                  = 0x282A0, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_10_BR                  = 0x282A4, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_11_TL                  = 0x282A8, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_11_BR                  = 0x282AC, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_12_TL                  = 0x282B0, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_12_BR                  = 0x282B4, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_13_TL                  = 0x282B8, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_13_BR                  = 0x282BC, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_14_TL                  = 0x282C0, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_14_BR                  = 0x282C4, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_15_TL                  = 0x282C8, // DIFF 
  EG_PA_SC_VPORT_SCISSOR_15_BR                  = 0x282CC, // DIFF 
  EG_PA_SC_VPORT_ZMIN_0                         = 0x282D0, // SAME 
  EG_PA_SC_VPORT_ZMAX_0                         = 0x282D4, // SAME 
  EG_PA_SC_VPORT_ZMIN_1                         = 0x282D8, // SAME 
  EG_PA_SC_VPORT_ZMAX_1                         = 0x282DC, // SAME 
  EG_PA_SC_VPORT_ZMIN_2                         = 0x282E0, // SAME 
  EG_PA_SC_VPORT_ZMAX_2                         = 0x282E4, // SAME 
  EG_PA_SC_VPORT_ZMIN_3                         = 0x282E8, // SAME 
  EG_PA_SC_VPORT_ZMAX_3                         = 0x282EC, // SAME 
  EG_PA_SC_VPORT_ZMIN_4                         = 0x282F0, // SAME 
  EG_PA_SC_VPORT_ZMAX_4                         = 0x282F4, // SAME 
  EG_PA_SC_VPORT_ZMIN_5                         = 0x282F8, // SAME 
  EG_PA_SC_VPORT_ZMAX_5                         = 0x282FC, // SAME 
  EG_PA_SC_VPORT_ZMIN_6                         = 0x28300, // SAME 
  EG_PA_SC_VPORT_ZMAX_6                         = 0x28304, // SAME 
  EG_PA_SC_VPORT_ZMIN_7                         = 0x28308, // SAME 
  EG_PA_SC_VPORT_ZMAX_7                         = 0x2830C, // SAME 
  EG_PA_SC_VPORT_ZMIN_8                         = 0x28310, // SAME 
  EG_PA_SC_VPORT_ZMAX_8                         = 0x28314, // SAME 
  EG_PA_SC_VPORT_ZMIN_9                         = 0x28318, // SAME 
  EG_PA_SC_VPORT_ZMAX_9                         = 0x2831C, // SAME 
  EG_PA_SC_VPORT_ZMIN_10                        = 0x28320, // SAME 
  EG_PA_SC_VPORT_ZMAX_10                        = 0x28324, // SAME 
  EG_PA_SC_VPORT_ZMIN_11                        = 0x28328, // SAME 
  EG_PA_SC_VPORT_ZMAX_11                        = 0x2832C, // SAME 
  EG_PA_SC_VPORT_ZMIN_12                        = 0x28330, // SAME 
  EG_PA_SC_VPORT_ZMAX_12                        = 0x28334, // SAME 
  EG_PA_SC_VPORT_ZMIN_13                        = 0x28338, // SAME 
  EG_PA_SC_VPORT_ZMAX_13                        = 0x2833C, // SAME 
  EG_PA_SC_VPORT_ZMIN_14                        = 0x28340, // SAME 
  EG_PA_SC_VPORT_ZMAX_14                        = 0x28344, // SAME 
  EG_PA_SC_VPORT_ZMIN_15                        = 0x28348, // SAME 
  EG_PA_SC_VPORT_ZMAX_15                        = 0x2834C, // SAME 
  EG_PA_CL_VPORT_XSCALE                         = 0x2843C, // SAME 
  EG_PA_CL_VPORT_XOFFSET                        = 0x28440, // SAME 
  EG_PA_CL_VPORT_YSCALE                         = 0x28444, // SAME 
  EG_PA_CL_VPORT_YOFFSET                        = 0x28448, // SAME 
  EG_PA_CL_VPORT_ZSCALE                         = 0x2844C, // SAME 
  EG_PA_CL_VPORT_ZOFFSET                        = 0x28450, // SAME 
  EG_PA_CL_VPORT_XSCALE_1                       = 0x28454, // SAME 
  EG_PA_CL_VPORT_XOFFSET_1                      = 0x28458, // SAME 
  EG_PA_CL_VPORT_YSCALE_1                       = 0x2845C, // SAME 
  EG_PA_CL_VPORT_YOFFSET_1                      = 0x28460, // SAME 
  EG_PA_CL_VPORT_ZSCALE_1                       = 0x28464, // SAME 
  EG_PA_CL_VPORT_ZOFFSET_1                      = 0x28468, // SAME 
  EG_PA_CL_VPORT_XSCALE_2                       = 0x2846C, // SAME 
  EG_PA_CL_VPORT_XOFFSET_2                      = 0x28470, // SAME 
  EG_PA_CL_VPORT_YSCALE_2                       = 0x28474, // SAME 
  EG_PA_CL_VPORT_YOFFSET_2                      = 0x28478, // SAME 
  EG_PA_CL_VPORT_ZSCALE_2                       = 0x2847C, // SAME 
  EG_PA_CL_VPORT_ZOFFSET_2                      = 0x28480, // SAME 
  EG_PA_CL_VPORT_XSCALE_3                       = 0x28484, // SAME 
  EG_PA_CL_VPORT_XOFFSET_3                      = 0x28488, // SAME 
  EG_PA_CL_VPORT_YSCALE_3                       = 0x2848C, // SAME 
  EG_PA_CL_VPORT_YOFFSET_3                      = 0x28490, // SAME 
  EG_PA_CL_VPORT_ZSCALE_3                       = 0x28494, // SAME 
  EG_PA_CL_VPORT_ZOFFSET_3                      = 0x28498, // SAME 
  EG_PA_CL_VPORT_XSCALE_4                       = 0x2849C, // SAME 
  EG_PA_CL_VPORT_XOFFSET_4                      = 0x284A0, // SAME 
  EG_PA_CL_VPORT_YSCALE_4                       = 0x284A4, // SAME 
  EG_PA_CL_VPORT_YOFFSET_4                      = 0x284A8, // SAME 
  EG_PA_CL_VPORT_ZSCALE_4                       = 0x284AC, // SAME 
  EG_PA_CL_VPORT_ZOFFSET_4                      = 0x284B0, // SAME 
  EG_PA_CL_VPORT_XSCALE_5                       = 0x284B4, // SAME 
  EG_PA_CL_VPORT_XOFFSET_5                      = 0x284B8, // SAME 
  EG_PA_CL_VPORT_YSCALE_5                       = 0x284BC, // SAME 
  EG_PA_CL_VPORT_YOFFSET_5                      = 0x284C0, // SAME 
  EG_PA_CL_VPORT_ZSCALE_5                       = 0x284C4, // SAME 
  EG_PA_CL_VPORT_ZOFFSET_5                      = 0x284C8, // SAME 
  EG_PA_CL_VPORT_XSCALE_6                       = 0x284CC, // SAME 
  EG_PA_CL_VPORT_XOFFSET_6                      = 0x284D0, // SAME 
  EG_PA_CL_VPORT_YSCALE_6                       = 0x284D4, // SAME 
  EG_PA_CL_VPORT_YOFFSET_6                      = 0x284D8, // SAME 
  EG_PA_CL_VPORT_ZSCALE_6                       = 0x284DC, // SAME 
  EG_PA_CL_VPORT_ZOFFSET_6                      = 0x284E0, // SAME 
  EG_PA_CL_VPORT_XSCALE_7                       = 0x284E4, // SAME 
  EG_PA_CL_VPORT_XOFFSET_7                      = 0x284E8, // SAME 
  EG_PA_CL_VPORT_YSCALE_7                       = 0x284EC, // SAME 
  EG_PA_CL_VPORT_YOFFSET_7                      = 0x284F0, // SAME 
  EG_PA_CL_VPORT_ZSCALE_7                       = 0x284F4, // SAME 
  EG_PA_CL_VPORT_ZOFFSET_7                      = 0x284F8, // SAME 
  EG_PA_CL_VPORT_XSCALE_8                       = 0x284FC, // SAME 
  EG_PA_CL_VPORT_XOFFSET_8                      = 0x28500, // SAME 
  EG_PA_CL_VPORT_YSCALE_8                       = 0x28504, // SAME 
  EG_PA_CL_VPORT_YOFFSET_8                      = 0x28508, // SAME 
  EG_PA_CL_VPORT_ZSCALE_8                       = 0x2850C, // SAME 
  EG_PA_CL_VPORT_ZOFFSET_8                      = 0x28510, // SAME 
  EG_PA_CL_VPORT_XSCALE_9                       = 0x28514, // SAME 
  EG_PA_CL_VPORT_XOFFSET_9                      = 0x28518, // SAME 
  EG_PA_CL_VPORT_YSCALE_9                       = 0x2851C, // SAME 
  EG_PA_CL_VPORT_YOFFSET_9                      = 0x28520, // SAME 
  EG_PA_CL_VPORT_ZSCALE_9                       = 0x28524, // SAME 
  EG_PA_CL_VPORT_ZOFFSET_9                      = 0x28528, // SAME 
  EG_PA_CL_VPORT_XSCALE_10                      = 0x2852C, // SAME 
  EG_PA_CL_VPORT_XOFFSET_10                     = 0x28530, // SAME 
  EG_PA_CL_VPORT_YSCALE_10                      = 0x28534, // SAME 
  EG_PA_CL_VPORT_YOFFSET_10                     = 0x28538, // SAME 
  EG_PA_CL_VPORT_ZSCALE_10                      = 0x2853C, // SAME 
  EG_PA_CL_VPORT_ZOFFSET_10                     = 0x28540, // SAME 
  EG_PA_CL_VPORT_XSCALE_11                      = 0x28544, // SAME 
  EG_PA_CL_VPORT_XOFFSET_11                     = 0x28548, // SAME 
  EG_PA_CL_VPORT_YSCALE_11                      = 0x2854C, // SAME 
  EG_PA_CL_VPORT_YOFFSET_11                     = 0x28550, // SAME 
  EG_PA_CL_VPORT_ZSCALE_11                      = 0x28554, // SAME 
  EG_PA_CL_VPORT_ZOFFSET_11                     = 0x28558, // SAME 
  EG_PA_CL_VPORT_XSCALE_12                      = 0x2855C, // SAME 
  EG_PA_CL_VPORT_XOFFSET_12                     = 0x28560, // SAME 
  EG_PA_CL_VPORT_YSCALE_12                      = 0x28564, // SAME 
  EG_PA_CL_VPORT_YOFFSET_12                     = 0x28568, // SAME 
  EG_PA_CL_VPORT_ZSCALE_12                      = 0x2856C, // SAME 
  EG_PA_CL_VPORT_ZOFFSET_12                     = 0x28570, // SAME 
  EG_PA_CL_VPORT_XSCALE_13                      = 0x28574, // SAME 
  EG_PA_CL_VPORT_XOFFSET_13                     = 0x28578, // SAME 
  EG_PA_CL_VPORT_YSCALE_13                      = 0x2857C, // SAME 
  EG_PA_CL_VPORT_YOFFSET_13                     = 0x28580, // SAME 
  EG_PA_CL_VPORT_ZSCALE_13                      = 0x28584, // SAME 
  EG_PA_CL_VPORT_ZOFFSET_13                     = 0x28588, // SAME 
  EG_PA_CL_VPORT_XSCALE_14                      = 0x2858C, // SAME 
  EG_PA_CL_VPORT_XOFFSET_14                     = 0x28590, // SAME 
  EG_PA_CL_VPORT_YSCALE_14                      = 0x28594, // SAME 
  EG_PA_CL_VPORT_YOFFSET_14                     = 0x28598, // SAME 
  EG_PA_CL_VPORT_ZSCALE_14                      = 0x2859C, // SAME 
  EG_PA_CL_VPORT_ZOFFSET_14                     = 0x285A0, // SAME 
  EG_PA_CL_VPORT_XSCALE_15                      = 0x285A4, // SAME 
  EG_PA_CL_VPORT_XOFFSET_15                     = 0x285A8, // SAME 
  EG_PA_CL_VPORT_YSCALE_15                      = 0x285AC, // SAME 
  EG_PA_CL_VPORT_YOFFSET_15                     = 0x285B0, // SAME 
  EG_PA_CL_VPORT_ZSCALE_15                      = 0x285B4, // SAME 
  EG_PA_CL_VPORT_ZOFFSET_15                     = 0x285B8, // SAME 
  EG_PA_CL_UCP_0_X                              = 0x285BC, // SAME 0x28E20 
  EG_PA_CL_UCP_0_Y                              = 0x285C0, // SAME 0x28E24 
  EG_PA_CL_UCP_0_Z                              = 0x285C4, // SAME 0x28E28 
  EG_PA_CL_UCP_0_W                              = 0x285C8, // SAME 0x28E2C 
  EG_PA_CL_UCP_1_X                              = 0x285CC, // SAME 0x28E30 
  EG_PA_CL_UCP_1_Y                              = 0x285D0, // SAME 0x28E34 
  EG_PA_CL_UCP_1_Z                              = 0x285D4, // SAME 0x28E38 
  EG_PA_CL_UCP_1_W                              = 0x285D8, // SAME 0x28E3C 
  EG_PA_CL_UCP_2_X                              = 0x285DC, // SAME 0x28E40 
  EG_PA_CL_UCP_2_Y                              = 0x285E0, // SAME 0x28E44 
  EG_PA_CL_UCP_2_Z                              = 0x285E4, // SAME 0x28E48 
  EG_PA_CL_UCP_2_W                              = 0x285E8, // SAME 0x28E4C 
  EG_PA_CL_UCP_3_X                              = 0x285EC, // SAME 0x28E50 
  EG_PA_CL_UCP_3_Y                              = 0x285F0, // SAME 0x28E54 
  EG_PA_CL_UCP_3_Z                              = 0x285F4, // SAME 0x28E58 
  EG_PA_CL_UCP_3_W                              = 0x285F8, // SAME 0x28E5C 
  EG_PA_CL_UCP_4_X                              = 0x285FC, // SAME 0x28E60 
  EG_PA_CL_UCP_4_Y                              = 0x28600, // SAME 0x28E64 
  EG_PA_CL_UCP_4_Z                              = 0x28604, // SAME 0x28E68 
  EG_PA_CL_UCP_4_W                              = 0x28608, // SAME 0x28E6C 
  EG_PA_CL_UCP_5_X                              = 0x2860C, // SAME 0x28E70 
  EG_PA_CL_UCP_5_Y                              = 0x28610, // SAME 0x28E74 
  EG_PA_CL_UCP_5_Z                              = 0x28614, // SAME 0x28E78 
  EG_PA_CL_UCP_5_W                              = 0x28618, // SAME 0x28E7C 
  EG_PA_CL_POINT_X_RAD                          = 0x287D4, // SAME 0x28E10 
  EG_PA_CL_POINT_Y_RAD                          = 0x287D8, // SAME 0x28E14 
  EG_PA_CL_POINT_SIZE                           = 0x287DC, // SAME 0x28E18 
  EG_PA_CL_POINT_CULL_RAD                       = 0x287E0, // SAME 0x28E1C 
  EG_PA_CL_CLIP_CNTL                            = 0x28810, // SAME 
  EG_PA_SU_SC_MODE_CNTL                         = 0x28814, // SAME 
  EG_PA_CL_VTE_CNTL                             = 0x28818, // SAME 
  EG_PA_CL_VS_OUT_CNTL                          = 0x2881C, // SAME 
  EG_PA_CL_NANINF_CNTL                          = 0x28820, // SAME 
  EG_PA_SU_LINE_STIPPLE_CNTL                    = 0x28824, // 
  EG_PA_SU_LINE_STIPPLE_SCALE                   = 0x28828, // 
  EG_PA_SU_PRIM_FILTER_CNTL                     = 0x2882C, // 
  EG_PA_SU_POINT_SIZE                           = 0x28A00, // SAME 
  EG_PA_SU_POINT_MINMAX                         = 0x28A04, // SAME 
  EG_PA_SU_LINE_CNTL                            = 0x28A08, // SAME 
  EG_PA_SC_LINE_STIPPLE                         = 0x28A0C, // SAME 
  EG_PA_SC_MODE_CNTL_0                          = 0x28A48, // 
  EG_PA_SC_MODE_CNTL_1                          = 0x28A4C, // 
  EG_PA_SU_POLY_OFFSET_DB_FMT_CNTL              = 0x28B78, // SAME 0x28DF8 
  EG_PA_SU_POLY_OFFSET_CLAMP                    = 0x28B7C, // SAME 0x28DFC 
  EG_PA_SU_POLY_OFFSET_FRONT_SCALE              = 0x28B80, // SAME 0x28E00 
  EG_PA_SU_POLY_OFFSET_FRONT_OFFSET             = 0x28B84, // SAME 0x28E04 
  EG_PA_SU_POLY_OFFSET_BACK_SCALE               = 0x28B88, // SAME 0x28E08 
  EG_PA_SU_POLY_OFFSET_BACK_OFFSET              = 0x28B8C, // SAME 0x28E0C 
  EG_PA_SC_LINE_CNTL                            = 0x28C00, // DIFF 
  EG_PA_SC_AA_CONFIG                            = 0x28C04, // SAME 
  EG_PA_SU_VTX_CNTL                             = 0x28C08, // SAME 
  EG_PA_CL_GB_VERT_CLIP_ADJ                     = 0x28C0C, // SAME 
  EG_PA_CL_GB_VERT_DISC_ADJ                     = 0x28C10, // SAME 
  EG_PA_CL_GB_HORZ_CLIP_ADJ                     = 0x28C14, // SAME 
  EG_PA_CL_GB_HORZ_DISC_ADJ                     = 0x28C18, // SAME 
  EG_PA_SC_AA_SAMPLE_LOCS_0                     = 0x28C1C, // 
  EG_PA_SC_AA_SAMPLE_LOCS_1                     = 0x28C20, // 
  EG_PA_SC_AA_SAMPLE_LOCS_2                     = 0x28C24, // 
  EG_PA_SC_AA_SAMPLE_LOCS_3                     = 0x28C28, // 
  EG_PA_SC_AA_SAMPLE_LOCS_4                     = 0x28C2C, // 
  EG_PA_SC_AA_SAMPLE_LOCS_5                     = 0x28C30, // 
  EG_PA_SC_AA_SAMPLE_LOCS_6                     = 0x28C34, // 
  EG_PA_SC_AA_SAMPLE_LOCS_7                     = 0x28C38, // 
  EG_PA_SC_AA_MASK                              = 0x28C3C, // SAME 0x28C48 

/* Registers from VGT block: */ 
  EG_VGT_INDEX_TYPE                             = 0x895C,  //? config space
  EG_VGT_PRIMITIVE_TYPE                         = 0x8958,  //? config space
    
  EG_VGT_MAX_VTX_INDX                           = 0x28400, // SAME 
  EG_VGT_MIN_VTX_INDX                           = 0x28404, // SAME 
  EG_VGT_INDX_OFFSET                            = 0x28408, // SAME 
  EG_VGT_MULTI_PRIM_IB_RESET_INDX               = 0x2840C, // SAME 
  EG_CS_COPY_STATE                              = 0x287CC, // 
  EG_GFX_COPY_STATE                             = 0x287D0, // SAME 
  EG_VGT_DMA_BASE_HI                            = 0x287E4, // SAME 
  EG_VGT_DMA_BASE                               = 0x287E8, // SAME 
  EG_VGT_DRAW_INITIATOR                         = 0x287F0, // SAME 
  EG_VGT_IMMED_DATA                             = 0x287F4, // SAME 
  EG_VGT_EVENT_ADDRESS_REG                      = 0x287F8, // SAME 
  EG_VGT_OUTPUT_PATH_CNTL                       = 0x28A10, // DIFF 
  EG_VGT_HOS_CNTL                               = 0x28A14, // SAME 
  EG_VGT_HOS_MAX_TESS_LEVEL                     = 0x28A18, // SAME 
  EG_VGT_HOS_MIN_TESS_LEVEL                     = 0x28A1C, // SAME 
  EG_VGT_HOS_REUSE_DEPTH                        = 0x28A20, // SAME 
  EG_VGT_GROUP_PRIM_TYPE                        = 0x28A24, // SAME 
  EG_VGT_GROUP_FIRST_DECR                       = 0x28A28, // SAME 
  EG_VGT_GROUP_DECR                             = 0x28A2C, // SAME 
  EG_VGT_GROUP_VECT_0_CNTL                      = 0x28A30, // SAME 
  EG_VGT_GROUP_VECT_1_CNTL                      = 0x28A34, // SAME 
  EG_VGT_GROUP_VECT_0_FMT_CNTL                  = 0x28A38, // SAME 
  EG_VGT_GROUP_VECT_1_FMT_CNTL                  = 0x28A3C, // SAME 
  EG_VGT_GS_MODE                                = 0x28A40, // DIFF 
  EG_VGT_ENHANCE                                = 0x28A50, // DIFF 
  EG_VGT_GS_PER_ES                              = 0x28A54, // DIFF 0x88C8 
  EG_VGT_ES_PER_GS                              = 0x28A58, // DIFF 0x88CC 
  EG_VGT_GS_PER_VS                              = 0x28A5C, // SAME 0x88E8 
  EG_VGT_GS_OUT_PRIM_TYPE                       = 0x28A6C, // SAME 
  EG_VGT_DMA_SIZE                               = 0x28A74, // SAME 
  EG_VGT_DMA_MAX_SIZE                           = 0x28A78, // SAME 
  EG_VGT_DMA_INDEX_TYPE                         = 0x28A7C, // SAME 
  EG_VGT_PRIMITIVEID_EN                         = 0x28A84, // SAME 
  EG_VGT_DMA_NUM_INSTANCES                      = 0x28A88, // SAME 
  EG_VGT_EVENT_INITIATOR                        = 0x28A90, // SAME 
  EG_VGT_MULTI_PRIM_IB_RESET_EN                 = 0x28A94, // SAME 
  EG_VGT_INSTANCE_STEP_RATE_0                   = 0x28AA0, // SAME 
  EG_VGT_INSTANCE_STEP_RATE_1                   = 0x28AA4, // SAME 
  EG_VGT_REUSE_OFF                              = 0x28AB4, // SAME 
  EG_VGT_VTX_CNT_EN                             = 0x28AB8, // SAME 
  EG_VGT_STRMOUT_BUFFER_SIZE_0                  = 0x28AD0, // SAME 
  EG_VGT_STRMOUT_VTX_STRIDE_0                   = 0x28AD4, // SAME 
  EG_VGT_STRMOUT_BUFFER_BASE_0                  = 0x28AD8, // SAME 
  EG_VGT_STRMOUT_BUFFER_OFFSET_0                = 0x28ADC, // SAME 
  EG_VGT_STRMOUT_BUFFER_SIZE_1                  = 0x28AE0, // SAME 
  EG_VGT_STRMOUT_VTX_STRIDE_1                   = 0x28AE4, // SAME 
  EG_VGT_STRMOUT_BUFFER_BASE_1                  = 0x28AE8, // SAME 
  EG_VGT_STRMOUT_BUFFER_OFFSET_1                = 0x28AEC, // SAME 
  EG_VGT_STRMOUT_BUFFER_SIZE_2                  = 0x28AF0, // SAME 
  EG_VGT_STRMOUT_VTX_STRIDE_2                   = 0x28AF4, // SAME 
  EG_VGT_STRMOUT_BUFFER_BASE_2                  = 0x28AF8, // SAME 
  EG_VGT_STRMOUT_BUFFER_OFFSET_2                = 0x28AFC, // SAME 
  EG_VGT_STRMOUT_BUFFER_SIZE_3                  = 0x28B00, // SAME 
  EG_VGT_STRMOUT_VTX_STRIDE_3                   = 0x28B04, // SAME 
  EG_VGT_STRMOUT_BUFFER_BASE_3                  = 0x28B08, // SAME 
  EG_VGT_STRMOUT_BUFFER_OFFSET_3                = 0x28B0C, // SAME 
  EG_VGT_STRMOUT_BASE_OFFSET_0                  = 0x28B10, // SAME 
  EG_VGT_STRMOUT_BASE_OFFSET_1                  = 0x28B14, // SAME 
  EG_VGT_STRMOUT_BASE_OFFSET_2                  = 0x28B18, // SAME 
  EG_VGT_STRMOUT_BASE_OFFSET_3                  = 0x28B1C, // SAME 
  EG_VGT_STRMOUT_DRAW_OPAQUE_OFFSET             = 0x28B28, // SAME 
  EG_VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE = 0x28B2C, // SAME 
  EG_VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE      = 0x28B30, // DIFF 
  EG_VGT_GS_MAX_VERT_OUT                        = 0x28B38, // SAME 
  EG_VGT_STRMOUT_BASE_OFFSET_HI_0               = 0x28B44, // SAME 
  EG_VGT_STRMOUT_BASE_OFFSET_HI_1               = 0x28B48, // SAME 
  EG_VGT_STRMOUT_BASE_OFFSET_HI_2               = 0x28B4C, // SAME 
  EG_VGT_STRMOUT_BASE_OFFSET_HI_3               = 0x28B50, // SAME 
  EG_VGT_SHADER_STAGES_EN                       = 0x28B54, // 
  EG_VGT_LS_HS_CONFIG                           = 0x28B58, // 
  EG_VGT_LS_SIZE                                = 0x28B5C, // 
  EG_VGT_HS_SIZE                                = 0x28B60, // 
  EG_VGT_LS_HS_ALLOC                            = 0x28B64, // 
  EG_VGT_HS_PATCH_CONST                         = 0x28B68, // 
  EG_VGT_TF_PARAM                               = 0x28B6C, // 
  EG_VGT_DISPATCH_INITIATOR                     = 0x28B74, // 
  EG_VGT_GS_INSTANCE_CNT                        = 0x28B90, // 
  EG_VGT_STRMOUT_CONFIG                         = 0x28B94, // 
  EG_VGT_STRMOUT_BUFFER_CONFIG                  = 0x28B98, // 
  EG_VGT_VERTEX_REUSE_BLOCK_CNTL                = 0x28C58, // SAME 
  EG_VGT_OUT_DEALLOC_CNTL                       = 0x28C5C, // SAME 

/* Registers from TP block: */ 	
  EG_GDS_ADDR_BASE                              = 0x28720, // 
  EG_GDS_ADDR_SIZE                              = 0x28724, // 
  EG_GDS_ORDERED_WAVE_PER_SE                    = 0x28728, // 
  EG_GDS_APPEND_CONSUME_UAV0                    = 0x2872C, // 
  EG_GDS_APPEND_CONSUME_UAV1                    = 0x28730, // 
  EG_GDS_APPEND_CONSUME_UAV2                    = 0x28734, // 
  EG_GDS_APPEND_CONSUME_UAV3                    = 0x28738, // 
  EG_GDS_APPEND_CONSUME_UAV4                    = 0x2873C, // 
  EG_GDS_APPEND_CONSUME_UAV5                    = 0x28740, // 
  EG_GDS_APPEND_CONSUME_UAV6                    = 0x28744, // 
  EG_GDS_APPEND_CONSUME_UAV7                    = 0x28748, // 
  EG_GDS_APPEND_CONSUME_UAV8                    = 0x2874C, // 
  EG_GDS_APPEND_CONSUME_UAV9                    = 0x28750, // 
  EG_GDS_APPEND_CONSUME_UAV10                   = 0x28754, // 
  EG_GDS_APPEND_CONSUME_UAV11                   = 0x28758, // 

/* Registers from SQ block: */ 	
  EG_SQ_LOOP_CONST_0                            = 0x3A200, //      0x3E200
  EG_SQ_ALU_CONST_BUFFER_SIZE_VS_0              = 0x28180, // ?
  EG_SQ_VTX_SEMANTIC_0                          = 0x28380, // SAME
  EG_SQ_VTX_SEMANTIC_1                          = 0x28384, // SAME
  EG_SQ_VTX_SEMANTIC_2                          = 0x28388, // SAME
  EG_SQ_VTX_SEMANTIC_3                          = 0x2838C, // SAME
  EG_SQ_VTX_SEMANTIC_4                          = 0x28390, // SAME
  EG_SQ_VTX_SEMANTIC_5                          = 0x28394, // SAME
  EG_SQ_VTX_SEMANTIC_6                          = 0x28398, // SAME 
  EG_SQ_VTX_SEMANTIC_7                          = 0x2839C, // SAME 
  EG_SQ_VTX_SEMANTIC_8                          = 0x283A0, // SAME 
  EG_SQ_VTX_SEMANTIC_9                          = 0x283A4, // SAME 
  EG_SQ_VTX_SEMANTIC_10                         = 0x283A8, // SAME 
  EG_SQ_VTX_SEMANTIC_11                         = 0x283AC, // SAME 
  EG_SQ_VTX_SEMANTIC_12                         = 0x283B0, // SAME 
  EG_SQ_VTX_SEMANTIC_13                         = 0x283B4, // SAME 
  EG_SQ_VTX_SEMANTIC_14                         = 0x283B8, // SAME 
  EG_SQ_VTX_SEMANTIC_15                         = 0x283BC, // SAME 
  EG_SQ_VTX_SEMANTIC_16                         = 0x283C0, // SAME 
  EG_SQ_VTX_SEMANTIC_17                         = 0x283C4, // SAME 
  EG_SQ_VTX_SEMANTIC_18                         = 0x283C8, // SAME 
  EG_SQ_VTX_SEMANTIC_19                         = 0x283CC, // SAME 
  EG_SQ_VTX_SEMANTIC_20                         = 0x283D0, // SAME 
  EG_SQ_VTX_SEMANTIC_21                         = 0x283D4, // SAME 
  EG_SQ_VTX_SEMANTIC_22                         = 0x283D8, // SAME 
  EG_SQ_VTX_SEMANTIC_23                         = 0x283DC, // SAME 
  EG_SQ_VTX_SEMANTIC_24                         = 0x283E0, // SAME 
  EG_SQ_VTX_SEMANTIC_25                         = 0x283E4, // SAME 
  EG_SQ_VTX_SEMANTIC_26                         = 0x283E8, // SAME 
  EG_SQ_VTX_SEMANTIC_27                         = 0x283EC, // SAME 
  EG_SQ_VTX_SEMANTIC_28                         = 0x283F0, // SAME 
  EG_SQ_VTX_SEMANTIC_29                         = 0x283F4, // SAME 
  EG_SQ_VTX_SEMANTIC_30                         = 0x283F8, // SAME 
  EG_SQ_VTX_SEMANTIC_31                         = 0x283FC, // SAME 
  EG_SQ_LSTMP_RING_ITEMSIZE                     = 0x28830, // 
  EG_SQ_HSTMP_RING_ITEMSIZE                     = 0x28834, // 
  EG_SQ_DYN_GPR_RESOURCE_LIMIT_1                = 0x28838, // 
  EG_SQ_PGM_START_PS                            = 0x28840, // SAME 
  EG_SQ_PGM_RESOURCES_PS                        = 0x28844, // DIFF 0x28850 
  EG_SQ_PGM_RESOURCES_2_PS                      = 0x28848, // 
  EG_SQ_PGM_EXPORTS_PS                          = 0x2884C, // SAME 0x28854 
  EG_SQ_PGM_START_VS                            = 0x2885C, // SAME 0x28858 
  EG_SQ_PGM_RESOURCES_VS                        = 0x28860, // DIFF 0x28868 
  EG_SQ_PGM_RESOURCES_2_VS                      = 0x28864, // 
  EG_SQ_PGM_START_GS                            = 0x28874, // SAME 0x2886C 
  EG_SQ_PGM_RESOURCES_GS                        = 0x28878, // DIFF 0x2887C 
  EG_SQ_PGM_RESOURCES_2_GS                      = 0x2887C, // 
  EG_SQ_PGM_START_ES                            = 0x2888C, // SAME 0x28880 
  EG_SQ_PGM_RESOURCES_ES                        = 0x28890, // DIFF 
  EG_SQ_PGM_RESOURCES_2_ES                      = 0x28894, // 
  EG_SQ_PGM_START_FS                            = 0x288A4, // SAME 0x28894 
  EG_SQ_PGM_RESOURCES_FS                        = 0x288A8, // DIFF 0x288A4 
  EG_SQ_PGM_START_HS                            = 0x288B8, // 
  EG_SQ_PGM_RESOURCES_HS                        = 0x288BC, // 
  EG_SQ_PGM_RESOURCES_2_HS                      = 0x288C0, // 
  EG_SQ_PGM_START_LS                            = 0x288D0, // 
  EG_SQ_PGM_RESOURCES_LS                        = 0x288D4, // 
  EG_SQ_PGM_RESOURCES_2_LS                      = 0x288D8, // 
  EG_SQ_THREAD_TRACE_USERDATA                   = 0x288DC, // 
  EG_SQ_LDS_ALLOC                               = 0x288E8, // 
  EG_SQ_LDS_ALLOC_PS                            = 0x288EC, // 
  EG_SQ_VTX_SEMANTIC_CLEAR                      = 0x288F0, // SAME 0x288E0 
  EG_SQ_THREAD_TRACE_CTRL                       = 0x288F8, // 
  EG_SQ_ESGS_RING_ITEMSIZE                      = 0x28900, // SAME 0x288A8 
  EG_SQ_GSVS_RING_ITEMSIZE                      = 0x28904, // SAME 0x288AC 
  EG_SQ_ESTMP_RING_ITEMSIZE                     = 0x28908, // SAME 0x288B0 
  EG_SQ_GSTMP_RING_ITEMSIZE                     = 0x2890C, // SAME 0x288B4 
  EG_SQ_VSTMP_RING_ITEMSIZE                     = 0x28910, // SAME 0x288B8 
  EG_SQ_PSTMP_RING_ITEMSIZE                     = 0x28914, // SAME 0x288BC 
  EG_SQ_GS_VERT_ITEMSIZE                        = 0x2891C, // SAME 0x288C8 
  EG_SQ_GS_VERT_ITEMSIZE_1                      = 0x28920, // 
  EG_SQ_GS_VERT_ITEMSIZE_2                      = 0x28924, // 
  EG_SQ_GS_VERT_ITEMSIZE_3                      = 0x28928, // 
  EG_SQ_GSVS_RING_OFFSET_1                      = 0x2892C, // 
  EG_SQ_GSVS_RING_OFFSET_2                      = 0x28930, // 
  EG_SQ_GSVS_RING_OFFSET_3                      = 0x28934, // 
  EG_SQ_ALU_CONST_CACHE_PS_0                    = 0x28940, // SAME 
  EG_SQ_ALU_CONST_CACHE_PS_1                    = 0x28944, // SAME 
  EG_SQ_ALU_CONST_CACHE_PS_2                    = 0x28948, // SAME 
  EG_SQ_ALU_CONST_CACHE_PS_3                    = 0x2894C, // SAME 
  EG_SQ_ALU_CONST_CACHE_PS_4                    = 0x28950, // SAME 
  EG_SQ_ALU_CONST_CACHE_PS_5                    = 0x28954, // SAME 
  EG_SQ_ALU_CONST_CACHE_PS_6                    = 0x28958, // SAME 
  EG_SQ_ALU_CONST_CACHE_PS_7                    = 0x2895C, // SAME 
  EG_SQ_ALU_CONST_CACHE_PS_8                    = 0x28960, // SAME 
  EG_SQ_ALU_CONST_CACHE_PS_9                    = 0x28964, // SAME 
  EG_SQ_ALU_CONST_CACHE_PS_10                   = 0x28968, // SAME 
  EG_SQ_ALU_CONST_CACHE_PS_11                   = 0x2896C, // SAME 
  EG_SQ_ALU_CONST_CACHE_PS_12                   = 0x28970, // SAME 
  EG_SQ_ALU_CONST_CACHE_PS_13                   = 0x28974, // SAME 
  EG_SQ_ALU_CONST_CACHE_PS_14                   = 0x28978, // SAME 
  EG_SQ_ALU_CONST_CACHE_PS_15                   = 0x2897C, // SAME 
  EG_SQ_ALU_CONST_CACHE_VS_0                    = 0x28980, // SAME 
  EG_SQ_ALU_CONST_CACHE_VS_1                    = 0x28984, // SAME 
  EG_SQ_ALU_CONST_CACHE_VS_2                    = 0x28988, // SAME 
  EG_SQ_ALU_CONST_CACHE_VS_3                    = 0x2898C, // SAME 
  EG_SQ_ALU_CONST_CACHE_VS_4                    = 0x28990, // SAME 
  EG_SQ_ALU_CONST_CACHE_VS_5                    = 0x28994, // SAME 
  EG_SQ_ALU_CONST_CACHE_VS_6                    = 0x28998, // SAME 
  EG_SQ_ALU_CONST_CACHE_VS_7                    = 0x2899C, // SAME 
  EG_SQ_ALU_CONST_CACHE_VS_8                    = 0x289A0, // SAME 
  EG_SQ_ALU_CONST_CACHE_VS_9                    = 0x289A4, // SAME 
  EG_SQ_ALU_CONST_CACHE_VS_10                   = 0x289A8, // SAME 
  EG_SQ_ALU_CONST_CACHE_VS_11                   = 0x289AC, // SAME 
  EG_SQ_ALU_CONST_CACHE_VS_12                   = 0x289B0, // SAME 
  EG_SQ_ALU_CONST_CACHE_VS_13                   = 0x289B4, // SAME 
  EG_SQ_ALU_CONST_CACHE_VS_14                   = 0x289B8, // SAME 
  EG_SQ_ALU_CONST_CACHE_VS_15                   = 0x289BC, // SAME 
  EG_SQ_ALU_CONST_CACHE_GS_0                    = 0x289C0, // SAME 
  EG_SQ_ALU_CONST_CACHE_GS_1                    = 0x289C4, // SAME 
  EG_SQ_ALU_CONST_CACHE_GS_2                    = 0x289C8, // SAME 
  EG_SQ_ALU_CONST_CACHE_GS_3                    = 0x289CC, // SAME 
  EG_SQ_ALU_CONST_CACHE_GS_4                    = 0x289D0, // SAME 
  EG_SQ_ALU_CONST_CACHE_GS_5                    = 0x289D4, // SAME 
  EG_SQ_ALU_CONST_CACHE_GS_6                    = 0x289D8, // SAME 
  EG_SQ_ALU_CONST_CACHE_GS_7                    = 0x289DC, // SAME 
  EG_SQ_ALU_CONST_CACHE_GS_8                    = 0x289E0, // SAME 
  EG_SQ_ALU_CONST_CACHE_GS_9                    = 0x289E4, // SAME 
  EG_SQ_ALU_CONST_CACHE_GS_10                   = 0x289E8, // SAME 
  EG_SQ_ALU_CONST_CACHE_GS_11                   = 0x289EC, // SAME 
  EG_SQ_ALU_CONST_CACHE_GS_12                   = 0x289F0, // SAME 
  EG_SQ_ALU_CONST_CACHE_GS_13                   = 0x289F4, // SAME 
  EG_SQ_ALU_CONST_CACHE_GS_14                   = 0x289F8, // SAME 
  EG_SQ_ALU_CONST_CACHE_GS_15                   = 0x289FC, // SAME 
  EG_SQ_ALU_CONST_CACHE_HS_0                    = 0x28F00, // 
  EG_SQ_ALU_CONST_CACHE_HS_1                    = 0x28F04, // 
  EG_SQ_ALU_CONST_CACHE_HS_2                    = 0x28F08, // 
  EG_SQ_ALU_CONST_CACHE_HS_3                    = 0x28F0C, // 
  EG_SQ_ALU_CONST_CACHE_HS_4                    = 0x28F10, // 
  EG_SQ_ALU_CONST_CACHE_HS_5                    = 0x28F14, // 
  EG_SQ_ALU_CONST_CACHE_HS_6                    = 0x28F18, // 
  EG_SQ_ALU_CONST_CACHE_HS_7                    = 0x28F1C, // 
  EG_SQ_ALU_CONST_CACHE_HS_8                    = 0x28F20, // 
  EG_SQ_ALU_CONST_CACHE_HS_9                    = 0x28F24, // 
  EG_SQ_ALU_CONST_CACHE_HS_10                   = 0x28F28, // 
  EG_SQ_ALU_CONST_CACHE_HS_11                   = 0x28F2C, // 
  EG_SQ_ALU_CONST_CACHE_HS_12                   = 0x28F30, // 
  EG_SQ_ALU_CONST_CACHE_HS_13                   = 0x28F34, // 
  EG_SQ_ALU_CONST_CACHE_HS_14                   = 0x28F38, // 
  EG_SQ_ALU_CONST_CACHE_HS_15                   = 0x28F3C, // 
  EG_SQ_ALU_CONST_CACHE_LS_0                    = 0x28F40, // 
  EG_SQ_ALU_CONST_CACHE_LS_1                    = 0x28F44, // 
  EG_SQ_ALU_CONST_CACHE_LS_2                    = 0x28F48, // 
  EG_SQ_ALU_CONST_CACHE_LS_3                    = 0x28F4C, // 
  EG_SQ_ALU_CONST_CACHE_LS_4                    = 0x28F50, // 
  EG_SQ_ALU_CONST_CACHE_LS_5                    = 0x28F54, // 
  EG_SQ_ALU_CONST_CACHE_LS_6                    = 0x28F58, // 
  EG_SQ_ALU_CONST_CACHE_LS_7                    = 0x28F5C, // 
  EG_SQ_ALU_CONST_CACHE_LS_8                    = 0x28F60, // 
  EG_SQ_ALU_CONST_CACHE_LS_9                    = 0x28F64, // 
  EG_SQ_ALU_CONST_CACHE_LS_10                   = 0x28F68, // 
  EG_SQ_ALU_CONST_CACHE_LS_11                   = 0x28F6C, // 
  EG_SQ_ALU_CONST_CACHE_LS_12                   = 0x28F70, // 
  EG_SQ_ALU_CONST_CACHE_LS_13                   = 0x28F74, // 
  EG_SQ_ALU_CONST_CACHE_LS_14                   = 0x28F78, // 
  EG_SQ_ALU_CONST_CACHE_LS_15                   = 0x28F7C, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_PS_0              = 0x28140,
  EG_SQ_ALU_CONST_BUFFER_SIZE_HS_0              = 0x28F80, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_HS_1              = 0x28F84, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_HS_2              = 0x28F88, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_HS_3              = 0x28F8C, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_HS_4              = 0x28F90, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_HS_5              = 0x28F94, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_HS_6              = 0x28F98, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_HS_7              = 0x28F9C, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_HS_8              = 0x28FA0, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_HS_9              = 0x28FA4, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_HS_10             = 0x28FA8, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_HS_11             = 0x28FAC, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_HS_12             = 0x28FB0, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_HS_13             = 0x28FB4, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_HS_14             = 0x28FB8, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_HS_15             = 0x28FBC, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_LS_0              = 0x28FC0, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_LS_1              = 0x28FC4, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_LS_2              = 0x28FC8, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_LS_3              = 0x28FCC, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_LS_4              = 0x28FD0, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_LS_5              = 0x28FD4, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_LS_6              = 0x28FD8, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_LS_7              = 0x28FDC, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_LS_8              = 0x28FE0, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_LS_9              = 0x28FE4, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_LS_10             = 0x28FE8, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_LS_11             = 0x28FEC, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_LS_12             = 0x28FF0, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_LS_13             = 0x28FF4, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_LS_14             = 0x28FF8, // 
  EG_SQ_ALU_CONST_BUFFER_SIZE_LS_15             = 0x28FFC, // 

/* Registers from SPI block: */ 	
  EG_SPI_VS_OUT_ID_0                            = 0x2861C, // SAME 0x28614 
  EG_SPI_VS_OUT_ID_1                            = 0x28620, // SAME 0x28618 
  EG_SPI_VS_OUT_ID_2                            = 0x28624, // SAME 0x2861C 
  EG_SPI_VS_OUT_ID_3                            = 0x28628, // SAME 0x28620 
  EG_SPI_VS_OUT_ID_4                            = 0x2862C, // SAME 0x28624 
  EG_SPI_VS_OUT_ID_5                            = 0x28630, // SAME 0x28628 
  EG_SPI_VS_OUT_ID_6                            = 0x28634, // SAME 0x2862C 
  EG_SPI_VS_OUT_ID_7                            = 0x28638, // SAME 0x28630 
  EG_SPI_VS_OUT_ID_8                            = 0x2863C, // SAME 0x28634 
  EG_SPI_VS_OUT_ID_9                            = 0x28640, // SAME 0x28638 
  EG_SPI_PS_INPUT_CNTL_0                        = 0x28644, // SAME 
  EG_SPI_PS_INPUT_CNTL_1                        = 0x28648, // SAME 
  EG_SPI_PS_INPUT_CNTL_2                        = 0x2864C, // SAME 
  EG_SPI_PS_INPUT_CNTL_3                        = 0x28650, // SAME 
  EG_SPI_PS_INPUT_CNTL_4                        = 0x28654, // SAME 
  EG_SPI_PS_INPUT_CNTL_5                        = 0x28658, // SAME 
  EG_SPI_PS_INPUT_CNTL_6                        = 0x2865C, // SAME 
  EG_SPI_PS_INPUT_CNTL_7                        = 0x28660, // SAME 
  EG_SPI_PS_INPUT_CNTL_8                        = 0x28664, // SAME 
  EG_SPI_PS_INPUT_CNTL_9                        = 0x28668, // SAME 
  EG_SPI_PS_INPUT_CNTL_10                       = 0x2866C, // SAME 
  EG_SPI_PS_INPUT_CNTL_11                       = 0x28670, // SAME 
  EG_SPI_PS_INPUT_CNTL_12                       = 0x28674, // SAME 
  EG_SPI_PS_INPUT_CNTL_13                       = 0x28678, // SAME 
  EG_SPI_PS_INPUT_CNTL_14                       = 0x2867C, // SAME 
  EG_SPI_PS_INPUT_CNTL_15                       = 0x28680, // SAME 
  EG_SPI_PS_INPUT_CNTL_16                       = 0x28684, // SAME 
  EG_SPI_PS_INPUT_CNTL_17                       = 0x28688, // SAME 
  EG_SPI_PS_INPUT_CNTL_18                       = 0x2868C, // SAME 
  EG_SPI_PS_INPUT_CNTL_19                       = 0x28690, // SAME 
  EG_SPI_PS_INPUT_CNTL_20                       = 0x28694, // SAME 
  EG_SPI_PS_INPUT_CNTL_21                       = 0x28698, // SAME 
  EG_SPI_PS_INPUT_CNTL_22                       = 0x2869C, // SAME 
  EG_SPI_PS_INPUT_CNTL_23                       = 0x286A0, // SAME 
  EG_SPI_PS_INPUT_CNTL_24                       = 0x286A4, // SAME 
  EG_SPI_PS_INPUT_CNTL_25                       = 0x286A8, // SAME 
  EG_SPI_PS_INPUT_CNTL_26                       = 0x286AC, // SAME 
  EG_SPI_PS_INPUT_CNTL_27                       = 0x286B0, // SAME 
  EG_SPI_PS_INPUT_CNTL_28                       = 0x286B4, // SAME 
  EG_SPI_PS_INPUT_CNTL_29                       = 0x286B8, // SAME 
  EG_SPI_PS_INPUT_CNTL_30                       = 0x286BC, // SAME 
  EG_SPI_PS_INPUT_CNTL_31                       = 0x286C0, // SAME 
  EG_SPI_VS_OUT_CONFIG                          = 0x286C4, // SAME 
  EG_SPI_THREAD_GROUPING                        = 0x286C8, // DIFF 
  EG_SPI_PS_IN_CONTROL_0                        = 0x286CC, // SAME 
  EG_SPI_PS_IN_CONTROL_1                        = 0x286D0, // SAME 
  EG_SPI_INTERP_CONTROL_0                       = 0x286D4, // SAME 
  EG_SPI_INPUT_Z                                = 0x286D8, // SAME 
  EG_SPI_FOG_CNTL                               = 0x286DC, // SAME 
  EG_SPI_BARYC_CNTL                             = 0x286E0, // 
  EG_SPI_PS_IN_CONTROL_2                        = 0x286E4, // 
  EG_SPI_COMPUTE_INPUT_CNTL                     = 0x286E8, // 
  EG_SPI_COMPUTE_NUM_THREAD_X                   = 0x286EC, // 
  EG_SPI_COMPUTE_NUM_THREAD_Y                   = 0x286F0, // 
  EG_SPI_COMPUTE_NUM_THREAD_Z                   = 0x286F4, // 

/* Registers from SX block: */	
  EG_SX_MISC                                    = 0x28350, // SAME 
  EG_SX_SURFACE_SYNC                            = 0x28354, // DIFF 
  EG_SX_ALPHA_TEST_CONTROL                      = 0x28410, // SAME 
  EG_SX_ALPHA_REF                               = 0x28438, // SAME 

/* Registers from DB block: */ 	
  EG_DB_RENDER_CONTROL                          = 0x28000, // DIFF 0x28D0C 
  EG_DB_COUNT_CONTROL                           = 0x28004, // 
  EG_DB_DEPTH_VIEW                              = 0x28008, // DIFF 0x28004 
  EG_DB_RENDER_OVERRIDE                         = 0x2800C, // DIFF 0x28D10 
  EG_DB_RENDER_OVERRIDE2                        = 0x28010, // 
  EG_DB_HTILE_DATA_BASE                         = 0x28014, // SAME 

  EG_DB_STENCIL_CLEAR                           = 0x28028, // SAME 
  EG_DB_DEPTH_CLEAR                             = 0x2802C, // SAME 

  EG_DB_Z_INFO                                  = 0x28040, // 
  EG_DB_STENCIL_INFO                            = 0x28044, // 
  EG_DB_Z_READ_BASE                             = 0x28048, // 
  EG_DB_STENCIL_READ_BASE                       = 0x2804C, // 
  EG_DB_Z_WRITE_BASE                            = 0x28050, // 
  EG_DB_STENCIL_WRITE_BASE                      = 0x28054, // 
  EG_DB_DEPTH_SIZE                              = 0x28058, // DIFF 0x28000 
  EG_DB_DEPTH_SLICE                             = 0x2805C, // 

  EG_DB_STENCILREFMASK                          = 0x28430, // SAME 
  EG_DB_STENCILREFMASK_BF                       = 0x28434, // SAME 
  EG_DB_DEPTH_CONTROL                           = 0x28800, // SAME 
  EG_DB_SHADER_CONTROL                          = 0x2880C, // DIFF 
  EG_DB_HTILE_SURFACE                           = 0x28ABC, // SAME 0x28D24 
  EG_DB_SRESULTS_COMPARE_STATE0                 = 0x28AC0, // SAME 0x28D28 
  EG_DB_SRESULTS_COMPARE_STATE1                 = 0x28AC4, // SAME 0x28D2C 
  EG_DB_PRELOAD_CONTROL                         = 0x28AC8, // SAME 0x28D30 
  EG_DB_ALPHA_TO_MASK                           = 0x28B70, // SAME 0x28D44 

/* Registers from CB block: */ 	
  EG_CB_TARGET_MASK                             = 0x28238, // SAME 
  EG_CB_SHADER_MASK                             = 0x2823C, // SAME 
  EG_CB_BLEND_RED                               = 0x28414, // SAME 
  EG_CB_BLEND_GREEN                             = 0x28418, // SAME 
  EG_CB_BLEND_BLUE                              = 0x2841C, // SAME 
  EG_CB_BLEND_ALPHA                             = 0x28420, // SAME 
  EG_CB_BLEND0_CONTROL                          = 0x28780, // DIFF 
  EG_CB_BLEND1_CONTROL                          = 0x28784, // DIFF 
  EG_CB_BLEND2_CONTROL                          = 0x28788, // DIFF 
  EG_CB_BLEND3_CONTROL                          = 0x2878C, // DIFF 
  EG_CB_BLEND4_CONTROL                          = 0x28790, // DIFF 
  EG_CB_BLEND5_CONTROL                          = 0x28794, // DIFF 
  EG_CB_BLEND6_CONTROL                          = 0x28798, // DIFF 
  EG_CB_BLEND7_CONTROL                          = 0x2879C, // DIFF 
  EG_CB_COLOR_CONTROL                           = 0x28808, // DIFF 
  EG_CB_IMMED0_BASE                             = 0x28B9C, // 
  EG_CB_IMMED1_BASE                             = 0x28BA0, // 
  EG_CB_IMMED2_BASE                             = 0x28BA4, // 
  EG_CB_IMMED3_BASE                             = 0x28BA8, // 
  EG_CB_IMMED4_BASE                             = 0x28BAC, // 
  EG_CB_IMMED5_BASE                             = 0x28BB0, // 
  EG_CB_IMMED6_BASE                             = 0x28BB4, // 
  EG_CB_IMMED7_BASE                             = 0x28BB8, // 
  EG_CB_IMMED8_BASE                             = 0x28BBC, // 
  EG_CB_IMMED9_BASE                             = 0x28BC0, // 
  EG_CB_IMMED10_BASE                            = 0x28BC4, // 
  EG_CB_IMMED11_BASE                            = 0x28BC8, // 
  EG_CB_CLRCMP_CONTROL                          = 0x28C40, // SAME 0x28C30 
  EG_CB_CLRCMP_SRC                              = 0x28C44, // SAME 0x28C34 
  EG_CB_CLRCMP_DST                              = 0x28C48, // SAME 0x28C38 
  EG_CB_CLRCMP_MSK                              = 0x28C4C, // SAME 0x28C3C 
  EG_CB_COLOR0_BASE                             = 0x28C60, // SAME 0x28040 
  EG_CB_COLOR0_PITCH                            = 0x28C64, // 
  EG_CB_COLOR0_SLICE                            = 0x28C68, // 
  EG_CB_COLOR0_VIEW                             = 0x28C6C, // SAME 0x28080 
  EG_CB_COLOR0_INFO                             = 0x28C70, // DIFF 0x280A0 
  EG_CB_COLOR0_ATTRIB                           = 0x28C74, // 
  EG_CB_COLOR0_DIM                              = 0x28C78, // 
  EG_CB_COLOR0_CMASK                            = 0x28C7C, // 
  EG_CB_COLOR0_CMASK_SLICE                      = 0x28C80, // 
  EG_CB_COLOR0_FMASK                            = 0x28C84, // 
  EG_CB_COLOR0_FMASK_SLICE                      = 0x28C88, // 
  EG_CB_COLOR0_CLEAR_WORD0                      = 0x28C8C, // 
  EG_CB_COLOR0_CLEAR_WORD1                      = 0x28C90, // 
  EG_CB_COLOR0_CLEAR_WORD2                      = 0x28C94, // 
  EG_CB_COLOR0_CLEAR_WORD3                      = 0x28C98, // 
  EG_CB_COLOR1_BASE                             = 0x28C9C, // SAME 0x28044 
  EG_CB_COLOR1_PITCH                            = 0x28CA0, // 
  EG_CB_COLOR1_SLICE                            = 0x28CA4, // 
  EG_CB_COLOR1_VIEW                             = 0x28CA8, // SAME 0x28084 
  EG_CB_COLOR1_INFO                             = 0x28CAC, // DIFF 0x280A4 
  EG_CB_COLOR1_ATTRIB                           = 0x28CB0, // 
  EG_CB_COLOR1_DIM                              = 0x28CB4, // 
  EG_CB_COLOR1_CMASK                            = 0x28CB8, // 
  EG_CB_COLOR1_CMASK_SLICE                      = 0x28CBC, // 
  EG_CB_COLOR1_FMASK                            = 0x28CC0, // 
  EG_CB_COLOR1_FMASK_SLICE                      = 0x28CC4, // 
  EG_CB_COLOR1_CLEAR_WORD0                      = 0x28CC8, // 
  EG_CB_COLOR1_CLEAR_WORD1                      = 0x28CCC, // 
  EG_CB_COLOR1_CLEAR_WORD2                      = 0x28CD0, // 
  EG_CB_COLOR1_CLEAR_WORD3                      = 0x28CD4, // 
  EG_CB_COLOR2_BASE                             = 0x28CD8, // SAME 0x28048 
  EG_CB_COLOR2_PITCH                            = 0x28CDC, // 
  EG_CB_COLOR2_SLICE                            = 0x28CE0, // 
  EG_CB_COLOR2_VIEW                             = 0x28CE4, // SAME 0x28088 
  EG_CB_COLOR2_INFO                             = 0x28CE8, // DIFF 0x280A8 
  EG_CB_COLOR2_ATTRIB                           = 0x28CEC, // 
  EG_CB_COLOR2_DIM                              = 0x28CF0, // 
  EG_CB_COLOR2_CMASK                            = 0x28CF4, // 
  EG_CB_COLOR2_CMASK_SLICE                      = 0x28CF8, // 
  EG_CB_COLOR2_FMASK                            = 0x28CFC, // 
  EG_CB_COLOR2_FMASK_SLICE                      = 0x28D00, // 
  EG_CB_COLOR2_CLEAR_WORD0                      = 0x28D04, // 
  EG_CB_COLOR2_CLEAR_WORD1                      = 0x28D08, // 
  EG_CB_COLOR2_CLEAR_WORD2                      = 0x28D0C, // 
  EG_CB_COLOR2_CLEAR_WORD3                      = 0x28D10, // 
  EG_CB_COLOR3_BASE                             = 0x28D14, // SAME 0x2804C 
  EG_CB_COLOR3_PITCH                            = 0x28D18, // 
  EG_CB_COLOR3_SLICE                            = 0x28D1C, // 
  EG_CB_COLOR3_VIEW                             = 0x28D20, // SAME 0x2808C 
  EG_CB_COLOR3_INFO                             = 0x28D24, // DIFF 0x280AC 
  EG_CB_COLOR3_ATTRIB                           = 0x28D28, // 
  EG_CB_COLOR3_DIM                              = 0x28D2C, // 
  EG_CB_COLOR3_CMASK                            = 0x28D30, // 
  EG_CB_COLOR3_CMASK_SLICE                      = 0x28D34, // 
  EG_CB_COLOR3_FMASK                            = 0x28D38, // 
  EG_CB_COLOR3_FMASK_SLICE                      = 0x28D3C, // 
  EG_CB_COLOR3_CLEAR_WORD0                      = 0x28D40, // 
  EG_CB_COLOR3_CLEAR_WORD1                      = 0x28D44, // 
  EG_CB_COLOR3_CLEAR_WORD2                      = 0x28D48, // 
  EG_CB_COLOR3_CLEAR_WORD3                      = 0x28D4C, // 
  EG_CB_COLOR4_BASE                             = 0x28D50, // SAME 0x28050 
  EG_CB_COLOR4_PITCH                            = 0x28D54, // 
  EG_CB_COLOR4_SLICE                            = 0x28D58, // 
  EG_CB_COLOR4_VIEW                             = 0x28D5C, // SAME 0x28090 
  EG_CB_COLOR4_INFO                             = 0x28D60, // DIFF 0x280B0 
  EG_CB_COLOR4_ATTRIB                           = 0x28D64, // 
  EG_CB_COLOR4_DIM                              = 0x28D68, // 
  EG_CB_COLOR4_CMASK                            = 0x28D6C, // 
  EG_CB_COLOR4_CMASK_SLICE                      = 0x28D70, // 
  EG_CB_COLOR4_FMASK                            = 0x28D74, // 
  EG_CB_COLOR4_FMASK_SLICE                      = 0x28D78, // 
  EG_CB_COLOR4_CLEAR_WORD0                      = 0x28D7C, // 
  EG_CB_COLOR4_CLEAR_WORD1                      = 0x28D80, // 
  EG_CB_COLOR4_CLEAR_WORD2                      = 0x28D84, // 
  EG_CB_COLOR4_CLEAR_WORD3                      = 0x28D88, // 
  EG_CB_COLOR5_BASE                             = 0x28D8C, // SAME 0x28054 
  EG_CB_COLOR5_PITCH                            = 0x28D90, // 
  EG_CB_COLOR5_SLICE                            = 0x28D94, // 
  EG_CB_COLOR5_VIEW                             = 0x28D98, // SAME 0x28094 
  EG_CB_COLOR5_INFO                             = 0x28D9C, // DIFF 0x280B4 
  EG_CB_COLOR5_ATTRIB                           = 0x28DA0, // 
  EG_CB_COLOR5_DIM                              = 0x28DA4, // 
  EG_CB_COLOR5_CMASK                            = 0x28DA8, // 
  EG_CB_COLOR5_CMASK_SLICE                      = 0x28DAC, // 
  EG_CB_COLOR5_FMASK                            = 0x28DB0, // 
  EG_CB_COLOR5_FMASK_SLICE                      = 0x28DB4, // 
  EG_CB_COLOR5_CLEAR_WORD0                      = 0x28DB8, // 
  EG_CB_COLOR5_CLEAR_WORD1                      = 0x28DBC, // 
  EG_CB_COLOR5_CLEAR_WORD2                      = 0x28DC0, // 
  EG_CB_COLOR5_CLEAR_WORD3                      = 0x28DC4, // 
  EG_CB_COLOR6_BASE                             = 0x28DC8, // SAME 0x28058 
  EG_CB_COLOR6_PITCH                            = 0x28DCC, // 
  EG_CB_COLOR6_SLICE                            = 0x28DD0, // 
  EG_CB_COLOR6_VIEW                             = 0x28DD4, // SAME 0x28098 
  EG_CB_COLOR6_INFO                             = 0x28DD8, // DIFF 0x280B8 
  EG_CB_COLOR6_ATTRIB                           = 0x28DDC, //
  EG_CB_COLOR6_DIM                              = 0x28DE0, //
  EG_CB_COLOR6_CMASK                            = 0x28DE4, //
  EG_CB_COLOR6_CMASK_SLICE                      = 0x28DE8, //
  EG_CB_COLOR6_FMASK                            = 0x28DEC, //
  EG_CB_COLOR6_FMASK_SLICE                      = 0x28DF0, //
  EG_CB_COLOR6_CLEAR_WORD0                      = 0x28DF4, //
  EG_CB_COLOR6_CLEAR_WORD1                      = 0x28DF8, //
  EG_CB_COLOR6_CLEAR_WORD2                      = 0x28DFC, //
  EG_CB_COLOR6_CLEAR_WORD3                      = 0x28E00, //
  EG_CB_COLOR7_BASE                             = 0x28E04, // SAME 0x2805C 
  EG_CB_COLOR7_PITCH                            = 0x28E08, // 
  EG_CB_COLOR7_SLICE                            = 0x28E0C, // 
  EG_CB_COLOR7_VIEW                             = 0x28E10, // SAME 0x2809C 
  EG_CB_COLOR7_INFO                             = 0x28E14, // DIFF 0x280BC 
  EG_CB_COLOR7_ATTRIB                           = 0x28E18, // 
  EG_CB_COLOR7_DIM                              = 0x28E1C, // 
  EG_CB_COLOR7_CMASK                            = 0x28E20, // 
  EG_CB_COLOR7_CMASK_SLICE                      = 0x28E24, // 
  EG_CB_COLOR7_FMASK                            = 0x28E28, // 
  EG_CB_COLOR7_FMASK_SLICE                      = 0x28E2C, // 
  EG_CB_COLOR7_CLEAR_WORD0                      = 0x28E30, // 
  EG_CB_COLOR7_CLEAR_WORD1                      = 0x28E34, // 
  EG_CB_COLOR7_CLEAR_WORD2                      = 0x28E38, // 
  EG_CB_COLOR7_CLEAR_WORD3                      = 0x28E3C, // 
  EG_CB_COLOR8_BASE                             = 0x28E40, // 
  EG_CB_COLOR8_PITCH                            = 0x28E44, // 
  EG_CB_COLOR8_SLICE                            = 0x28E48, // 
  EG_CB_COLOR8_VIEW                             = 0x28E4C, // 
  EG_CB_COLOR8_INFO                             = 0x28E50, // 
  EG_CB_COLOR8_ATTRIB                           = 0x28E54, // 
  EG_CB_COLOR8_DIM                              = 0x28E58, // 
  EG_CB_COLOR9_BASE                             = 0x28E5C, // 
  EG_CB_COLOR9_PITCH                            = 0x28E60, // 
  EG_CB_COLOR9_SLICE                            = 0x28E64, // 
  EG_CB_COLOR9_VIEW                             = 0x28E68, // 
  EG_CB_COLOR9_INFO                             = 0x28E6C, // 
  EG_CB_COLOR9_ATTRIB                           = 0x28E70, // 
  EG_CB_COLOR9_DIM                              = 0x28E74, // 
  EG_CB_COLOR10_BASE                            = 0x28E78, // 
  EG_CB_COLOR10_PITCH                           = 0x28E7C, // 
  EG_CB_COLOR10_SLICE                           = 0x28E80, // 
  EG_CB_COLOR10_VIEW                            = 0x28E84, // 
  EG_CB_COLOR10_INFO                            = 0x28E88, // 
  EG_CB_COLOR10_ATTRIB                          = 0x28E8C, // 
  EG_CB_COLOR10_DIM                             = 0x28E90, // 
  EG_CB_COLOR11_BASE                            = 0x28E94, // 
  EG_CB_COLOR11_PITCH                           = 0x28E98, // 
  EG_CB_COLOR11_SLICE                           = 0x28E9C, // 
  EG_CB_COLOR11_VIEW                            = 0x28EA0, // 
  EG_CB_COLOR11_INFO                            = 0x28EA4, // 
  EG_CB_COLOR11_ATTRIB                          = 0x28EA8, // 
  EG_CB_COLOR11_DIM                             = 0x28EAC, // 

/* Registers from CP block: */ 	
  EG_COHER_DEST_BASE_0                          = 0x28248, // SAME 
  EG_COHER_DEST_BASE_1                          = 0x2824C, // SAME 
  EG_CP_PERFMON_CNTX_CNTL                       = 0x28358, // 

/* Config: */
  EG_SPI_CONFIG_CNTL                            = 0x9100,  // DIFF
  EG_SPI_CONFIG_CNTL_1                          = 0x913C,  // DIFF
  EG_CP_PERFMON_CNTL                            = 0x87FC,  // SAME
  EG_SQ_MS_FIFO_SIZES                           = 0x8CF0,  // SAME
  EG_SQ_CONFIG                                  = 0x8C00,  // DIFF
  EG_SQ_GPR_RESOURCE_MGMT_1                     = 0x8C04,  // SAME
  EG_SQ_GPR_RESOURCE_MGMT_2                     = 0x8C08,  // SAME
  EG_SQ_THREAD_RESOURCE_MGMT                    = 0x8C18,  // SAME 0x8C0C,
  EG_SQ_STACK_RESOURCE_MGMT_1                   = 0x8C20,  // SAME 0x8C10,
  EG_SQ_STACK_RESOURCE_MGMT_2                   = 0x8C24,  // SAME 0x8C14,
  EG_SQ_DYN_GPR_CNTL_PS_FLUSH_REQ               = 0x8D8C,  // DIFF
  EG_SQ_LDS_RESOURCE_MGMT                       = 0x8E2C,  //
  EG_SQ_GPR_RESOURCE_MGMT_3                     = 0x8C0C,  //
  EG_SQ_STACK_RESOURCE_MGMT_3                   = 0x8C28,  //
  EG_SQ_THREAD_RESOURCE_MGMT_2                  = 0x8C1C,  //
  EG_VGT_CACHE_INVALIDATION                     = 0x88C4,  // DIFF
  EG_VGT_GS_VERTEX_REUSE                        = 0x88D4,  // SAME
  EG_PA_SC_FORCE_EOV_MAX_CNTS                   = 0x8B24,  // SAME   
  EG_PA_SC_LINE_STIPPLE_STATE                   = 0x8B10,  // SAME
  EG_PA_CL_ENHANCE                              = 0x8A14,  // SAME

/* Tex border color */
  EG_TD_PS_BORDER_COLOR_RED                     = 0xA404,
  EG_TD_PS_BORDER_COLOR_GREEN                   = 0xA408,
  EG_TD_PS_BORDER_COLOR_BLUE                    = 0xA40C,
  EG_TD_PS_BORDER_COLOR_ALPHA                   = 0xA410,

/* const */
  EG_SQ_VTX_CONSTANT_WORD0_0                    = 0x30000, //      0x38000   
};

#endif /* _EVERGREEN_OFF_H_ */