/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public final class SignedObject
implements Serializable {
    static final long serialVersionUID = 720502720485447167L;
    private byte[] content;
    private byte[] signature;
    private String thealgorithm;

    public SignedObject(Serializable object, PrivateKey signingKey, Signature signingEngine) throws IOException, InvalidKeyException, SignatureException {
        this.thealgorithm = signingEngine.getAlgorithm();
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        ObjectOutputStream p = new ObjectOutputStream(ostream);
        p.writeObject(object);
        p.flush();
        this.content = ostream.toByteArray();
        signingEngine.initSign(signingKey);
        signingEngine.update(this.content);
        this.signature = signingEngine.sign();
    }

    public Object getObject() throws IOException, ClassNotFoundException {
        ByteArrayInputStream istream = new ByteArrayInputStream(this.content);
        return new ObjectInputStream(istream).readObject();
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public String getAlgorithm() {
        return this.thealgorithm;
    }

    public boolean verify(PublicKey verificationKey, Signature verificationEngine) throws InvalidKeyException, SignatureException {
        verificationEngine.initVerify(verificationKey);
        verificationEngine.update(this.content);
        return verificationEngine.verify(this.signature);
    }
}

