/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class PropertyChangeSupport
implements Serializable {
    private static final long serialVersionUID = 6401253773779951803L;
    private Hashtable children;
    private final Object source;
    private final int propertyChangeSupportSerializedDataVersion;
    private transient Vector listeners;

    private /* synthetic */ void finit$() {
        this.propertyChangeSupportSerializedDataVersion = 2;
    }

    public PropertyChangeSupport(Object source) {
        this.finit$();
        this.source = source;
        if (source == null) {
            throw new NullPointerException();
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (l instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy p = (PropertyChangeListenerProxy)l;
            this.addPropertyChangeListener(p.propertyName, (PropertyChangeListener)p.getListener());
        } else {
            if (this.listeners == null) {
                this.listeners = new Vector();
            }
            this.listeners.add(l);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (l instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy p = (PropertyChangeListenerProxy)l;
            this.removePropertyChangeListener(p.propertyName, (PropertyChangeListener)p.getListener());
        } else if (this.listeners != null) {
            this.listeners.remove(l);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        ArrayList list = new ArrayList();
        if (this.listeners != null) {
            list.addAll(this.listeners);
        }
        if (this.children != null) {
            int i = this.children.size();
            Iterator iter = this.children.entrySet().iterator();
            while (--i >= 0) {
                Map.Entry e = (Map.Entry)iter.next();
                String name = (String)e.getKey();
                Vector v = ((PropertyChangeSupport)e.getValue()).listeners;
                int j = v.size();
                while (--j >= 0) {
                    list.add(new PropertyChangeListenerProxy(name, (PropertyChangeListener)v.get(j)));
                }
            }
        }
        return (PropertyChangeListener[])list.toArray(new PropertyChangeListener[list.size()]);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        while (l instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy p = (PropertyChangeListenerProxy)l;
            if (propertyName == null ? p.propertyName != null : !propertyName.equals(p.propertyName)) {
                return;
            }
            l = (PropertyChangeListener)p.getListener();
        }
        PropertyChangeSupport s = null;
        if (this.children == null) {
            this.children = new Hashtable();
        } else {
            s = (PropertyChangeSupport)this.children.get(propertyName);
        }
        if (s == null) {
            s = new PropertyChangeSupport(this.source);
            s.listeners = new Vector();
            this.children.put(propertyName, s);
        }
        s.listeners.add(l);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        if (this.children == null) {
            return;
        }
        PropertyChangeSupport s = (PropertyChangeSupport)this.children.get(propertyName);
        if (s == null) {
            return;
        }
        while (l instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy p = (PropertyChangeListenerProxy)l;
            if (propertyName == null ? p.propertyName != null : !propertyName.equals(p.propertyName)) {
                return;
            }
            l = (PropertyChangeListener)p.getListener();
        }
        s.listeners.remove(l);
        if (s.listeners.isEmpty()) {
            this.children.remove(propertyName);
            if (this.children.isEmpty()) {
                this.children = null;
            }
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        if (this.children == null) {
            return new PropertyChangeListener[0];
        }
        PropertyChangeSupport s = (PropertyChangeSupport)this.children.get(propertyName);
        if (s == null) {
            return new PropertyChangeListener[0];
        }
        return (PropertyChangeListener[])s.listeners.toArray(new PropertyChangeListener[s.listeners.size()]);
    }

    public void firePropertyChange(String propertyName, Object oldVal, Object newVal) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, propertyName, oldVal, newVal));
    }

    public void firePropertyChange(String propertyName, int oldVal, int newVal) {
        if (oldVal != newVal) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, propertyName, new Integer(oldVal), new Integer(newVal)));
        }
    }

    public void firePropertyChange(String propertyName, boolean oldVal, boolean newVal) {
        if (oldVal != newVal) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, propertyName, oldVal, newVal));
        }
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        PropertyChangeSupport s;
        Hashtable h;
        if (event.oldValue != null && event.oldValue.equals(event.newValue)) {
            return;
        }
        Vector v = this.listeners;
        if (v != null) {
            int i = v.size();
            while (--i >= 0) {
                ((PropertyChangeListener)v.get(i)).propertyChange(event);
            }
        }
        if ((h = this.children) != null && event.propertyName != null && (s = (PropertyChangeSupport)h.get(event.propertyName)) != null) {
            int i;
            v = s.listeners;
            int n = i = v == null ? 0 : v.size();
            while (--i >= 0) {
                ((PropertyChangeListener)v.get(i)).propertyChange(event);
            }
        }
    }

    public synchronized boolean hasListeners(String propertyName) {
        return this.listeners != null || this.children != null && this.children.get(propertyName) != null;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.listeners != null) {
            int i = this.listeners.size();
            while (--i >= 0) {
                if (!(this.listeners.get(i) instanceof Serializable)) continue;
                s.writeObject(this.listeners.get(i));
            }
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        PropertyChangeListener l = (PropertyChangeListener)s.readObject();
        while (l != null) {
            this.addPropertyChangeListener(l);
            l = (PropertyChangeListener)s.readObject();
        }
        if (this.children != null) {
            int i = this.children.size();
            Iterator iter = this.children.entrySet().iterator();
            while (--i >= 0) {
                Map.Entry e = (Map.Entry)iter.next();
                String name = (String)e.getKey();
                PropertyChangeSupport pcs = (PropertyChangeSupport)e.getValue();
                if (pcs.listeners == null) {
                    pcs.listeners = new Vector();
                }
                if (pcs.children != null) {
                    pcs.listeners.addAll(Arrays.asList(pcs.getPropertyChangeListeners(name)));
                }
                if (pcs.listeners.size() == 0) {
                    iter.remove();
                    continue;
                }
                pcs.children = null;
            }
            if (this.children.size() == 0) {
                this.children = null;
            }
        }
    }
}

