/***************************************************************************
                            QRect.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QRECT_H
#define QRECT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

* $Id: QRect.h,v 1.2 2001/11/21 23:39:02 rdale Exp $
*
* Definition of QRect class
*
* Created : 931028
*
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
*
* This file is part of the kernel module of the Qt GUI Toolkit.
*
* This file may be distributed under the terms of the Q Public License
* as defined by Trolltech AS of Norway and appearing in the file
* LICENSE.QPL included in the packaging of this file.
*
* This file may be distributed and/or modified under the terms of the
* GNU General Public License version 2 as published by the Free Software
* Foundation and appearing in the file LICENSE.GPL included in the
* packaging of this file.
*
* Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
* licenses may use this file in accordance with the Qt Commercial License
* Agreement provided with the Software.
*
* This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
* WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
* See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
*   information about Qt Commercial License Agreements.
* See http://www.trolltech.com/qpl/ for QPL licensing information.
* See http://www.trolltech.com/gpl/ for GPL licensing information.
*
* Contact info@trolltech.com if any conditions of this licensing are
* not clear to you.
*
********************************************************************
 @short 
* $Id:  qt/qrect.
*/

@class QPoint;

@class QSize; 

@interface  QRect : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- initWithPoint: (QPoint*)topleft bottomright: (QPoint*)bottomright;
- initWithPoint: (QPoint*)topleft size: (QSize *)size;
- initWithInt: (int)left top: (int)top width: (int)width height: (int)height;
- (BOOL) isNull;
- (BOOL) isEmpty;
- (BOOL) isValid;
- (QRect*) normalize;
- (int) left;
- (int) top;
- (int) right;
- (int) bottom;
- (short) rLeft;
- (short) rTop;
- (short) rRight;
- (short) rBottom;
- (int) x;
- (int) y;
- setLeft: (int)pos;
- setTop: (int)pos;
- setRight: (int)pos;
- setBottom: (int)pos;
- setX: (int)x;
- setY: (int)y;
- (QPoint*) topLeft;
- (QPoint*) bottomRight;
- (QPoint*) topRight;
- (QPoint*) bottomLeft;
- (QPoint*) center;
- rect: (int*)x y: (int*)y w: (int*)w h: (int*)h;
- coords: (int*)x1 y1: (int*)y1 x2: (int*)x2 y2: (int*)y2;
- moveTopLeft: (QPoint*)p;
- moveBottomRight: (QPoint*)p;
- moveTopRight: (QPoint*)p;
- moveBottomLeft: (QPoint*)p;
- moveCenter: (QPoint*)p;
- moveBy: (int)dx dy: (int)dy;
- setRect: (int)x y: (int)y w: (int)w h: (int)h;
- setCoords: (int)x1 y1: (int)y1 x2: (int)x2 y2: (int)y2;
- addCoords: (int)x1 y1: (int)y1 x2: (int)x2 y2: (int)y2;
- (QSize*) size;
- (int) width;
- (int) height;
- setWidth: (int)w;
- setHeight: (int)h;
- setSize: (QSize *)s;
- (BOOL) contains: (QPoint*)p proper: (BOOL)proper;
- (BOOL) contains: (QPoint*)p ;
- (BOOL) contains: (int)x y: (int)y proper: (BOOL)proper;
- (BOOL) contains: (int)x y: (int)y ;
- (BOOL) containsRect: (QRect*)r proper: (BOOL)proper;
- (BOOL) containsRect: (QRect*)r ;
- (QRect*) unite: (QRect*)r;
- (QRect*) intersect: (QRect*)r;
- (BOOL) intersects: (QRect*)r;
@end

#endif
