// -*- c++ -*-

/*
 *  Copyright (C) 2001-2002, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#ifndef KJSEMBEDJSCONSOLEPART_H
#define KJSEMBEDJSCONSOLEPART_H

#include <kparts/part.h>

#include "jsconsolewidget.h"

namespace KJSEmbed {

/**
 * A KPart that provides a console for executing Javascript commands.
 *
 * @version $Id: jsconsolepart.h,v 1.2.2.1 2003/05/19 14:59:35 mueller Exp $
 * @author Richard Moore, rich@kde.org
 */
class JSConsolePart : public KParts::ReadOnlyPart
{
    Q_OBJECT

public:
    JSConsolePart( QWidget *parent, const char *name=0 );
    JSConsolePart( KJS::Interpreter *js, QWidget *parent, const char *name=0 );
    ~JSConsolePart();

    KJS::Interpreter *jscript() const { return jsConsole->jscript(); }
    JSConsoleWidget *widget() const { return jsConsole; }

public slots:
    virtual bool openURL( const KURL &url );

protected:
    virtual bool openFile() { return false; }

private:
    JSConsoleWidget *jsConsole;
    class Private *d;
};

} // namespace KJSEmbed

#endif // KJSEMBEDJSCONSOLEPART_H

// Local Variables:
// c-basic-offset: 4
// End:
