/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.KeyDeclaration;
import org.apache.xalan.transformer.KeyIterator;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;

public class KeyTable {
    private int m_docKey;
    private Vector m_keyDeclarations;
    private Hashtable m_refsTable = null;
    private XNodeSet m_keyNodes;

    public int getDocKey() {
        return this.m_docKey;
    }

    private Hashtable getRefsTable() {
        if (this.m_refsTable == null) {
            int n2;
            this.m_refsTable = new Hashtable(89);
            KeyIterator keyIterator = (KeyIterator)this.m_keyNodes.getContainedIter();
            XPathContext xPathContext = keyIterator.getXPathContext();
            KeyDeclaration keyDeclaration = this.getKeyDeclaration();
            this.m_keyNodes.reset();
            while (-1 != (n2 = this.m_keyNodes.nextNode())) {
                try {
                    int n3;
                    Object object;
                    XObject xObject = keyDeclaration.getUse().execute(xPathContext, n2, keyIterator.getPrefixResolver());
                    if (xObject.getType() != 4) {
                        object = xObject.xstr();
                        this.addValueInRefsTable(xPathContext, (XMLString)object, n2);
                        continue;
                    }
                    object = ((XNodeSet)xObject).iterRaw();
                    while (-1 != (n3 = object.nextNode())) {
                        DTM dTM = xPathContext.getDTM(n3);
                        XMLString xMLString = dTM.getStringValue(n3);
                        this.addValueInRefsTable(xPathContext, xMLString, n2);
                    }
                }
                catch (TransformerException transformerException) {
                    throw new WrappedRuntimeException(transformerException);
                }
            }
        }
        return this.m_refsTable;
    }

    private KeyDeclaration getKeyDeclaration() {
        int n2 = this.m_keyDeclarations.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            KeyDeclaration keyDeclaration = (KeyDeclaration)this.m_keyDeclarations.elementAt(i2);
            if (!keyDeclaration.getName().equals(this.getKeyTableName())) continue;
            return keyDeclaration;
        }
        return null;
    }

    KeyIterator getKeyIterator() {
        return (KeyIterator)this.m_keyNodes.getContainedIter();
    }

    public QName getKeyTableName() {
        return this.getKeyIterator().getName();
    }

    private void addValueInRefsTable(XPathContext xPathContext, XMLString xMLString, int n2) {
        XNodeSet xNodeSet = (XNodeSet)this.m_refsTable.get(xMLString);
        if (xNodeSet == null) {
            xNodeSet = new XNodeSet(n2, xPathContext.getDTMManager());
            xNodeSet.nextNode();
            this.m_refsTable.put(xMLString, xNodeSet);
        } else if (xNodeSet.getCurrentNode() != n2) {
            xNodeSet.mutableNodeset().addNode(n2);
            xNodeSet.nextNode();
        }
    }

    public XNodeSet getNodeSetDTMByKey(QName qName, XMLString xMLString) {
        XNodeSet xNodeSet = (XNodeSet)this.getRefsTable().get(xMLString);
        try {
            if (xNodeSet != null) {
                xNodeSet = (XNodeSet)xNodeSet.cloneWithReset();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            xNodeSet = null;
        }
        if (xNodeSet == null) {
            KeyIterator keyIterator = (KeyIterator)this.m_keyNodes.getContainedIter();
            XPathContext xPathContext = keyIterator.getXPathContext();
            xNodeSet = new XNodeSet(xPathContext.getDTMManager()){

                public void setRoot(int n2, Object object) {
                }
            };
            xNodeSet.reset();
        }
        return xNodeSet;
    }

    public KeyTable(int n2, PrefixResolver prefixResolver, QName qName, Vector vector, XPathContext xPathContext) throws TransformerException {
        this.m_docKey = n2;
        this.m_keyDeclarations = vector;
        KeyIterator keyIterator = new KeyIterator(qName, vector);
        this.m_keyNodes = new XNodeSet(keyIterator);
        this.m_keyNodes.allowDetachToRelease(false);
        this.m_keyNodes.setRoot(n2, xPathContext);
    }
}

