/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.LookupTable;

public class ByteLookupTable
extends LookupTable {
    byte[][] data;

    public final byte[][] getTable() {
        return this.data;
    }

    public ByteLookupTable(int n2, byte[] byArray) {
        super(n2, byArray.length);
        this.numComponents = 1;
        this.numEntries = byArray.length;
        this.data = new byte[1][];
        this.data[0] = byArray;
    }

    public ByteLookupTable(int n2, byte[][] byArray) {
        super(n2, byArray.length);
        this.numComponents = byArray.length;
        this.numEntries = byArray[0].length;
        this.data = new byte[this.numComponents][];
        for (int i2 = 0; i2 < this.numComponents; ++i2) {
            this.data[i2] = byArray[i2];
        }
    }

    public byte[] lookupPixel(byte[] byArray, byte[] byArray2) {
        if (byArray2 == null) {
            byArray2 = new byte[byArray.length];
        }
        if (this.numComponents == 1) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                int n2 = (byArray[i2] & 0xFF) - this.offset;
                if (n2 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i2 + "]-offset is " + "less than zero");
                }
                byArray2[i2] = this.data[0][n2];
            }
        } else {
            for (int i3 = 0; i3 < byArray.length; ++i3) {
                int n3 = (byArray[i3] & 0xFF) - this.offset;
                if (n3 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i3 + "]-offset is " + "less than zero");
                }
                byArray2[i3] = this.data[i3][n3];
            }
        }
        return byArray2;
    }

    public int[] lookupPixel(int[] nArray, int[] nArray2) {
        if (nArray2 == null) {
            nArray2 = new int[nArray.length];
        }
        if (this.numComponents == 1) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n2 = nArray[i2] - this.offset;
                if (n2 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i2 + "]-offset is " + "less than zero");
                }
                nArray2[i2] = this.data[0][n2];
            }
        } else {
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                int n3 = nArray[i3] - this.offset;
                if (n3 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + i3 + "]-offset is " + "less than zero");
                }
                nArray2[i3] = this.data[i3][n3];
            }
        }
        return nArray2;
    }
}

