/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthPainter;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

class SynthBorder
extends AbstractBorder
implements UIResource {
    private SynthUI ui;
    private Insets insets;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = !SynthBorder.class.desiredAssertionStatus();
    }

    public boolean isBorderOpaque() {
        return false;
    }

    SynthBorder(SynthUI synthUI) {
        this(synthUI, null);
    }

    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        JComponent jComponent = (JComponent)component;
        SynthContext synthContext = this.ui.getContext(jComponent);
        SynthStyle synthStyle = synthContext.getStyle();
        if (synthStyle == null) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"SynthBorder is being used outside after the UI has been uninstalled");
            }
            return;
        }
        SynthPainter synthPainter = synthStyle.getBorderPainter(synthContext);
        if (synthPainter != null) {
            synthPainter.paint(synthContext, "border", graphics, n2, n3, n4, n5);
        }
        synthContext.dispose();
    }

    SynthBorder(SynthUI synthUI, Insets insets) {
        this.ui = synthUI;
        this.insets = insets;
    }

    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, null);
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        if (this.insets != null) {
            if (insets == null) {
                return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
            }
            insets.top = this.insets.top;
            insets.bottom = this.insets.bottom;
            insets.left = this.insets.left;
            insets.right = this.insets.left;
            return insets;
        }
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        return insets;
    }
}

