/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.javac.v8.code.Scope;
import com.sun.tools.javac.v8.code.Symbol;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.ListBuffer;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.DocImpl;
import com.sun.tools.javadoc.SourcePositionImpl;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PackageDocImpl
extends DocImpl
implements PackageDoc {
    private static final String PACKAGE_FILE_NAME = "package.html";
    protected Symbol.PackageSymbol sym;
    public String docPath = null;
    public String zipDocPath = null;
    public String zipDocEntry = null;
    boolean isIncluded = false;
    private List allClassesFiltered = null;
    private List allClasses = null;

    public boolean isIncluded() {
        return this.isIncluded;
    }

    public ClassDoc[] allClasses() {
        return this.allClasses(true);
    }

    public ClassDoc[] errors() {
        ListBuffer listBuffer = new ListBuffer();
        List list = this.getClasses(true);
        while (list.nonEmpty()) {
            ClassDocImpl classDocImpl = (ClassDocImpl)list.head;
            if (classDocImpl.isError()) {
                listBuffer.append(classDocImpl);
            }
            list = list.tail;
        }
        return (ClassDoc[])listBuffer.toArray(new ClassDocImpl[listBuffer.length()]);
    }

    public ClassDoc[] exceptions() {
        ListBuffer listBuffer = new ListBuffer();
        List list = this.getClasses(true);
        while (list.nonEmpty()) {
            ClassDocImpl classDocImpl = (ClassDocImpl)list.head;
            if (classDocImpl.isException()) {
                listBuffer.append(classDocImpl);
            }
            list = list.tail;
        }
        return (ClassDoc[])listBuffer.toArray(new ClassDocImpl[listBuffer.length()]);
    }

    public ClassDoc[] interfaces() {
        ListBuffer listBuffer = new ListBuffer();
        List list = this.getClasses(true);
        while (list.nonEmpty()) {
            ClassDocImpl classDocImpl = (ClassDocImpl)list.head;
            if (classDocImpl.isInterface()) {
                listBuffer.append(classDocImpl);
            }
            list = list.tail;
        }
        return (ClassDoc[])listBuffer.toArray(new ClassDocImpl[listBuffer.length()]);
    }

    public ClassDoc[] ordinaryClasses() {
        ListBuffer listBuffer = new ListBuffer();
        List list = this.getClasses(true);
        while (list.nonEmpty()) {
            ClassDocImpl classDocImpl = (ClassDocImpl)list.head;
            if (classDocImpl.isOrdinaryClass()) {
                listBuffer.append(classDocImpl);
            }
            list = list.tail;
        }
        return (ClassDoc[])listBuffer.toArray(new ClassDocImpl[listBuffer.length()]);
    }

    public ClassDoc[] allClasses(boolean bl) {
        List list = this.getClasses(bl);
        return (ClassDoc[])list.toArray(new ClassDocImpl[list.length()]);
    }

    public SourcePosition position() {
        return this.docPath == null ? null : SourcePositionImpl.make(this.docPath, 0);
    }

    private List getClasses(boolean bl) {
        if (this.allClasses != null && !bl) {
            return this.allClasses;
        }
        if (this.allClassesFiltered != null && bl) {
            return this.allClassesFiltered;
        }
        ListBuffer listBuffer = new ListBuffer();
        Scope.Entry entry = this.sym.members().elems;
        while (entry != null) {
            Symbol.ClassSymbol classSymbol;
            ClassDocImpl classDocImpl;
            if (entry.sym != null && (classDocImpl = this.env.getClassDoc(classSymbol = (Symbol.ClassSymbol)entry.sym)) != null && !classDocImpl.isSynthetic()) {
                classDocImpl.addAllClasses(listBuffer, bl);
            }
            entry = entry.sibling;
        }
        if (bl) {
            this.allClassesFiltered = listBuffer.toList();
            return this.allClassesFiltered;
        }
        this.allClasses = listBuffer.toList();
        return this.allClasses;
    }

    public void addAllClassesTo(ListBuffer listBuffer) {
        listBuffer.appendList(this.getClasses(true));
    }

    String documentation() {
        Closeable closeable;
        if (this.documentation != null) {
            return this.documentation;
        }
        if (this.zipDocPath != null) {
            try {
                closeable = new ZipFile(this.zipDocPath);
                ZipEntry zipEntry = ((ZipFile)closeable).getEntry(this.zipDocEntry);
                if (zipEntry != null) {
                    InputStream inputStream = ((ZipFile)closeable).getInputStream(zipEntry);
                    this.documentation = this.readHTMLDocumentation(inputStream, this.zipDocPath + File.separatorChar + this.zipDocEntry);
                    return this.documentation;
                }
            }
            catch (IOException iOException) {
                this.documentation = "";
                this.env.error(null, "javadoc.File_Read_Error", this.zipDocPath + File.separatorChar + this.zipDocEntry);
            }
        }
        if (this.docPath != null) {
            try {
                closeable = new FileInputStream(this.docPath);
                this.documentation = this.readHTMLDocumentation((InputStream)closeable, this.docPath);
            }
            catch (IOException iOException) {
                this.documentation = "";
                this.env.error(null, "javadoc.File_Read_Error", this.docPath);
            }
        } else {
            this.documentation = "";
        }
        return this.documentation;
    }

    public String name() {
        String string = this.sym.fullName().toString();
        if (string.equals("unnamed package")) {
            string = "";
        }
        return string;
    }

    public String qualifiedName() {
        return this.name();
    }

    public void setDocPath(String string) {
        this.docPath = string + File.separatorChar + PACKAGE_FILE_NAME;
    }

    public ClassDoc findClass(String string) {
        List list = this.getClasses(true);
        while (list.nonEmpty()) {
            ClassDocImpl classDocImpl = (ClassDocImpl)list.head;
            if (classDocImpl.name().equals(string)) {
                return classDocImpl;
            }
            list = list.tail;
        }
        return null;
    }

    public PackageDocImpl(DocEnv docEnv, Symbol.PackageSymbol packageSymbol) {
        super(docEnv, null);
        this.sym = packageSymbol;
    }

    public void setDocPath(String string, String string2) {
        this.zipDocPath = string;
        this.zipDocEntry = string2 + PACKAGE_FILE_NAME;
    }
}

