.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XQueryColor 3X11 "Release 6.3" "X Version 11" "XLIB FUNCTIONS"
.SH NAME
XQueryColor, XQueryColors, XLookupColor, XParseColor \- obtain color values
.SH SYNTAX
XQueryColor\^(\^\fIdisplay\fP, \fIcolormap\fP\^, \fIdef_in_out\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Colormap \fIcolormap\fP\^;
.br
      XColor *\fIdef_in_out\fP\^;
.LP
XQueryColors\^(\^\fIdisplay\fP, \fIcolormap\fP\^, \fIdefs_in_out\fP\^, \fIncolors\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Colormap \fIcolormap\fP\^;
.br
      XColor \fIdefs_in_out\fP[\^]\^;
.br
      int \fIncolors\fP\^;
.LP
Status XLookupColor\^(\^\fIdisplay\fP, \fIcolormap\fP, \fIcolor_name\fP, \
\fIexact_def_return\fP\^, \fIscreen_def_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Colormap \fIcolormap\fP\^;
.br
      char *\fIcolor_name\fP\^;
.br
      XColor *\fIexact_def_return\fP\^, *\fIscreen_def_return\fP\^;
.LP
Status XParseColor\^(\^\fIdisplay\fP, \fIcolormap\fP\^, \^\fIspec\fP\^, \fIexact_def_return\fP\^)
.br
        Display *\fIdisplay\fP\^;
.br
        Colormap \fIcolormap\fP\^;
.br
        char *\fIspec\fP\^;
.br
        XColor *\fIexact_def_return\fP\^;
.SH ARGUMENTS
.IP \fIcolormap\fP 1i
Specifies the colormap.
.IP \fIcolor_name\fP 1i
Specifies the color name string (for example, red) whose color 
definition structure you want returned.
.IP \fIdef_in_out\fP 1i
Specifies and returns the RGB values for the pixel specified in the structure.
.IP \fIdefs_in_out\fP 1i
Specifies and returns an array of color definition structures for the pixel
specified in the structure.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIexact_def_return\fP 1i
Returns the exact RGB values.
.IP \fIncolors\fP 1i
.\"Specifies the number of color definition structures. 
Specifies the number of 
.ZN XColor
structures in the color definition array.
.IP \fIscreen_def_return\fP 1i
Returns the closest RGB values provided by the hardware.
.IP \fIspec\fP 1i
Specifies the color name string;
case is ignored.
.IP \fIexact_def_return\fP 1i
Returns the exact color value for later use and sets the
.ZN DoRed ,
.ZN DoGreen ,
and
.ZN DoBlue
flags.
.SH DESCRIPTION
The
.ZN XQueryColor
function returns the current RGB value for the pixel in the
.ZN XColor
structure and sets the
.ZN DoRed ,
.ZN DoGreen ,
and
.ZN DoBlue
flags.
The
.ZN XQueryColors
function returns the RGB value for each pixel in each
.ZN XColor
structure and sets the
.ZN DoRed ,
.ZN DoGreen ,
and
.ZN DoBlue
flags in each structure.

.LP
.ZN XQueryColor
and
.ZN XQueryColors
can generate
.ZN BadColor
and
.ZN BadValue 
errors.
.LP
The
.ZN XLookupColor
function looks up the string name of a color with respect to the screen
associated with the specified colormap.
It returns both the exact color values and
the closest values provided by the screen 
with respect to the visual type of the specified colormap.
If the color name is not in the Host Portable Character Encoding, 
the result is implementation-dependent.
Use of uppercase or lowercase does not matter.
.ZN XLookupColor
returns nonzero if the name is resolved;
otherwise, it returns zero.
.LP
The
.ZN XParseColor
function looks up the string name of a color with respect to the screen
associated with the specified colormap.
It returns the exact color value.
If the color name is not in the Host Portable Character Encoding, 
the result is implementation-dependent.
Use of uppercase or lowercase does not matter.
.ZN XParseColor
returns nonzero if the name is resolved;
otherwise, it returns zero.
.LP
.ZN XLookupColor
and
.ZN XParseColor
can generate
.ZN BadColor 
error.
.SH "COLOR NAMES"
An RGB Device specification is identified by
the prefix ``rgb:'' and conforms to the following syntax:
.LP
.\" Start marker code here
.Ds 0
rgb:\fI<red>/<green>/<blue>\fP

    \fI<red>\fP, \fI<green>\fP, \fI<blue>\fP := \fIh\fP | \fIhh\fP | \fIhhh\fP | \fIhhhh\fP
    \fIh\fP := single hexadecimal digits (case insignificant)
.De
.\" End marker code here
.LP
Note that \fIh\fP indicates the value scaled in 4 bits, 
\fIhh\fP the value scaled in 8 bits,
\fIhhh\fP the value scaled in 12 bits,
and \fIhhhh\fP the value scaled in 16 bits, respectively.
.LP
For backward compatibility, an older syntax for RGB Device is
supported, but its continued use is not encouraged.
The syntax is an initial sharp sign character followed by
a numeric specification, in one of the following formats:
.LP
.\" Start marker code here
.Ds 0
.TA 2i
.ta 2i
#RGB	(4 bits each)
#RRGGBB	(8 bits each)
#RRRGGGBBB	(12 bits each)
#RRRRGGGGBBBB	(16 bits each)
.De
.\" End marker code here
.LP
The R, G, and B represent single hexadecimal digits.
When fewer than 16 bits each are specified, 
they represent the most significant bits of the value
(unlike the ``rgb:'' syntax, in which values are scaled).
For example, the string ``#3a7'' is the same as ``#3000a0007000''.
.LP
An RGB intensity specification is identified
by the prefix ``rgbi:'' and conforms to the following syntax:
.LP
.\" Start marker code here
.Ds 0
rgbi:\fI<red>/<green>/<blue>\fP
.De
.\" End marker code here
.LP
Note that red, green, and blue are floating-point values
between 0.0 and 1.0, inclusive.
The input format for these values is an optional sign,
a string of numbers possibly containing a decimal point,
and an optional exponent field containing an E or e 
followed by a possibly signed integer string.
.LP
The standard device-independent string specifications have
the following syntax:
.LP
.\" Start marker code here
.Ds 0
CIEXYZ:\fI<X>/<Y>/<Z>\fP
CIEuvY:\fI<u>/<v>/<Y>\fP
CIExyY:\fI<x>/<y>/<Y>\fP
CIELab:\fI<L>/<a>/<b>\fP
CIELuv:\fI<L>/<u>/<v>\fP
TekHVC:\fI<H>/<V>/<C>\fP
.De
.\" End marker code here
.LP
All of the values (C, H, V, X, Y, Z, a, b, u, v, y, x) are
floating-point values.
The syntax for these values is an optional plus or minus sign,
a string of digits possibly containing a decimal point,
and an optional exponent field consisting of an ``E'' or ``e''
followed by an optional plus or minus followed by a string of digits.
.SH DIAGNOSTICS
.TP 1i
.ZN BadColor
A value for a Colormap argument does not name a defined Colormap.
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
XAllocColor(3X11),
XCreateColormap(3X11),
XStoreColors(3X11)
.br
\fI\*(xL\fP
