/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2003 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * wwl.c - see description below by IK0ZSN, adopted for xlog April 2002
 * fixes by Pieter-Tjerk de Boer, PA3FWM and Hamish Mofatt, VK3SB
 * from the wwl debian package.
 */

/*
 * $Id: wwl.c,v 1.3 2003/01/11 16:13:00 pa4tu Exp $
 * Given two Maidenhead locators, calculates distance and azimuth.
 * (C) 1998 by IK0ZSN Mirko Caserta <ik0zsn@amsat.org>
 * This software is placed under the terms of the GNU General Public Licence.
 *
 * Compile with: gcc -lm -o wwl wwl.c
 *
 * $Log: wwl.c,v $
 * Revision 1.3  2003/01/11 16:13:00  pa4tu
 * copyright->2003
 *
 * Revision 1.2  2002/11/21 19:57:46  pa4tu
 * run indent
 *
 * Revision 1.1  2002/10/19 17:50:20  pa4tu
 * initial checkin
 *
 * Revision 1.1  1998/05/19 14:20:49  root
 * Initial revision
 *
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <glib.h>
#include "wwl.h"
#include "support.h"
#include "utils.h"
#include "types.h"

extern preferencestype preferences;
extern GtkWidget *mainwindow;

static gchar *
wwl (gchar * my, gchar * dx)
{
  gint l, p, m;
  gdouble z, y, n, h, x, w, t, s, v, u, c, d, e, lx;
  gchar my_wwl[6], dx_wwl[6];
  gchar *result;
  gchar *msg;

  if (strlen (my) != 6)
    {
      msg = g_strdup_printf (_("%s: not a valid locator"), my);
      update_statusbar (msg);
      g_free (msg);
      return (g_strdup (""));
    }

  if (strlen (dx) != 6)
    {
      msg = g_strdup_printf (_("%s: not a valid locator"), dx);
      update_statusbar (msg);
      g_free (msg);
      return (g_strdup (""));
    }

  strcpy (my_wwl, my);
  strcpy (dx_wwl, dx);

  my_wwl[0] = toupper (my_wwl[0]);
  z = my_wwl[0] - 65;
  my_wwl[1] = toupper (my_wwl[1]);
  y = my_wwl[1] - 65;
  n = my_wwl[2] - 48;
  h = my_wwl[3] - 48;
  my_wwl[4] = toupper (my_wwl[4]);
  x = my_wwl[4] - 65;
  my_wwl[5] = toupper (my_wwl[5]);
  w = my_wwl[5] - 65;

  if (my_wwl[0] < 65 || my_wwl[0] > 88 || my_wwl[1] < 65 || my_wwl[1] > 88 ||
      my_wwl[2] < 48 || my_wwl[2] > 57 || my_wwl[3] < 48 || my_wwl[3] > 57 ||
      my_wwl[4] < 65 || my_wwl[4] > 88 || my_wwl[5] < 65 || my_wwl[5] > 88)
    {
      msg = g_strdup_printf (_("%s: not a valid locator"), my_wwl);
      update_statusbar (msg);
      g_free (msg);
      return (g_strdup (""));
    }

  t = z * 20 - 180 + n * 2 + x / 12 + 1.0 / 24;
  t = t * 3.1415926 / 180;
  s = y * 10 - 90 + h + w / 24 + 1.0 / 48;
  s = s * 3.1415926 / 180;

  dx_wwl[0] = toupper (dx_wwl[0]);
  z = dx_wwl[0] - 65;
  dx_wwl[1] = toupper (dx_wwl[1]);
  y = dx_wwl[1] - 65;
  n = dx_wwl[2] - 48;
  h = dx_wwl[3] - 48;
  dx_wwl[4] = toupper (dx_wwl[4]);
  x = dx_wwl[4] - 65;
  dx_wwl[5] = toupper (dx_wwl[5]);
  w = dx_wwl[5] - 65;

  if (dx_wwl[0] < 65 || dx_wwl[0] > 88 || dx_wwl[1] < 65 || dx_wwl[1] > 88 ||
      dx_wwl[2] < 48 || dx_wwl[2] > 57 || dx_wwl[3] < 48 || dx_wwl[3] > 57 ||
      dx_wwl[4] < 65 || dx_wwl[4] > 88 || dx_wwl[5] < 65 || dx_wwl[5] > 88)
    {
      msg = g_strdup_printf (_("%s: not a valid locator"), dx_wwl);
      update_statusbar (msg);
      g_free (msg);
      return (g_strdup (""));
    }

  v = z * 20 - 180 + n * 2 + x / 12 + 1.0 / 24;
  v = v * 3.1415926 / 180;
  u = y * 10 - 90 + h + w / 24 + 1.0 / 48;
  u = u * 3.1415926 / 180;

  c = cos (s) * cos (u) * cos (v - t) + sin (s) * sin (u);
  d = 1 - c * c;
  if (sqrt (d) != 0)
    {
      e = (sin (u) - sin (s) * c) / (cos (s) * sqrt (d));
      if (e > 1.0)
	e = 1.0;
      if (e < -1.0)
	e = -1.0;
      lx = acos (e) * 180 / 3.1415926;
      l = (int) (lx + 0.5);
    }
  else
    {
      l = 0;
    }

  if (sin (v - t) < 0)
    {
      l = 360 - l;
    }

  p = (gint) abs ((atan (sqrt (d) / c) * 6371.33) + .5);
  m = (gint) abs (p * 1.609);

  if (preferences.units == 1)
    result = g_strdup_printf (_("Distance: %d km, azimuth: %d deg"), p, l);
  else
    result = g_strdup_printf (_("Distance: %d m, azimuth: %d deg"), m, l);
  return (result);
}

void
updatelocatorframe (gchar * locator)
{
  gchar *label;
  GtkWidget *locatorframe, *locatorlabel1;

  /* initialize */
  locatorframe = lookup_widget (mainwindow, "locatorframe");
  locatorlabel1 = lookup_widget (mainwindow, "locatorlabel1");
  label = g_strdup ("");
  gtk_frame_set_label (GTK_FRAME (locatorframe), "Locator");

  if ((g_strcasecmp (locator, "") != 0) && (strlen (locator) == 6))
    {
      label = wwl (preferences.locator, locator);
      g_strup (locator);
    }
  gtk_frame_set_label (GTK_FRAME (locatorframe), locator);
  gtk_label_set_text (GTK_LABEL (locatorlabel1), label);
  g_free (label);
}
