/***************************************************************************
                            KIPC.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KIPC_H
#define KIPC_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 This class implements a very simple IPC mechanism for KDE. You can send
 a message of a predefined type to either a specific application, or to all
 KDE application on the current display. The message can carry one integer of
 data.

 KIPC is mainly used in KDE for sending "Change Messages", i.e. a message to
 all KDE apps that a certain setting (the font, for example) has changed.
 For anything more complex it is recommended to use DCOP -- the Desktop
 Communications Protocol.

 Messages with id code < 32 are called "System Messages". These are
 directly handled by KApplication. Examples are: PaletteChanged and
 StyleChanged. Messages with id code >= 32 are user messages. KApplication
 emits the signal kipcMessage(id,arg) for each user message it receives.

 KIPC is implemented using X11 ClientMessage events.

 @author Geert Jansen <jansen@kde.org>

 @version $Id: KIPC.h,v 1.3 2002/03/15 02:12:20 rdale Exp $
 
 @short 
 This class implements a very simple IPC mechanism for KDE.
*/
@interface  KIPC : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Send a message to a specific application.

*/
+ sendMessage: (int)msg w: (unsigned int)w data: (int)data;
+ sendMessage: (int)msg w: (unsigned int)w ;

/** 
 Send a message to all KDE application on the current display.

*/
+ sendMessageAll: (int)msg data: (int)data;
+ sendMessageAll: (int)msg ;
+ (int) PaletteChanged;
+ (int) FontChanged;
+ (int) StyleChanged;
+ (int) BackgroundChanged;
+ (int) SettingsChanged;
+ (int) IconChanged;
+ (int) ToolbarStyleChanged;
+ (int) UserMessage;
@end

#endif
