/***************************************************************************
                            kde_KComboBox.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KCOMBOBOX
#define KDE_KCOMBOBOX

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A combined button, line-edit and a popup list widget.

 This widget inherits from @ref QComboBox and implements the following
 additional functionalities:  a completion object that provides both automatic
 and manual text completion as well as text rotation features, configurable
 key-bindings to activate these features, and a popup-menu item that can be
 used to allow the user to change the text completion mode on the fly.

 To support these new features KComboBox emits a few additional signals 
 such as @ref completion( const QString& ) and @ref textRotation( KeyBindgingType ).
 The completion signal can be connected to a slot that will assist the user in 
 filling out the remaining text while the rotation signal can be used to traverse
 through all possible matches whenever text completion results in multiple matches.
 Additionally, a @ref returnPressed() and a @ref returnPressed( const QString& )
 signals are emitted when the user presses the Enter/Return key.

 KCombobox by default creates a completion object when you invoke the 
 @ref completionObject( bool ) member function for the first time or 
 explicitly use @ref setCompletionObject( KCompletion*, bool ) to assign your
 own completion object.  Additionally, to make this widget more functional, 
 KComboBox will by default handle text rotation and completion events
 internally whenever a completion object is created through either one of the 
 methods mentioned above.  If you do not need this functionality, simply use
 @ref KCompletionBase::setHandleSignals(bool) or alternatively set the boolean
 parameter in the @p setCompletionObject call to FALSE.

 The default key-bindings for completion and rotation is determined from the
 global settings in @ref KStdAccel. These values, however, can be overriden
 locally by invoking @ref KCompletionBase::setKeyBinding(). The values can
 easily be reverted back to the default setting, by simply calling 
 @ref useGlobalSettings(). An alternate method would be to default individual
 key-bindings by usning @ref setKeyBinding() with the default second argument.

 In non-editable (select-only) mode only one completion mode, @p CompletionAuto, 
 is available. All the other modes are simply ignored. Moreover, the CompletionAuto
 mode, unlike in the read-write mode, works by matching any typed key with the
 first letter of entries in the combobox.

 To enable the basic completion feature:

 <pre>
 KComboBox *combo = new KComboBox( true, this, "mywidget" );
 KCompletion *comp = combo->completionObject();
 // Connect to the return pressed signal - optional
 connect(combo,SIGNAL(returnPressed(const QString&)),comp,SLOT(addItem(const QString&));

 // Provide the to be completed strings. Note that those are separate from the combo's
 // contents.
 comp->insertItems( someQStringList );
 </pre>

 To use your own completion object:

 <pre>
 KComboBox *combo = new KComboBox( this,"mywidget" );
 KURLCompletion *comp = new KURLCompletion();
 combo->setCompletionObject( comp );
 // Connect to the return pressed signal - optional
 connect(combo,SIGNAL(returnPressed(const QString&)),comp,SLOT(addItem(const QString&));
 </pre>

 Note that you have to either delete the allocated completion object
 when you don't need it anymore, or call
 setAutoDeleteCompletionObject( true );

 Miscellaneous function calls:

 <pre>
 // Tell the widget not to handle completion and rotation
 combo->setHandleSignals( false );
 // Set your own completion key for manual completions.
 combo->setKeyBinding( KCompletionBase::TextCompletion, Qt::End );
 // Hide the context (popup) menu
 combo->setContextMenuEnabled( false );
 </pre>

 @author Dawit Alemayehu <adawit@kde.org>
 
 @short An enhanced combo box.

*/

/** *
 Constructs a read-only or rather select-only combo box with a
 parent object and a name.

*/
kde_KComboBox * kde_new_KComboBox(qt_QWidget * parent, char* name);

/** *
 Constructs a "read-write" or "read-only" combo box depending on
 the value of the first argument( @p rw ) with a parent, a
 name.

*/
kde_KComboBox * kde_new_KComboBox1(int rw, qt_QWidget * parent, char* name);

/** *
 Destructor.
    
*/
void kde_del_KComboBox( kde_KComboBox* p );

/** *
 Sets @p url into the edit field of the combobox. It uses
 @ref KURL::prettyURL() so that the url is properly decoded for
 displaying.
     
*/
void kde_KComboBox_setEditURL(kde_KComboBox* instPointer,kde_KURL* url);

/** *
 Inserts @p url at position @p index into the combobox. The item will
 be appended if @p index is negative. @ref KURL::prettyURL() is used
 so that the url is properly decoded for displaying.
     
*/
void kde_KComboBox_insertURL(kde_KComboBox* instPointer,kde_KURL* url, int index);

/** *
 Inserts @p url with the pixmap &p pixmap at position @p index into
 the combobox. The item will be appended if @p index is negative.
 @ref KURL::prettyURL() is used so that the url is properly decoded
 for displaying.
     
*/
void kde_KComboBox_insertURL1(kde_KComboBox* instPointer,qt_QPixmap * pixmap, kde_KURL* url, int index);

/** *
 Replaces the item at position @p index with @p url.
 @ref KURL::prettyURL() is used so that the url is properly decoded
 for displaying.
     
*/
void kde_KComboBox_changeURL(kde_KComboBox* instPointer,kde_KURL* url, int index);

/** *
 Replaces the item at position @p index with @p url and pixmap @p pixmap.
 @ref KURL::prettyURL() is used so that the url is properly decoded
 for displaying.
     
*/
void kde_KComboBox_changeURL1(kde_KComboBox* instPointer,qt_QPixmap * pixmap, kde_KURL* url, int index);

/** *
 Returns the current cursor position.

 This method always returns a -1 if the combo-box is @em not
 editable (read-write).

*/
int kde_KComboBox_cursorPosition(kde_KComboBox* instPointer);

/** *
 Re-implemented from @ref QComboBox.

 If @p true, the completion mode will be set to automatic.
 Otherwise, it is defaulted to the global setting.  This
 method has been replaced by the more comprehensive
 @ref setCompletionMode().

*/
void kde_KComboBox_setAutoCompletion(kde_KComboBox* instPointer,int autocomplete);

/** *
 Re-implemented from QComboBox.

 Returns @p true if the current completion mode is set
 to automatic.  See its more comprehensive replacement
 @ref completionMode().

*/
int kde_KComboBox_autoCompletion(kde_KComboBox* instPointer);

/** *
 Enables or disable the popup (context) menu.

 This method only works if this widget is editable, i.e.
 read-write and allows you to enable/disable the context
 menu.  It does nothing if invoked for a none-editable
 combo-box.  Note that by default the mode changer item
 is made visiable whenever the context menu is enabled.
 Use @ref hideModechanger() if you want to hide this
 item.    Also by default, the context menu is created if
 this widget is editable. Call this function with the
 argument set to false to disable the popup menu.

*/
void kde_KComboBox_setContextMenuEnabled(kde_KComboBox* instPointer,int showMenu);

/** *
 Returns @p true when the context menu is enabled.
    
*/
int kde_KComboBox_isContextMenuEnabled(kde_KComboBox* instPointer);

/** *
 Enables/Disables handling of URL drops. If enabled and the user
 drops an URL, the decoded URL will be inserted. Otherwise the default
 behaviour of QComboBox is used, which inserts the encoded URL.

*/
void kde_KComboBox_setURLDropsEnabled(kde_KComboBox* instPointer,int enable);

/** *
 Returns @p true when decoded URL drops are enabled
     
*/
int kde_KComboBox_isURLDropsEnabled(kde_KComboBox* instPointer);

/** *
 Convenience method which iterates over all items and checks if
 any of them is equal to @p text.

 If @p text is an empty string, @p false
 is returned.

*/
int kde_KComboBox_contains(kde_KComboBox* instPointer,qt_QString * text);

/** *
 By default, KComboBox recognizes Key_Return and Key_Enter
 and emits
 the @ref returnPressed() signals, but it also lets the event pass,
 for example causing a dialog's default-button to be called.

 Call this method with @p trap equal to true to make KComboBox
 stop these
 events. The signals will still be emitted of course.

 Only affects read-writable comboboxes.

*/
void kde_KComboBox_setTrapReturnKey(kde_KComboBox* instPointer,int trap);

/** *

*/
int kde_KComboBox_trapReturnKey(kde_KComboBox* instPointer);

/** *

*/
kde_KCompletionBox* kde_KComboBox_completionBox(kde_KComboBox* instPointer,int create);
void kde_KComboBox_setLineEdit(kde_KComboBox* instPointer,qt_QLineEdit* arg1);

/** *
 Iterates through all possible matches of the completed text
 or the history list.

 Depending on the value of the argument, this function either
 iterates through the history list of this widget or the all
 possible matches in whenever multiple matches result from a
 text completion request.  Note that the all-possible-match
 iteration will not work if there are no previous matches, i.e.
 no text has been completed and the *nix shell history list
 rotation is only available if the insertion policy for this
 widget is set either @p QComobBox::AtTop or @p QComboBox::AtBottom.
 For other insertion modes whatever has been typed by the user
 when the rotation event was initiated will be lost.

*/
void kde_KComboBox_rotateText(kde_KComboBox* instPointer,int arg1);

/** *
 Sets the completed text in the line-edit appropriately.

 This function is an implementation for
 @ref KCompletionBase::setCompletedText.
     
*/
void kde_KComboBox_setCompletedText(kde_KComboBox* instPointer,qt_QString * arg1);

/** *
 Sets @p items into the completion-box if @ref completionMode() is
 CompletionPopup. The popup will be shown immediately.
     
*/
void kde_KComboBox_setCompletedItems(kde_KComboBox* instPointer,qt_QStringList* items);

/** *
 Selects the first item that matches @p item. If there is no such item,
 it is inserted at position @p index if @p insert is true. Otherwise,
 no item is selected.
     
*/
void kde_KComboBox_setCurrentItem(kde_KComboBox* instPointer,qt_QString * item, int insert, int index);
void kde_KComboBox_setCurrentItem1(kde_KComboBox* instPointer,int index);
void kde_KComboBox_setCompletedText1(kde_KComboBox* instPointer,qt_QString * arg1, int arg2);

/** *
 Reimplemented for internal reasons, the API is not affected.
     
*/
void kde_KComboBox_create(kde_KComboBox* instPointer,unsigned int arg1, int initializeWindow, int destroyOldWindow);
void kde_KComboBox_virtual_hook(kde_KComboBox* instPointer,int identifier, void* data);

/** *

    
*/
void kde_KComboBox_itemSelected(kde_KComboBox* instPointer,qt_QListBoxItem * arg1);

/** *
 Completes text according to the completion mode.

 Note: this method is @p not invoked if the completion mode is
 set to CompletionNone.  Also if the mode is set to @p CompletionShell
 and multiple matches are found, this method will complete the
 text to the first match with a beep to inidicate that there are
 more matches.  Then any successive completion key event iterates
 through the remaining matches.  This way the rotation functionality
 is left to iterate through the list as usual.
    
*/
void kde_KComboBox_makeCompletion(kde_KComboBox* instPointer,qt_QString * arg1);

/** Casts a 'kde_KComboBox *' to a 'kde_KCompletionBase*' */
kde_KCompletionBase* kde_KComboBox_KCompletionBase(kde_KComboBox* instPointer);

/** Casts a 'kde_KComboBox *' to a 'qt_QComboBox*' */
qt_QComboBox* kde_KComboBox_QComboBox(kde_KComboBox* instPointer);

#endif
