/* This file is part of Webarchiver
 *  Copyright (C) 2001 by Andreas Schlapbach <schlpbch@iam.unibe.ch>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 **/

/* $Id: plugin_webarchiver.h,v 1.4 2001/10/29 16:34:03 hausmann Exp $ */

#ifndef plugin_webarchiver_h
#define plugin_webarchiver_h

#include <dom/dom_core.h>
#include <qtextstream.h>
#include <qdict.h>
#include <kparts/plugin.h>
#include <klibloader.h>
#include <ktar.h>

class KURL;

class PluginWebArchiver : public KParts::Plugin
{
  Q_OBJECT

 public:
  PluginWebArchiver( QObject* parent, const char* name,
                     const QStringList & );
  virtual ~PluginWebArchiver();

 public slots:
   void slotSaveToArchive();

 private:
   void saveFile( const QString& fileName, const KHTMLPart *part);
   void saveToArchive(const KHTMLPart *part, QTextStream* _textStream);
   void saveArchiveRecursive(const DOM::Node &node, const KURL& baseURL,
			     QTextStream* _textStream, int ident);
   QString handleLink(const KURL& _url, const QString & _link);
   KURL getAbsoluteURL(const KURL& _url, const QString& _link);
   QString getUniqueFileName(const QString& fileName);
   QString stringToHTML(const QString& string);
   QString analyzeInternalCSS(const KURL& _url, const QString& string);
   
   QDict<QString> * m_downloadedURLDict; 
   QDict<QString> * m_linkDict;
   KTarGz* m_tarBall;
   bool m_bPreserveWS;
};

#endif
