/*
 * crc16.c
 *
 * Copyright (C) 1994 Klaus Kudielka
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <unistd.h>
#include "crc16.h"

void crc16_init(crc16_t       poly,
                crc16_table_t table)
{
  unsigned bit, flag, index;

  for (index = 0; index < 256; index++)
  {
    *table = 0;
    for (bit = 0; bit < 8; bit++)
    {
      flag = ((index << (bit+8)) ^ *table) & 0x8000;
      *table <<= 1;
      if (flag) *table ^= poly;
    }
    table++;
  }
}

unsigned short crc16(unsigned char *data,
                     size_t        bytes,
                     crc16_t       crc,
                     crc16_table_t table)
{
  while (bytes--) crc = (crc<<8) ^ table[(crc>>8)^(*data++)];
  return crc;
}

