/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.color.ProfileDataException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.color.CMM;
import sun.awt.color.CMMImageLayout;
import sun.awt.color.ProfileDeferralMgr;
import sun.awt.color.pelArrayInfo;

public class ICC_Transform {
    long ID;
    public static final int Any = -1;
    public static final int In = 1;
    public static final int Out = 2;
    public static final int Gamut = 3;
    public static final int Simulation = 4;
    static /* synthetic */ Class class$java$awt$image$ComponentColorModel;

    public ICC_Transform() {
    }

    public ICC_Transform(ICC_Profile iCC_Profile, int n2, int n3) {
        if (iCC_Profile == null) {
            CMM.checkStatus(503);
        }
        CMM.checkStatus(CMM.cmmGetTransform(iCC_Profile, n2, n3, this));
    }

    public ICC_Transform(ICC_Transform[] iCC_TransformArray) {
        int n2 = iCC_TransformArray.length;
        long[] lArray = new long[n2];
        int n3 = 0;
        while (n3 < n2) {
            lArray[n3] = iCC_TransformArray[n3].ID;
            ++n3;
        }
        int n4 = CMM.cmmCombineTransforms(lArray, this);
        if (n4 != 0 || this.ID == 0L) {
            throw new ProfileDataException("Invalid profile sequence");
        }
    }

    long getID() {
        return this.ID;
    }

    public void finalize() {
        CMM.checkStatus(CMM.cmmFreeTransform(this.ID));
    }

    public int getNumInComponents() {
        int[] nArray = new int[2];
        CMM.checkStatus(CMM.cmmGetNumComponents(this.ID, nArray));
        return nArray[0];
    }

    public int getNumOutComponents() {
        int[] nArray = new int[2];
        CMM.checkStatus(CMM.cmmGetNumComponents(this.ID, nArray));
        return nArray[1];
    }

    public void colorConvert(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        CMMImageLayout cMMImageLayout;
        CMMImageLayout cMMImageLayout2 = this.getImageLayout(bufferedImage);
        if (cMMImageLayout2 != null && (cMMImageLayout = this.getImageLayout(bufferedImage2)) != null) {
            CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
            return;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        ColorModel colorModel2 = bufferedImage2.getColorModel();
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = colorModel.getNumColorComponents();
        int n5 = colorModel2.getNumColorComponents();
        int n6 = 8;
        float f2 = 255.0f;
        int n7 = 0;
        while (n7 < n4) {
            if (colorModel.getComponentSize(n7) > 8) {
                n6 = 16;
                f2 = 65535.0f;
            }
            ++n7;
        }
        int n8 = 0;
        while (n8 < n5) {
            if (colorModel2.getComponentSize(n8) > 8) {
                n6 = 16;
                f2 = 65535.0f;
            }
            ++n8;
        }
        float[] fArray = new float[n4];
        float[] fArray2 = new float[n4];
        ColorSpace colorSpace = colorModel.getColorSpace();
        int n9 = 0;
        while (n9 < n4) {
            fArray[n9] = colorSpace.getMinValue(n9);
            fArray2[n9] = f2 / (colorSpace.getMaxValue(n9) - fArray[n9]);
            ++n9;
        }
        colorSpace = colorModel2.getColorSpace();
        float[] fArray3 = new float[n5];
        float[] fArray4 = new float[n5];
        int n10 = 0;
        while (n10 < n5) {
            fArray3[n10] = colorSpace.getMinValue(n10);
            fArray4[n10] = (colorSpace.getMaxValue(n10) - fArray3[n10]) / f2;
            ++n10;
        }
        boolean bl2 = colorModel2.hasAlpha();
        boolean bl3 = colorModel.hasAlpha() && bl2;
        float[] fArray5 = bl2 ? new float[n5 + 1] : new float[n5];
        if (n6 == 8) {
            byte[] byArray = new byte[n2 * n4];
            byte[] byArray2 = new byte[n2 * n5];
            float[] fArray6 = null;
            if (bl3) {
                fArray6 = new float[n2];
            }
            pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, byArray, byArray2);
            cMMImageLayout2 = new CMMImageLayout(byArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
            cMMImageLayout = new CMMImageLayout(byArray2, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
            int n11 = 0;
            while (n11 < n3) {
                int n12;
                Object object = null;
                float[] fArray7 = null;
                int n13 = 0;
                int n14 = 0;
                while (n14 < n2) {
                    object = writableRaster.getDataElements(n14, n11, object);
                    fArray7 = colorModel.getNormalizedComponents(object, fArray7, 0);
                    n12 = 0;
                    while (n12 < n4) {
                        byArray[n13++] = (byte)((fArray7[n12] - fArray[n12]) * fArray2[n12] + 0.5f);
                        ++n12;
                    }
                    if (bl3) {
                        fArray6[n14] = fArray7[n4];
                    }
                    ++n14;
                }
                CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
                object = null;
                n13 = 0;
                n12 = 0;
                while (n12 < n2) {
                    int n15 = 0;
                    while (n15 < n5) {
                        fArray5[n15] = (float)(byArray2[n13++] & 0xFF) * fArray4[n15] + fArray3[n15];
                        ++n15;
                    }
                    if (bl3) {
                        fArray5[n5] = fArray6[n12];
                    } else if (bl2) {
                        fArray5[n5] = 1.0f;
                    }
                    object = colorModel2.getDataElements(fArray5, 0, object);
                    writableRaster2.setDataElements(n12, n11, object);
                    ++n12;
                }
                ++n11;
            }
        } else {
            short[] sArray = new short[n2 * n4];
            short[] sArray2 = new short[n2 * n5];
            float[] fArray8 = null;
            if (bl3) {
                fArray8 = new float[n2];
            }
            pelArrayInfo pelArrayInfo3 = new pelArrayInfo(this, sArray, sArray2);
            cMMImageLayout2 = new CMMImageLayout(sArray, pelArrayInfo3.nPels, pelArrayInfo3.nSrc);
            cMMImageLayout = new CMMImageLayout(sArray2, pelArrayInfo3.nPels, pelArrayInfo3.nDest);
            int n16 = 0;
            while (n16 < n3) {
                int n17;
                Object object = null;
                float[] fArray9 = null;
                int n18 = 0;
                int n19 = 0;
                while (n19 < n2) {
                    object = writableRaster.getDataElements(n19, n16, object);
                    fArray9 = colorModel.getNormalizedComponents(object, fArray9, 0);
                    n17 = 0;
                    while (n17 < n4) {
                        sArray[n18++] = (short)((fArray9[n17] - fArray[n17]) * fArray2[n17] + 0.5f);
                        ++n17;
                    }
                    if (bl3) {
                        fArray8[n19] = fArray9[n4];
                    }
                    ++n19;
                }
                CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
                object = null;
                n18 = 0;
                n17 = 0;
                while (n17 < n2) {
                    int n20 = 0;
                    while (n20 < n5) {
                        fArray5[n20] = (float)(sArray2[n18++] & 0xFFFF) * fArray4[n20] + fArray3[n20];
                        ++n20;
                    }
                    if (bl3) {
                        fArray5[n5] = fArray8[n17];
                    } else if (bl2) {
                        fArray5[n5] = 1.0f;
                    }
                    object = colorModel2.getDataElements(fArray5, 0, object);
                    writableRaster2.setDataElements(n17, n16, object);
                    ++n17;
                }
                ++n16;
            }
        }
    }

    private CMMImageLayout getImageLayout(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 1: 
            case 2: 
            case 4: {
                return new CMMImageLayout(bufferedImage);
            }
            case 5: 
            case 6: {
                ComponentColorModel componentColorModel = (ComponentColorModel)bufferedImage.getColorModel();
                if (componentColorModel.getClass() == (class$java$awt$image$ComponentColorModel == null ? (class$java$awt$image$ComponentColorModel = ICC_Transform.class$("java.awt.image.ComponentColorModel")) : class$java$awt$image$ComponentColorModel) || this.checkMinMaxScaling(componentColorModel)) {
                    return new CMMImageLayout(bufferedImage);
                }
                return null;
            }
            case 10: {
                ComponentColorModel componentColorModel = (ComponentColorModel)bufferedImage.getColorModel();
                if (componentColorModel.getComponentSize(0) != 8) {
                    return null;
                }
                if (componentColorModel.getClass() == (class$java$awt$image$ComponentColorModel == null ? (class$java$awt$image$ComponentColorModel = ICC_Transform.class$("java.awt.image.ComponentColorModel")) : class$java$awt$image$ComponentColorModel) || this.checkMinMaxScaling(componentColorModel)) {
                    return new CMMImageLayout(bufferedImage);
                }
                return null;
            }
            case 11: {
                ComponentColorModel componentColorModel = (ComponentColorModel)bufferedImage.getColorModel();
                if (componentColorModel.getComponentSize(0) != 16) {
                    return null;
                }
                if (componentColorModel.getClass() == (class$java$awt$image$ComponentColorModel == null ? (class$java$awt$image$ComponentColorModel = ICC_Transform.class$("java.awt.image.ComponentColorModel")) : class$java$awt$image$ComponentColorModel) || this.checkMinMaxScaling(componentColorModel)) {
                    return new CMMImageLayout(bufferedImage);
                }
                return null;
            }
        }
        ColorModel colorModel = bufferedImage.getColorModel();
        if (colorModel instanceof DirectColorModel) {
            SampleModel sampleModel = bufferedImage.getSampleModel();
            if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
                return null;
            }
            if (colorModel.getTransferType() != 3) {
                return null;
            }
            if (colorModel.hasAlpha() && colorModel.isAlphaPremultiplied()) {
                return null;
            }
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            int n2 = directColorModel.getRedMask();
            int n3 = directColorModel.getGreenMask();
            int n4 = directColorModel.getBlueMask();
            int n5 = directColorModel.getAlphaMask();
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            int n10 = 0;
            int n11 = 3;
            if (n5 != 0) {
                n11 = 4;
            }
            int n12 = 0;
            int n13 = -16777216;
            while (n12 < 4) {
                if (n2 == n13) {
                    n9 = n12;
                    ++n10;
                } else if (n3 == n13) {
                    n8 = n12;
                    ++n10;
                } else if (n4 == n13) {
                    n7 = n12;
                    ++n10;
                } else if (n5 == n13) {
                    n6 = n12;
                    ++n10;
                }
                ++n12;
                n13 >>>= 8;
            }
            if (n10 != n11) {
                return null;
            }
            return new CMMImageLayout(bufferedImage, (SinglePixelPackedSampleModel)sampleModel, n9, n8, n7, n6);
        }
        if (colorModel instanceof ComponentColorModel) {
            int n14;
            SampleModel sampleModel = bufferedImage.getSampleModel();
            if (!(sampleModel instanceof ComponentSampleModel)) {
                return null;
            }
            if (colorModel.hasAlpha() && colorModel.isAlphaPremultiplied()) {
                return null;
            }
            int n15 = colorModel.getNumComponents();
            if (sampleModel.getNumBands() != n15) {
                return null;
            }
            int n16 = colorModel.getTransferType();
            if (n16 == 0) {
                n14 = 0;
                while (n14 < n15) {
                    if (colorModel.getComponentSize(n14) != 8) {
                        return null;
                    }
                    ++n14;
                }
            } else if (n16 == 1) {
                n14 = 0;
                while (n14 < n15) {
                    if (colorModel.getComponentSize(n14) != 16) {
                        return null;
                    }
                    ++n14;
                }
            } else {
                return null;
            }
            ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
            if (componentColorModel.getClass() == (class$java$awt$image$ComponentColorModel == null ? (class$java$awt$image$ComponentColorModel = ICC_Transform.class$("java.awt.image.ComponentColorModel")) : class$java$awt$image$ComponentColorModel) || this.checkMinMaxScaling(componentColorModel)) {
                return new CMMImageLayout(bufferedImage, (ComponentSampleModel)sampleModel);
            }
            return null;
        }
        return null;
    }

    private boolean checkMinMaxScaling(ComponentColorModel componentColorModel) {
        float f2;
        float[] fArray;
        float[] fArray2;
        int n2;
        Object object;
        int n3 = componentColorModel.getNumComponents();
        int n4 = componentColorModel.getNumColorComponents();
        int[] nArray = componentColorModel.getComponentSize();
        boolean bl2 = componentColorModel.hasAlpha();
        switch (componentColorModel.getTransferType()) {
            case 0: {
                object = new byte[n3];
                n2 = 0;
                while (n2 < n4) {
                    object[n2] = 0;
                    ++n2;
                }
                if (bl2) {
                    object[n4] = (byte)((1 << nArray[n4]) - 1);
                }
                fArray2 = componentColorModel.getNormalizedComponents(object, null, 0);
                int n5 = 0;
                while (n5 < n4) {
                    object[n5] = (byte)((1 << nArray[n5]) - 1);
                    ++n5;
                }
                fArray = componentColorModel.getNormalizedComponents(object, null, 0);
                f2 = 256.0f;
                break;
            }
            case 1: {
                object = new short[n3];
                n2 = 0;
                while (n2 < n4) {
                    object[n2] = 0;
                    ++n2;
                }
                if (bl2) {
                    object[n4] = (byte)((1 << nArray[n4]) - 1);
                }
                fArray2 = componentColorModel.getNormalizedComponents(object, null, 0);
                int n5 = 0;
                while (n5 < n4) {
                    object[n5] = (byte)((1 << nArray[n5]) - 1);
                    ++n5;
                }
                fArray = componentColorModel.getNormalizedComponents(object, null, 0);
                f2 = 65536.0f;
                break;
            }
            default: {
                return false;
            }
        }
        object = componentColorModel.getColorSpace();
        n2 = 0;
        while (n2 < n4) {
            float f3 = ((ColorSpace)object).getMinValue(n2);
            float f4 = ((ColorSpace)object).getMaxValue(n2);
            float f5 = (f4 - f3) / f2;
            if ((f3 -= fArray2[n2]) < 0.0f) {
                f3 = -f3;
            }
            if ((f4 -= fArray[n2]) < 0.0f) {
                f4 = -f4;
            }
            if (f3 > f5 || f4 > f5) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void colorConvert(Raster raster, WritableRaster writableRaster, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        SampleModel sampleModel = raster.getSampleModel();
        SampleModel sampleModel2 = writableRaster.getSampleModel();
        int n2 = raster.getTransferType();
        int n3 = writableRaster.getTransferType();
        boolean bl2 = n2 == 4 || n2 == 5;
        boolean bl3 = n3 == 4 || n3 == 5;
        int n4 = raster.getWidth();
        int n5 = raster.getHeight();
        int n6 = raster.getNumBands();
        int n7 = writableRaster.getNumBands();
        float[] fArray5 = new float[n6];
        float[] fArray6 = new float[n7];
        float[] fArray7 = new float[n6];
        float[] fArray8 = new float[n7];
        int n8 = 0;
        while (n8 < n6) {
            if (bl2) {
                fArray5[n8] = 65535.0f / (fArray2[n8] - fArray[n8]);
                fArray7[n8] = fArray[n8];
            } else {
                fArray5[n8] = n2 == 2 ? 2.0000305f : 65535.0f / (float)((1 << sampleModel.getSampleSize(n8)) - 1);
                fArray7[n8] = 0.0f;
            }
            ++n8;
        }
        int n9 = 0;
        while (n9 < n7) {
            if (bl3) {
                fArray6[n9] = (fArray4[n9] - fArray3[n9]) / 65535.0f;
                fArray8[n9] = fArray3[n9];
            } else {
                fArray6[n9] = n3 == 2 ? 0.49999237f : (float)((1 << sampleModel2.getSampleSize(n9)) - 1) / 65535.0f;
                fArray8[n9] = 0.0f;
            }
            ++n9;
        }
        int n10 = raster.getMinY();
        int n11 = writableRaster.getMinY();
        short[] sArray = new short[n4 * n6];
        short[] sArray2 = new short[n4 * n7];
        pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, sArray, sArray2);
        CMMImageLayout cMMImageLayout = new CMMImageLayout(sArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
        CMMImageLayout cMMImageLayout2 = new CMMImageLayout(sArray2, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
        int n12 = 0;
        while (n12 < n5) {
            float f2;
            int n13;
            int n14 = raster.getMinX();
            int n15 = 0;
            int n16 = 0;
            while (n16 < n4) {
                n13 = 0;
                while (n13 < n6) {
                    f2 = raster.getSampleFloat(n14, n10, n13);
                    sArray[n15++] = (short)((f2 - fArray7[n13]) * fArray5[n13] + 0.5f);
                    ++n13;
                }
                ++n16;
                ++n14;
            }
            CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout, cMMImageLayout2));
            int n17 = writableRaster.getMinX();
            n15 = 0;
            n13 = 0;
            while (n13 < n4) {
                int n18 = 0;
                while (n18 < n7) {
                    f2 = (float)(sArray2[n15++] & 0xFFFF) * fArray6[n18] + fArray8[n18];
                    writableRaster.setSample(n17, n11, n18, f2);
                    ++n18;
                }
                ++n13;
                ++n17;
            }
            ++n12;
            ++n10;
            ++n11;
        }
    }

    public void colorConvert(Raster raster, WritableRaster writableRaster) {
        CMMImageLayout cMMImageLayout;
        CMMImageLayout cMMImageLayout2 = this.getImageLayout(raster);
        if (cMMImageLayout2 != null && (cMMImageLayout = this.getImageLayout(writableRaster)) != null) {
            CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
            return;
        }
        SampleModel sampleModel = raster.getSampleModel();
        SampleModel sampleModel2 = writableRaster.getSampleModel();
        int n2 = raster.getTransferType();
        int n3 = writableRaster.getTransferType();
        int n4 = raster.getWidth();
        int n5 = raster.getHeight();
        int n6 = raster.getNumBands();
        int n7 = writableRaster.getNumBands();
        int n8 = 8;
        float f2 = 255.0f;
        int n9 = 0;
        while (n9 < n6) {
            if (sampleModel.getSampleSize(n9) > 8) {
                n8 = 16;
                f2 = 65535.0f;
            }
            ++n9;
        }
        int n10 = 0;
        while (n10 < n7) {
            if (sampleModel2.getSampleSize(n10) > 8) {
                n8 = 16;
                f2 = 65535.0f;
            }
            ++n10;
        }
        float[] fArray = new float[n6];
        float[] fArray2 = new float[n7];
        int n11 = 0;
        while (n11 < n6) {
            fArray[n11] = n2 == 2 ? f2 / 32767.0f : f2 / (float)((1 << sampleModel.getSampleSize(n11)) - 1);
            ++n11;
        }
        int n12 = 0;
        while (n12 < n7) {
            fArray2[n12] = n3 == 2 ? 32767.0f / f2 : (float)((1 << sampleModel2.getSampleSize(n12)) - 1) / f2;
            ++n12;
        }
        int n13 = raster.getMinY();
        int n14 = writableRaster.getMinY();
        if (n8 == 8) {
            byte[] byArray = new byte[n4 * n6];
            byte[] byArray2 = new byte[n4 * n7];
            pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, byArray, byArray2);
            cMMImageLayout2 = new CMMImageLayout(byArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
            cMMImageLayout = new CMMImageLayout(byArray2, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
            int n15 = 0;
            while (n15 < n5) {
                int n16;
                int n17;
                int n18 = raster.getMinX();
                int n19 = 0;
                int n20 = 0;
                while (n20 < n4) {
                    n17 = 0;
                    while (n17 < n6) {
                        n16 = raster.getSample(n18, n13, n17);
                        byArray[n19++] = (byte)((float)n16 * fArray[n17] + 0.5f);
                        ++n17;
                    }
                    ++n20;
                    ++n18;
                }
                CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
                int n21 = writableRaster.getMinX();
                n19 = 0;
                n17 = 0;
                while (n17 < n4) {
                    int n22 = 0;
                    while (n22 < n7) {
                        n16 = (int)((float)(byArray2[n19++] & 0xFF) * fArray2[n22] + 0.5f);
                        writableRaster.setSample(n21, n14, n22, n16);
                        ++n22;
                    }
                    ++n17;
                    ++n21;
                }
                ++n15;
                ++n13;
                ++n14;
            }
        } else {
            short[] sArray = new short[n4 * n6];
            short[] sArray2 = new short[n4 * n7];
            pelArrayInfo pelArrayInfo3 = new pelArrayInfo(this, sArray, sArray2);
            cMMImageLayout2 = new CMMImageLayout(sArray, pelArrayInfo3.nPels, pelArrayInfo3.nSrc);
            cMMImageLayout = new CMMImageLayout(sArray2, pelArrayInfo3.nPels, pelArrayInfo3.nDest);
            int n23 = 0;
            while (n23 < n5) {
                int n24;
                int n25;
                int n26 = raster.getMinX();
                int n27 = 0;
                int n28 = 0;
                while (n28 < n4) {
                    n25 = 0;
                    while (n25 < n6) {
                        n24 = raster.getSample(n26, n13, n25);
                        sArray[n27++] = (short)((float)n24 * fArray[n25] + 0.5f);
                        ++n25;
                    }
                    ++n28;
                    ++n26;
                }
                CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
                int n29 = writableRaster.getMinX();
                n27 = 0;
                n25 = 0;
                while (n25 < n4) {
                    int n30 = 0;
                    while (n30 < n7) {
                        n24 = (int)((float)(sArray2[n27++] & 0xFFFF) * fArray2[n30] + 0.5f);
                        writableRaster.setSample(n29, n14, n30, n24);
                        ++n30;
                    }
                    ++n25;
                    ++n29;
                }
                ++n23;
                ++n13;
                ++n14;
            }
        }
    }

    private CMMImageLayout getImageLayout(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel instanceof ComponentSampleModel) {
            int n2 = raster.getNumBands();
            int n3 = sampleModel.getTransferType();
            if (n3 == 0) {
                int n4 = 0;
                while (n4 < n2) {
                    if (sampleModel.getSampleSize(n4) != 8) {
                        return null;
                    }
                    ++n4;
                }
            } else if (n3 == 1) {
                int n5 = 0;
                while (n5 < n2) {
                    if (sampleModel.getSampleSize(n5) != 16) {
                        return null;
                    }
                    ++n5;
                }
            } else {
                return null;
            }
            return new CMMImageLayout(raster, (ComponentSampleModel)sampleModel);
        }
        return null;
    }

    public short[] colorConvert(short[] sArray, short[] sArray2) {
        pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, sArray, sArray2);
        short[] sArray3 = sArray2 != null ? sArray2 : new short[pelArrayInfo2.destSize];
        CMMImageLayout cMMImageLayout = new CMMImageLayout(sArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
        CMMImageLayout cMMImageLayout2 = new CMMImageLayout(sArray3, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
        CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout, cMMImageLayout2));
        return sArray3;
    }

    public byte[] colorConvert(byte[] byArray, byte[] byArray2) {
        pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, byArray, byArray2);
        byte[] byArray3 = byArray2 != null ? byArray2 : new byte[pelArrayInfo2.destSize];
        CMMImageLayout cMMImageLayout = new CMMImageLayout(byArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
        CMMImageLayout cMMImageLayout2 = new CMMImageLayout(byArray3, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
        CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout, cMMImageLayout2));
        return byArray3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
    }
}

