/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class DesktopProperty
implements UIDefaults.ActiveValue {
    private static boolean updatePending;
    private WeakPCL pcl;
    private String key;
    private Object value;
    private Object fallback;
    private Toolkit toolkit;

    private static synchronized void setUpdatePending(boolean bl2) {
        updatePending = bl2;
    }

    private static synchronized boolean isUpdatePending() {
        return updatePending;
    }

    private static void updateAllUIs() {
        Frame[] frameArray = Frame.getFrames();
        int n2 = 0;
        while (n2 < frameArray.length) {
            DesktopProperty.updateWindowUI(frameArray[n2]);
            ++n2;
        }
    }

    private static void updateWindowUI(Window window) {
        SwingUtilities.updateComponentTreeUI(window);
        Window[] windowArray = window.getOwnedWindows();
        int n2 = 0;
        while (n2 < windowArray.length) {
            DesktopProperty.updateWindowUI(windowArray[n2]);
            ++n2;
        }
    }

    public DesktopProperty(String string, Object object, Toolkit toolkit) {
        this.key = string;
        this.fallback = object;
        this.toolkit = toolkit;
    }

    public Object createValue(UIDefaults uIDefaults) {
        if (this.value == null) {
            this.value = this.configureValue(this.getValueFromDesktop());
            if (this.value == null) {
                this.value = this.configureValue(this.getDefaultValue());
            }
        }
        return this.value;
    }

    protected Object getValueFromDesktop() {
        if (this.toolkit == null) {
            this.toolkit = Toolkit.getDefaultToolkit();
        }
        Object object = this.toolkit.getDesktopProperty(this.getKey());
        this.pcl = new WeakPCL((Object)this, this.toolkit);
        this.toolkit.addPropertyChangeListener(this.getKey(), this.pcl);
        return object;
    }

    protected Object getDefaultValue() {
        return this.fallback;
    }

    public void invalidate() {
        if (this.pcl != null) {
            this.toolkit.removePropertyChangeListener(this.getKey(), this.pcl);
            this.toolkit = null;
            this.pcl = null;
            this.value = null;
        }
    }

    protected void updateUI() {
        if (!DesktopProperty.isUpdatePending()) {
            DesktopProperty.setUpdatePending(true);
            Runnable runnable = new Runnable(){

                public void run() {
                    DesktopProperty.updateAllUIs();
                    DesktopProperty.setUpdatePending(false);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected Object configureValue(Object object) {
        if (object != null) {
            if (object instanceof Color) {
                return new ColorUIResource((Color)object);
            }
            if (object instanceof Font) {
                return new FontUIResource((Font)object);
            }
            if (object instanceof UIDefaults.ProxyLazyValue) {
                object = ((UIDefaults.ProxyLazyValue)object).createValue(null);
            } else if (object instanceof UIDefaults.ActiveValue) {
                object = ((UIDefaults.ActiveValue)object).createValue(null);
            }
        }
        return object;
    }

    protected String getKey() {
        return this.key;
    }

    private static class WeakPCL
    extends WeakReference
    implements PropertyChangeListener {
        private Toolkit kit;

        WeakPCL(Object object, Toolkit toolkit) {
            super(object);
            this.kit = toolkit;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DesktopProperty desktopProperty = (DesktopProperty)this.get();
            if (desktopProperty == null) {
                this.kit.removePropertyChangeListener(propertyChangeEvent.getPropertyName(), this);
            } else {
                desktopProperty.invalidate();
                desktopProperty.updateUI();
            }
        }
    }
}

