/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.POA;

import com.sun.corba.se.internal.POA.POAPolicyCombinationValidator;
import java.util.HashMap;
import java.util.Iterator;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdUniquenessPolicy;
import org.omg.PortableServer.ImplicitActivationPolicy;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.RequestProcessingPolicy;
import org.omg.PortableServer.ServantRetentionPolicy;
import org.omg.PortableServer.ThreadPolicy;

public final class Policies {
    private boolean cachingServantAllowed = false;
    private int threadModel;
    private int lifespan;
    private int idUniqueness;
    private int idAssignment;
    private int retention;
    private int requestProcessing;
    private int implicitActivation;
    private HashMap policies = new HashMap();
    public static final Policies defaultPolicies = new Policies(0, 0, 0, 1, 0, 0, 1);
    public static final Policies rootPOAPolicies = new Policies(0, 0, 0, 1, 0, 0, 0);

    private Policies(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.threadModel = n2;
        this.lifespan = n3;
        this.idUniqueness = n4;
        this.idAssignment = n5;
        this.retention = n6;
        this.requestProcessing = n7;
        this.implicitActivation = n8;
    }

    Policies() {
        this.threadModel = Policies.defaultPolicies.threadModel;
        this.lifespan = Policies.defaultPolicies.lifespan;
        this.idUniqueness = Policies.defaultPolicies.idUniqueness;
        this.idAssignment = Policies.defaultPolicies.idAssignment;
        this.retention = Policies.defaultPolicies.retention;
        this.requestProcessing = Policies.defaultPolicies.requestProcessing;
        this.implicitActivation = Policies.defaultPolicies.implicitActivation;
    }

    Policies(int n2) {
        this.threadModel = (n2 & 0x80) >> 7;
        this.lifespan = (n2 & 0x40) >> 6;
        this.idUniqueness = (n2 & 0x20) >> 5;
        this.idAssignment = (n2 & 0x10) >> 4;
        this.implicitActivation = (n2 & 8) >> 3;
        this.retention = (n2 & 4) >> 2;
        this.requestProcessing = n2 & 3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Policies[");
        boolean bl2 = true;
        Iterator iterator = this.policies.values().iterator();
        while (iterator.hasNext()) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(iterator.next().toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    Policies(Policy[] policyArray) throws InvalidPolicy {
        this();
        if (policyArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < policyArray.length) {
            Policy policy = policyArray[n2];
            Integer n3 = new Integer(policy.policy_type());
            this.policies.put(n3, policy);
            if (policy instanceof ThreadPolicy) {
                this.threadModel = ((ThreadPolicy)policy).value().value();
            } else if (policy instanceof LifespanPolicy) {
                this.lifespan = ((LifespanPolicy)policy).value().value();
            } else if (policy instanceof IdUniquenessPolicy) {
                this.idUniqueness = ((IdUniquenessPolicy)policy).value().value();
            } else if (policy instanceof IdAssignmentPolicy) {
                this.idAssignment = ((IdAssignmentPolicy)policy).value().value();
            } else if (policy instanceof ServantRetentionPolicy) {
                this.retention = ((ServantRetentionPolicy)policy).value().value();
            } else if (policy instanceof RequestProcessingPolicy) {
                this.requestProcessing = ((RequestProcessingPolicy)policy).value().value();
            } else if (policy instanceof ImplicitActivationPolicy) {
                this.implicitActivation = ((ImplicitActivationPolicy)policy).value().value();
            } else if (policy.policy_type() == 0x53550000) {
                this.cachingServantAllowed = true;
            }
            n2 = (short)(n2 + 1);
        }
        short s2 = POAPolicyCombinationValidator.checkForInvalidPolicyCombinations(policyArray);
        if (s2 > -1) {
            this.invalidPolicy(s2);
        }
    }

    public Policy get_effective_policy(int n2) {
        Integer n3 = new Integer(n2);
        Policy policy = (Policy)this.policies.get(n3);
        return policy;
    }

    public final int getBitMap() {
        return this.threadModel << 7 | this.lifespan << 6 | this.idUniqueness << 5 | this.idAssignment << 4 | this.implicitActivation << 3 | this.retention << 2 | this.requestProcessing;
    }

    public final boolean servantCachingAllowed() {
        return this.cachingServantAllowed;
    }

    public final boolean isOrbControlledThreads() {
        return this.threadModel == 0;
    }

    public final boolean isSingleThreaded() {
        return this.threadModel == 1;
    }

    public final boolean isTransient() {
        return this.lifespan == 0;
    }

    public final boolean isPersistent() {
        return this.lifespan == 1;
    }

    public final boolean isUniqueIds() {
        return this.idUniqueness == 0;
    }

    public final boolean isMultipleIds() {
        return this.idUniqueness == 1;
    }

    public final boolean isUserAssignedIds() {
        return this.idAssignment == 0;
    }

    public final boolean isSystemAssignedIds() {
        return this.idAssignment == 1;
    }

    public final boolean retainServants() {
        return this.retention == 0;
    }

    public final boolean useActiveMapOnly() {
        return this.requestProcessing == 0;
    }

    public final boolean useDefaultServant() {
        return this.requestProcessing == 1;
    }

    public final boolean useServantManager() {
        return this.requestProcessing == 2;
    }

    public final boolean isImplicitlyActivated() {
        return this.implicitActivation == 0;
    }

    private void invalidPolicy(short s2) throws InvalidPolicy {
        throw new InvalidPolicy(s2);
    }
}

