// kmfolderdia.cpp

#include <assert.h>

#include <qcheckbox.h>
#include <qdir.h>
#include <qfile.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qtextstream.h>
#include <qvbox.h>

#include <klocale.h>
#include <kmessagebox.h>

#include "kmmainwin.h"
#include "kmglobal.h"
#include "kmaccount.h"
#include "kmacctmgr.h"
#include "kmacctfolder.h"
#include "kmfoldermgr.h"

#include "kmfolderdia.moc"


//-----------------------------------------------------------------------------
KMFolderDialog::KMFolderDialog(KMFolder* aFolder, KMFolderDir *aFolderDir,
			       QWidget *aParent, const QString& aCap):
  KMFolderDialogInherited( KDialogBase::Tabbed,
                           aCap, KDialogBase::Ok|KDialogBase::Cancel,
                           KDialogBase::Ok, aParent, "KMFolderDialog", TRUE ),
  folder((KMAcctFolder*)aFolder),mFolderDir( aFolderDir )
{
    qDebug("KMFolderDialog::KMFolderDialog()");

  // Main tab
  //
  QFrame *page = addPage( i18n("Folder Position"), i18n("Where the folder is located in the tree") );
  setMainWidget( page );

  QVBoxLayout *topLayout =  new QVBoxLayout( page, 0, spacingHint() );

  QHBoxLayout *hl = new QHBoxLayout();
  topLayout->addSpacing( spacingHint()*2 );
  topLayout->addLayout( hl );
  topLayout->addSpacing( spacingHint()*2 );

  QLabel *label = new QLabel( i18n("Name:"), page );
  hl->addWidget( label );

  nameEdit = new QLineEdit( page );
  nameEdit->setFocus();
  nameEdit->setText(folder ? folder->name() : i18n("unnamed"));
  nameEdit->setMinimumSize(nameEdit->sizeHint());
  nameEdit->selectAll();
  hl->addWidget( nameEdit );

  hl->addSpacing( spacingHint() );

  label = new QLabel( i18n("File under:" ), page );
  hl->addWidget( label );

  fileInFolder = new QComboBox(page);
  hl->addWidget( fileInFolder );

  QStringList str;
  kernel->folderMgr()->createFolderList( &str, &mFolders  );
  str.prepend( i18n( "Top Level" ));
  QGuardedPtr<KMFolder> curFolder;
  int i = 1;
  while (mFolders.at(i - 1) != mFolders.end()) {
    curFolder = *mFolders.at(i - 1);
    if (curFolder->isSystemFolder()) {
      mFolders.remove(mFolders.at(i-1));
      str.remove(str.at(i));
    } else
      ++i;
  }
  fileInFolder->insertStringList( str );

  for( i = 1; mFolders.at(i - 1) != mFolders.end(); ++i ) {
    curFolder = *mFolders.at(i - 1);
    if (curFolder->child() == aFolderDir)
      fileInFolder->setCurrentItem( i );
  }

  // Mailing-list data tab
  //
  page = addPage( i18n("Associated Mailing List"), i18n("Email addresses of the mailing-list related to this folder") );

  topLayout =  new QVBoxLayout( page, 0, spacingHint() );

  hl = new QHBoxLayout();
  topLayout->addSpacing( spacingHint()*2 );

  holdsMailingList = new QCheckBox( i18n("folder holds a mailing-list"), page);
  QObject::connect( holdsMailingList, SIGNAL(toggled(bool)),
                    this, SLOT(slotHoldsML(bool)) );

  topLayout->addWidget(holdsMailingList);

  topLayout->addSpacing( spacingHint()*2 );
  topLayout->addLayout( hl );
  topLayout->addSpacing( spacingHint()*2 );

  
  label = new QLabel( i18n("Post Address:"), page );
  hl->addWidget( label );
  mailingListPostAddress = new QLineEdit( page );
  mailingListPostAddress->setMinimumSize(mailingListPostAddress->sizeHint());
  hl->addWidget( mailingListPostAddress );

//   hl = new QHBoxLayout();
//   topLayout->addLayout( hl );

//   label = new QLabel( i18n("Admin Address:"), page );
//   hl->addWidget( label );
//   mailingListAdminAddress = new QLineEdit( page );
//   mailingListAdminAddress->setMinimumSize(mailingListAdminAddress->sizeHint());
//   hl->addWidget( mailingListAdminAddress );

  if (folder)
  {
    mailingListPostAddress->setText(folder->mailingListPostAddress());
//     mailingListAdminAddress->setText(folder->mailingListAdminAddress());
    mailingListPostAddress->setEnabled(folder->isMailingList());
//     mailingListAdminAddress->setEnabled(folder->isMailingList());
    holdsMailingList->setChecked(folder->isMailingList());
  }
  qDebug("Exiting KMFolderDialog::KMFolderDialog()");
}


//-----------------------------------------------------------------------------
void KMFolderDialog::slotOk()
{
  QString acctName;
  QString fldName, oldFldName;
  KMFolderDir *selectedFolderDir = &(kernel->folderMgr()->dir());
  int curFolder = fileInFolder->currentItem();

  if (folder) oldFldName = folder->name();
  if (!nameEdit->text().isEmpty()) fldName = nameEdit->text();
  else fldName = oldFldName;
  fldName.replace(QRegExp("/"), "");
  if (fldName.isEmpty()) fldName = i18n("unnamed");
  if (curFolder != 0)
    selectedFolderDir = (*mFolders.at(curFolder - 1))->createChildFolder();

  QString message = i18n( "Failed to create folder '%1', folder already exists." ).arg(fldName);
  if ((selectedFolderDir->hasNamedFolder(fldName)) &&
      (!((folder) &&
	 (selectedFolderDir == folder->parent()) &&
	 (folder->name() == fldName)))) {
    KMessageBox::error( this, message );
    return;
  }

  message = i18n( "Cannot move a parent folder into a child folder." );
  KMFolderDir* folderDir = selectedFolderDir;


  // Buggy?
  if (folder && folder->child())
    while ((folderDir != &kernel->folderMgr()->dir()) &&
	   (folderDir != folder->parent())){
      if (folderDir->findRef( folder ) != -1) {
	KMessageBox::error( this, message );
	return;
      }
      folderDir = folderDir->parent();
    }
  // End buggy?


  if (folder && folder->child() && (selectedFolderDir) &&
      (selectedFolderDir->path().find( folder->child()->path() + "/" ) == 0)) {
    KMessageBox::error( this, message );
    return;
  }

  if (folder && folder->child() && (selectedFolderDir == folder->child())) {
    KMessageBox::error( this, message );
    return;
  }

  if (!folder) {
    folder = (KMAcctFolder*)kernel->folderMgr()->createFolder(fldName, FALSE, selectedFolderDir );
  }
  else if ((oldFldName != fldName) || (folder->parent() != selectedFolderDir))
    {
      if (folder->parent() != selectedFolderDir)
	folder->rename(fldName, selectedFolderDir );
      else
	folder->rename(fldName);
      kernel->folderMgr()->contentsChanged();
    }

  folder->setMailingList( holdsMailingList->isChecked() );
  folder->setMailingListPostAddress( mailingListPostAddress->text() );
//   folder->setMailingListAdminAddress( mailingListAdminAddress->text() );
  folder->setMailingListAdminAddress( QString::null );

  KMFolderDialogInherited::slotOk();
}

//-----------------------------------------------------------------------------
void KMFolderDialog::slotHoldsML( bool holdsML )
{
  if ( holdsML )
  {
    mailingListPostAddress->setEnabled(true);
//     mailingListAdminAddress->setEnabled(true);
  }
  else
  {
    mailingListPostAddress->setEnabled(false);
//     mailingListAdminAddress->setEnabled(false);
  }
}

