#ifndef LISZT_H
#define LISZT_H

#include <noatunplaylist.h>
#include <plugin.h>

class EditWidget;

class Liszt : public PlayList, public Plugin
{
  Q_OBJECT
  NOATUNPLUGIND

  public:
    Liszt();
    ~Liszt();

    virtual void reset();
    virtual void clear();
    virtual void addFile(const KURL &, bool play = false);
    virtual PlayListItem * next();
    virtual PlayListItem * current();
    virtual PlayListItem * previous();

    virtual PlayListItem * getFirst() const;
    virtual PlayListItem * getAfter(const PlayListItem * item) const;
	
    virtual bool listVisible() const;

    virtual PlayList * playlist() const { return (PlayList*)this; }

  public slots:	

    virtual void showList();
    virtual void hideList();
    virtual void toggleList();
    virtual void remove(PlayListItem *);

    virtual void slotSkipToTrack(long);

  private:

    EditWidget * editWidget_;
};

#endif
