    /*

    Copyright (C) 2000 Stefan Westerfeld
                       stefan@space.twc.de

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
  
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
   
    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.

    */

#include "artsmodules.h"
#include "stdsynthmodule.h"

using namespace Arts;

class Synth_NOISE_impl : virtual public Synth_NOISE_skel,
							virtual public StdSynthModule
{
	float noise[4096];
	unsigned long pos;
public:
	void streamInit()
	{
		for(unsigned long i=0;i<4096;i++)
			noise[i] = ((float)rand()/(float)RAND_MAX)*2.0-1.0;
		pos = 0;
	}
	void calculateBlock(unsigned long samples)
	{
		unsigned long i;
		for(i=0;i<samples;i++) outvalue[i] = noise[pos++ & 4095];
	}
};

REGISTER_IMPLEMENTATION(Synth_NOISE_impl);
