/*  This file is part of the KDE project
    Copyright (C) 2000 Matthias Kretz <kretz@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "kviewconfdialog.h"

#include <qcheckbox.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <kapp.h>
#include <knumvalidator.h>

KViewConfDialog::KViewConfDialog( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : KViewConfDialog_Base( parent, name, modal, fl )
{
  //setIcon( kapp->miniIcon() );
  kapp->setTopWidget( this );
  m_interval->setValidator( new KIntValidator( m_interval ) );
  m_interval->setFocus();
}

KViewConfDialog::~KViewConfDialog()
{
}

bool KViewConfDialog::loop()
{
  return m_loop->isChecked();
}

void KViewConfDialog::setLoop( bool b )
{
  m_loop->setChecked( b );
}

int KViewConfDialog::interval()
{
  return m_interval->text().toInt();
}

void KViewConfDialog::setInterval( int n )
{
  m_interval->setText( QString::number( n ) );
}

int KViewConfDialog::resize()
{
  if( m_resizeWindow->isChecked() )
    return 0;
  if( m_resizeImage->isChecked() )
    return 1;
  if( m_noResize->isChecked() )
    return 2;
  return 0;
}

void KViewConfDialog::setResize( int n )
{
  switch( n )
  {
    case 0: m_resizeWindow->setChecked( true ); break;
    case 1: m_resizeImage->setChecked( true );  break;
    case 2: m_noResize->setChecked( true );     break;
  }
}

void KViewConfDialog::slotDefault()
{
  m_loop->setChecked( false );
  m_interval->setText( "5" );
  m_resizeWindow->setChecked( true );
  m_resizeImage->setChecked( false );
  m_noResize->setChecked( false );
}



#include "kviewconfdialog.moc"
