// -*- c++ -*-

#ifndef MAINVIEW_H
#define MAINVIEW_H


#include <qwidget.h>

class View;
class QScrollView;
class Canvas;
class QBoxLayout;

/**
 * view window for kpaint
 * just created for layout.
 */
class MainView : public QWidget
{
Q_OBJECT
public:
MainView(QWidget *parent=0, const char *name=0);

  inline QScrollView *getViewport() const;
  inline Canvas *getCanvas() const;

private:

  // Child widgets
  View *view;
  QScrollView *v;
  Canvas *c;

  // Layoutmanager
  QBoxLayout *lm;

};

QScrollView *
MainView::getViewport() const
{
  return v;
}

Canvas *
MainView::getCanvas() const
{
  return c;
}

#endif // MAINVIEW_H
