/**************** *****************************************************
 TranslData.h   
Ktranslator Version 0.6.x, main widget, top level widget (headers)

    KDE Translation Utility
    
    
    
    
    "Dedicated to the KDE Translators"
    
    
    
    
    
    
    program by Andrea Rizzi <rizzi@kde.org>  
    25 Feb 98 / 27 Apr 99

*********************************************************************/

#ifndef TranslData_included
#define TranslData_included
#include <kspell.h>
#include <qregexp.h>
#include <klocale.h>
#include <qarray.h>
#include <qfile.h>
#include <qfiledlg.h>
#include <kfiledialog.h>
#include <kapp.h>
#include <qcombo.h>
#include <qdialog.h>
#include "CatalogManager.h"
#include <qlabel.h>
#include <qlistbox.h>
#include <qmlined.h>
#include <ktopwidget.h>
#include <ktoolbar.h>
#include "transconf.h"
#include <kledlamp.h>
#include <kaccel.h>
/*
#define  S_RMSLASHN   1    // Remove \n
#define  S_IGUPLOW    2    // Ignore Upper lower case
#define  S_RMMNUND    4    // Remove Menu UnderLine symbol &
#define  S_NORMSPACE  8    // Normalize space
#define  S_RMDOTS     16   // Remove Dots
#define  S_RMCOMMA    32   // Remove , ; : . 
#define  S_RMNONALPHA 64   // Remove Non Aplhabetic symbol  
*/

#define  TS_PROMPT   1
#define  TS_REPALL   2
#define  TS_MSGSTR   1
#define  TS_MSGID    2
#define  TS_COM      4
#define  TS_NOCASE   8
//#define  TS_PROMPT  16
#define  TS_BACK    32


class TranslData;
class KTranslator : public KTopLevelWidget
{
    Q_OBJECT
public:
 KTranslator(QWidget *parent=0,const char* name = NULL,QString filename = "");

private:
 KAccel *acc;
 KToolBar *toolbar;
 KToolBar *navigationbar;
 KApplication *app;
 KConfig *config;
 KMenuBar *menubar;

 KStatusBar *statusbar;
 TranslData *wid;	
 CatalogManager *lv;
// QDialog *wid;
  QComboBox* listLang;
  void fillCombo(KCombo *comboFlag);
  QString   Langs[150];
 QWidget *mainw;
 //QGridLayout *split0;
     
protected slots:
 void setupKeys();
 void setup();
 void saveopt();
 void selectedLang(int a);
 void updateToolbar(); 
 void slotCatMgr(); 
 void updateTot(int n); 
 void updateFuzzy(int n); 
 void updateStatus(int n); 
 void updateFlag(const QPixmap *pix);
 void updateCur(int n);
 void updateTran(int n);
 void updateNavBar(int n);
 void about();
 void openPotFromCvs();
 void openFromCvs();
 void HtmlHelp();
 };


class TranslGoTo : public QDialog
{
 Q_OBJECT
 
 public:
     TranslGoTo(QWidget *parent, const char *name,QString , QString label);
 private slots:      
     void gonow(); 
     void cancel(); 
 private:
  QLineEdit *le;
};

class TranslSearch : public QDialog
{
 Q_OBJECT
 
 public:
     TranslSearch(QWidget *parent, const char *name, bool replace=false,int Flags=1);
     int getFlags();
     QString getStr();
     QString getReplaceStr();
 private slots:      
     void searchnow(); 
     void cancel(); 
 private:
  QLineEdit *le;
  QLineEdit *leR;
  QCheckBox *flagBox[5];
  int flags;
};

class TranslAskReplace : public QDialog
{
 Q_OBJECT
 
 public:
     TranslAskReplace(QWidget *parent=0, const char *name=0);
 private slots:
 void yes();
 void no();
 void all();
 void cancel();
};

class TranslData : public QDialog
{
    Q_OBJECT

public:

    TranslData(QWidget *parent,const char* name = NULL);
    void openFile(QString name);
//    void fillCombo(KCombo *comboFlag);
    virtual ~TranslData();
    void setLang(QString language);
    void openMsgList();
private:    
    QArray<QList<QString> *> Id;
    QArray<QList<QString> *> Str; 
    QArray<QList<QString> *> Com;
    QArray<int> poLine; 
    QArray<unsigned int> spellPos; 

    QArray<KLocale *>cat;
    QList<QString> *Head; 
    QList<QFile> srcList;
    QPushButton *PushButton[8];
    QString lang;
    QLabel *lamp[6];
    QLabel* labelID;
    QMultiLineEdit* editID;
    QListBox* listCat;
    QFile theFile;
    QString nameFile; 
    QMultiLineEdit* editSTR;
    QMultiLineEdit* editNSTR;    
    QMultiLineEdit* editC;
    QString searchStr;
    QString replaceStr;
    KConfig *config;
    KSpell *spell;
    KSpellConfig *spellconf;
    bool scroll;
    bool spellchecking;
    bool mlTranslation;
    bool stopSearch;
    bool doc_modif;
    bool msgFuzzy;
    bool msgSame; 
    bool msgEmpty;    
    int nmax;
    int nid;
    int fl;
    int ncat;
    void updateEd();
    void openCats(QString lang);
    void setScroll(bool status,int event = 0);
    void scrollData(int sc);
    void gotoId(int sc);
    void archive();
    int msgListTranslation(QString s,int fla=0);
    int isItTranslated(int ni);
    bool isMulti(int i);
    QString aMsgId(int i);
signals:
   void upNavBar(int);
   void setStatus(int);    
   void resetPb();    
   void setProgress(int);
   void setTotal(int);
   void fileOpened();
   void total(int);
   void current(int);
   void tran(int);
   void fuzzy(int);
protected slots:
     void modified();
	   void removeFuzzy();
     void header();    
     void scrollOn();    
//     void setup();
//     void saveopt();
     void roughTranslation();
     void spellCheck();
     void spellCheckConfig();
     void nextID();
     void prevID();
     void nextFuzzy();
     void prevFuzzy();
     void selectedCat(int);
     void gotoline();
     void replace();
     void search();
     void searchagain();
     void gotomsg();
     void spellready(KSpell *);
     void spelldone(char *);
     void spellfinish();
     void misspelling(char *,QStrList *,unsigned );    
     void correct(char *,char*,unsigned );
    
     void spellnext();

//     void selectedLang(int a);
     void storeSTR();
     void searchInCats();
     void searchInMsgList();     
     void storeAndNext();
     void storeAndPrev();
     void openPot();
     void makeFile();
//protected:

};



#endif // TranslData_included












