/*
   This file is part of the KDB libraries
   Copyright (c) 2000 Praduroux Alessandro <pradu@thekompany.com>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#ifndef KDB_DATAOBJECT_H
#define KDB_DATAOBJECT_H "$Id: dataobject.h,v 1.3 2001/02/01 03:15:49 garbanzo Exp $"

#include <ksharedptr.h>

#include <kdb/object.h>

namespace KDB {

/**
 * Base class for all 'real' data access objects.
 *
 * It mostly provide shared support (with automatic deallocation)
 * It inherits from KShared.
 *
 * Table, Query and Recordset are DatabaseObject.
 *
 *
 * @author Alessandro Praduroux <pradu@thekompany.com>
 * @version kdbcore 0.0.2
 */

class DataObject : public Object, public KShared {

    Q_OBJECT

 public:
    DataObject(QObject *parent = 0L, const char *name = 0L);

    virtual ~DataObject();


};

}


#endif
