#ifndef MISCUI_H
#define MISCUI_H

#include <qwidget.h>

class MultiCheckBox : public QWidget
{
 Q_OBJECT

 public:	
	MultiCheckBox(int value = 0, QWidget *parent = 0, const char *name = 0);
	virtual ~MultiCheckBox() {}

	int value() const { return _value; }
	void setValue(int v);
	
	virtual QSize sizeHint() const;
	virtual QSizePolicy sizePolicy() const;
	
 signals:
	void changed(int);
	
 protected:
	virtual void drawIn(const QRect &r) = 0;
	virtual bool modifie() = 0;
	
	virtual void paintEvent(QPaintEvent *);
	virtual void mousePressEvent(QMouseEvent *e);
	
 private:
	int  _value;
};

class MeetingCheckBox : public MultiCheckBox
{
 public:	
	enum Type { Ready, NotReady, Excluded };
	MeetingCheckBox(Type type, bool serverControl,
				QWidget *parent = 0, const char *name = 0);

	Type type() const { return (Type)value(); };
	
 protected:
	void drawIn(const QRect &r);
	bool modifie();
	
 private:
	bool serverControl;
};

class PlayerCheckBox : public MultiCheckBox
{
 public:	
	enum Type { Human, AI, Empty };
	PlayerCheckBox(Type type, bool canBeEmpty, bool acceptAI,
				QWidget *parent = 0, const char *name = 0);

	Type type() const { return (Type)value(); };
	
 protected:
	void drawIn(const QRect &r);
	bool modifie();
	
 private:
	bool canBeEmpty, acceptAI;
};

#endif // MISCUI_H
