/* Yo Emacs, this -*- C++ -*-

  Copyright (C) 1999,2000 Jens Hoefkens
  jens@hoefkens.com

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
*/

#include <kbgengine.moc>
#include <kbgengine.h>

/*
 * Constructor initializes the QObject
 */
KBgEngine::KBgEngine(QWidget *parent, QString *name)
	: QObject(parent, name->local8Bit())
{
	// empty
}

/*
 * Destructor is empty
 */
KBgEngine::~KBgEngine()
{
	// empty
}

/*
 * Create the popup menu and fill in the generic part
 */
void KBgEngine::createMenu(KActionCollection *collection)
{
	/*
	 * create & initialize the menu
	 */
	menu = new QPopupMenu();
	
	collection->action("undo")->plug(menu);
	collection->action("redo")->plug(menu);
	
	menu->insertSeparator();

	collection->action("load")->plug(menu);

	menu->insertSeparator();

	collection->action("roll")->plug(menu);
	collection->action("cube")->plug(menu);
	collection->action("done")->plug(menu);
	
	menu->insertSeparator();	
}


// EOF
