/* Somewhat more sane string handling functions...                        *
 * Should be portable, therefore we aren't simply using QString.          */

#ifndef _STRING_H_
#define _STRING_H_ 1
#include <string>
#include <list>
#include <iostream>
#include <stdarg.h>

class String;
class StringList;

typedef list<String> strlist;

class String:public string {
public:
	String():string("") { };
	String(char const * const &s):string(s) { };
	String(string const &s):string(s) { };
	String const operator +(char const &s);
	String const operator +(char const * const s);
	bool operator ==(char s);
	bool operator !=(char s);
	operator char * () const { return cstr(); };
	char * cstr() const;
	bool cmp(char const * const s) const;
	bool casecmp(char const * const s) const;
	bool contains(String const &s, bool cs=true) const;
	int locate(String const &s, bool cs=true, unsigned int startat=0) const;
	void sprintf(const char *format, ...);
	bool readfile(String filename);
	String simplifyWhiteSpace() const;
	String left(unsigned int num=1) const;
	String right(unsigned int num=1) const;
	String mid(unsigned int start, unsigned int num=0) const;
	String &regex(String const &expr, bool cs=true) const;
	String &replace(String const &what, String const &with, bool all=true) const;
	char const chr(unsigned int index) const { if(index>=size()) return 0; else return data()[index]; };
	int length() const { return size(); }; // For compatibility with QString
	char const *latin1() const { return cstr(); }; // For compatibility with QString
};

class StringList:public strlist {
public:
	StringList() { clear(); };
	StringList(String const &s);
	StringList(char **strs, int num=-1);
	bool readfile(String const &filename);
	bool writefile(String const &filename) const;
	void operator +=(String const &s) { insert(end(), s); };
	void operator +=(char const * const &s) { insert(end(), s); };
	void operator +=(StringList const &s);
	void operator +=(StringList const * const s);
	operator String() const;
	bool contains(String const &s) const;
	void remove(String const &s);
	void add(String const &s) { insert(end(), s); };
	String const &grep(String const &s) const;
	void sort(bool cs=true);
};

ostream &operator <<(ostream &os, String const &s);
ostream &operator <<(ostream &os, String const *s);
ostream &operator <<(ostream &os, StringList const &s);
ostream &operator <<(ostream &os, StringList const *s);
#endif
