/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#ifndef __CPUTYPE_H
#define __CPUTYPE_H

#include <qstring.h>

#include "device.h"


class CpuType : public Device
{
  public:
  
    CpuType(QString _vendorname, QString _modelname, QString _mhz, uint _cpunumber);
    ~CpuType() {}
    
    virtual bustype   busType()          const { return BusPCI; }
    
    virtual QString   deviceClassName();
    virtual QString   deviceName();
	virtual QString	  vendorName() { return _vendorname; }
    virtual devstate  deviceState();

  private:
  
	QString 	  _vendorname;
    QString       _modelname;
	QString 	  _mhz;
	uint	   	  _cpunumber;
};


#endif
