#ifndef KPPTY_H
#define KPPTY_H

#include <qmultilineedit.h>
#include <qstringlist.h>
#include <qregexp.h> 

#include <TEPty.h>

class  kpPty: public QObject
{ Q_OBJECT
public:
  kpPty();
 ~kpPty();

  QStringList  run(QString cmd, bool inLoop = TRUE,
		   bool needRoot= FALSE);
  bool start(bool needRoot);

  QString remote;

private slots:
  void block_in(const char* , int );
  void done(int);
  void slotTimeout();

public slots:
  void keyOut(char);

signals:
  void textIn(QString);
  void result(QStringList &, int);

private:
  void finish(int ret);

  TEPty* pty;
  QTimer *tm;
  QStringList retList;
  QRegExp terminator;
  bool pUnterm;
  QString uptext;
  bool eventLoop;
  bool started;
  bool timeout;
};


#endif
