#!/usr/bin/perl -i.bak

# originally by Michael Meeks (michael@helixcode.com)
# convert 'cvs diff' to a normal diff that 'patch'
# likes

# skip pre-patch stuff
while (<>) {
    last if /^Index/;
}

while (<>) {
    next if /^Index/;
    next if /^=/;
    next if /^retrieving/;
    if (/^RCS file: (.*),v$/) {
        $path = $1;
        if ($subst) { eval "\$path =~ $subst"; }
    } elsif (/^diff(.*) -r.* -r/ || /^diff(.*) -r/) {
        print "diff$1 $path.orig $path\n";
    } elsif (/^\*\*\* .*\t(\d+\/\d+\/\d+ \d+:\d+:\d+)/) {
        print "*** $path.orig\t$1\n";
    } elsif (/^--- .*\t(\d+\/\d+\/\d+ \d+:\d+:\d+)/) {
        print "--- $path\t$1\n";
    } else {
        print;
    }
}
