.ig \"-*- nroff -*-
Copyright (C) 1989-2000 Free Software Foundation, Inc.

Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
..
.ie t .ds tx T\h'-.1667m'\v'.224m'E\v'-.224m'\h'-.125m'X
.el .ds tx TeX
.\" Like TP, but if specified indent is more than half
.\" the current line-length - indent, use the default indent.
.de Tp
.ie \\n(.$=0:((0\\$1)*2u>(\\n(.lu-\\n(.iu)) .TP
.el .TP "\\$1"
..
.TH GRODVI @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
grodvi \- convert groff output to TeX dvi format
.SH SYNOPSIS
.B grodvi
[
.B \-dv
] [
.BI \-w n
] [
.BI \-F dir
] [
.IR files \|.\|.\|.
]
.PP
It is possible to have whitespace between a command line option and its
parameter.
.SH DESCRIPTION
.B grodvi
is a driver for
.B groff
that produces \*(tx dvi format.
Normally it should be run by
.BR groff\ \-Tdvi .
This will run
.BR @g@troff\ \-Tdvi ;
it will also input the macros
.BR @MACRODIR@/dvi.tmac ;
if the input is being preprocessed with
.B @g@eqn
it will also input
.BR @FONTDIR@/devdvi/eqnchar .
.LP
The dvi file generated by
.B grodvi
can be printed by any correctly-written dvi driver.
The troff drawing primitives are implemented
using the tpic version 2 specials.
If the driver does not support these, the
.B \eD
commands will not produce any output.
.LP
There is an additional drawing command available:
.TP
.BI \eD'R\  dh\ dv '
Draw a rule (solid black rectangle), with one corner
at the current position, and the diagonally opposite corner
at the current position 
.RI +( dh , dv ).
Afterwards the current position will be at the opposite corner.  This
produces a rule in the dvi file and so can be printed even with a
driver that does not support the tpic specials unlike the other
.B \eD
commands.
.LP
The groff command
.BI \eX' anything '
is translated into the same command in the dvi file as would be
produced by
.BI \especial{ anything }
in \*(tx;
.I anything may not contain a newline.
.LP
Font files for
.B grodvi
can be created from tfm files using
.BR tfmtodit (@MAN1EXT@).
The font description file should contain the following
additional commands:
.Tp \w'\fBinternalname'u+2n
.BI internalname\   name
The name of the tfm file (without the
.B .tfm
extension) is
.IR name .
.TP
.BI checksum\  n
The checksum in the tfm file is
.IR n .
.TP
.BI designsize\  n
The designsize in the tfm file is
.IR n .
.LP
These are automatically generated by
.B tfmtodit.
.LP
In
.B troff
the
.B \eN
escape sequence can be used to access characters by their position
in the corresponding tfm file;
all characters in the tfm file can be accessed this way.
.SH OPTIONS
.TP
.B \-d
Do not use tpic specials to implement drawing commands.
Horizontal and vertical lines will be implemented by rules.
Other drawing commands will be ignored.
.TP
.B \-v
Print the version number.
.TP
.BI \-w n
Set the default line thickness to
.I n
thousandths of an em. 
.TP
.BI \-F dir
Prepend directory
.IB dir /devdvi
to the search path for font and device description files.
.SH FILES
.TP
.B @FONTDIR@/devdvi/DESC
Device description file.
.TP
.BI @FONTDIR@/devdvi/ F
Font description file for font
.IR F .
.TP
.B @MACRODIR@/dvi.tmac
Macros for use with
.BR grodvi .
.SH BUGS
Dvi files produced by
.B grodvi
use a different resolution (57816 units per inch) to those produced by
\*(tx.
Incorrectly written drivers which assume the resolution used by \*(tx,
rather than using the resolution specified in the dvi file will not
work with
.BR grodvi .
.LP
When using the
.B \-d
option with boxed tables,
vertical and horizontal lines can sometimes protrude by one pixel.
This is a consequence of the way \*(tx requires that the heights
and widths of rules be rounded.
.SH "SEE ALSO"
.BR tfmtodit (@MAN1EXT@),
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@),
.BR groff_out (@MAN5EXT@),
.BR groff_font (@MAN5EXT@),
.BR groff_char (@MAN7EXT@)
