/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class LDAPUrl
implements Serializable {
    static final long serialVersionUID = -3245440798565713640L;
    public static String defaultFilter = "(objectClass=*)";
    private String hostName;
    private int portNumber;
    private String DN;
    private Vector attributes;
    private int scope;
    private String filter;
    private String URL;

    public LDAPUrl(String string) throws MalformedURLException {
        this.attributes = null;
        this.scope = 0;
        this.filter = defaultFilter;
        this.URL = string;
        this.parseUrl(string);
    }

    private void parseUrl(String string) throws MalformedURLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":/?", true);
        String string2 = null;
        String string3 = stringTokenizer.nextToken();
        if (!string3.equalsIgnoreCase("LDAP")) {
            throw new MalformedURLException();
        }
        string3 = stringTokenizer.nextToken();
        if (!string3.equals(":")) {
            throw new MalformedURLException();
        }
        string3 = stringTokenizer.nextToken();
        if (!string3.equals("/")) {
            throw new MalformedURLException();
        }
        string3 = stringTokenizer.nextToken();
        if (!string3.equals("/")) {
            throw new MalformedURLException();
        }
        string3 = stringTokenizer.nextToken();
        if (string3.equals("/")) {
            this.hostName = null;
            this.portNumber = 389;
        } else {
            this.hostName = string3;
            if (stringTokenizer.countTokens() == 0) {
                this.portNumber = 389;
                return;
            }
            string3 = stringTokenizer.nextToken();
            if (string3.equals(":")) {
                try {
                    this.portNumber = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedURLException();
                }
                if (stringTokenizer.countTokens() == 0) {
                    return;
                }
                stringTokenizer.nextToken();
            } else {
                this.portNumber = 389;
            }
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        this.DN = LDAPUrl.decode(this.readNextConstruct(stringTokenizer));
        if (this.DN.equals("?")) {
            this.DN = "";
        } else if (this.DN.equals("/")) {
            throw new MalformedURLException();
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        string2 = this.readNextConstruct(stringTokenizer);
        if (!string2.equals("?")) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(LDAPUrl.decode(string2), ", ");
            this.attributes = new Vector();
            while (stringTokenizer2.hasMoreTokens()) {
                this.attributes.addElement(stringTokenizer2.nextToken());
            }
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        string2 = this.readNextConstruct(stringTokenizer);
        if (!string2.equals("?")) {
            this.scope = this.getScope(string2);
            if (this.scope < 0) {
                throw new MalformedURLException("Bad scope:" + string2);
            }
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        string2 = this.readNextConstruct(stringTokenizer);
        this.filter = LDAPUrl.decode(string2);
        this.checkBalancedParentheses(this.filter);
        if (!this.filter.startsWith("(") && !this.filter.endsWith(")")) {
            this.filter = "(" + this.filter + ")";
        }
        if (stringTokenizer.hasMoreTokens()) {
            throw new MalformedURLException();
        }
    }

    private void checkBalancedParentheses(String string) throws MalformedURLException {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "()", true);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("(")) {
                ++n;
                continue;
            }
            if (!string2.equals(")") || --n >= 0) continue;
            throw new MalformedURLException("Unbalanced filter parentheses");
        }
        if (n != 0) {
            throw new MalformedURLException("Unbalanced filter parentheses");
        }
    }

    public LDAPUrl(String string, int n, String string2) {
        this.URL = string != null ? (n != 389 ? "LDAP://" + string + ":" + String.valueOf(n) + "/" + LDAPUrl.encode(string2) : "LDAP://" + string + "/" + LDAPUrl.encode(string2)) : "LDAP:///" + LDAPUrl.encode(string2);
        this.hostName = string;
        this.DN = string2;
        this.portNumber = n;
        this.filter = defaultFilter;
        this.attributes = null;
        this.scope = 0;
    }

    public LDAPUrl(String string, int n, String string2, String[] stringArray, int n2, String string3) {
        if (stringArray != null) {
            Vector<String> vector = new Vector<String>();
            int n3 = 0;
            while (n3 < stringArray.length) {
                vector.addElement(stringArray[n3]);
                ++n3;
            }
            this.initialize(string, n, string2, vector.elements(), n2, string3);
            return;
        }
        this.initialize(string, n, string2, null, n2, string3);
    }

    public LDAPUrl(String string, int n, String string2, Enumeration enumeration, int n2, String string3) {
        this.initialize(string, n, string2, enumeration, n2, string3);
    }

    private void initialize(String string, int n, String string2, Enumeration enumeration, int n2, String string3) {
        this.hostName = string;
        this.DN = string2;
        this.portNumber = n;
        this.filter = string3 != null ? string3 : defaultFilter;
        this.scope = n2;
        if (enumeration != null) {
            this.attributes = new Vector();
            while (enumeration.hasMoreElements()) {
                this.attributes.addElement(enumeration.nextElement());
            }
        } else {
            this.attributes = null;
        }
        StringBuffer stringBuffer = new StringBuffer("LDAP://");
        if (string != null) {
            stringBuffer.append(string);
            if (n != 389) {
                stringBuffer.append(':');
                stringBuffer.append(String.valueOf(n));
            }
        }
        stringBuffer.append('/');
        stringBuffer.append(LDAPUrl.encode(string2));
        if (enumeration != null) {
            stringBuffer.append('?');
            Enumeration enumeration2 = this.attributes.elements();
            boolean bl = true;
            while (enumeration2.hasMoreElements()) {
                if (!bl) {
                    stringBuffer.append(',');
                } else {
                    bl = false;
                }
                stringBuffer.append((String)enumeration2.nextElement());
            }
        }
        if (string3 != null) {
            if (enumeration == null) {
                stringBuffer.append('?');
            }
            stringBuffer.append('?');
            switch (n2) {
                default: {
                    stringBuffer.append("base");
                    break;
                }
                case 1: {
                    stringBuffer.append("one");
                    break;
                }
                case 2: {
                    stringBuffer.append("sub");
                }
            }
            stringBuffer.append('?');
            stringBuffer.append(string3);
        }
        this.URL = stringBuffer.toString();
    }

    public String getHost() {
        return this.hostName;
    }

    public int getPort() {
        return this.portNumber;
    }

    public String getDN() {
        return this.DN;
    }

    public Enumeration getAttributes() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.elements();
    }

    public String[] getAttributeArray() {
        if (this.attributes == null) {
            return null;
        }
        String[] stringArray = new String[this.attributes.size()];
        Enumeration enumeration = this.getAttributes();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public int getScope() {
        return this.scope;
    }

    private int getScope(String string) {
        int n = -1;
        if (string.equalsIgnoreCase("base")) {
            n = 0;
        } else if (string.equalsIgnoreCase("one")) {
            n = 1;
        } else if (string.equalsIgnoreCase("sub")) {
            n = 2;
        }
        return n;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getUrl() {
        return this.URL;
    }

    private String readNextConstruct(StringTokenizer stringTokenizer) throws MalformedURLException {
        try {
            if (stringTokenizer.hasMoreTokens()) {
                String string;
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("?")) {
                    return string2;
                }
                if (stringTokenizer.hasMoreTokens() && !(string = stringTokenizer.nextToken()).equals("?")) {
                    throw new MalformedURLException();
                }
                return string2;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MalformedURLException();
        }
        return null;
    }

    private static int hexValue(char c) throws MalformedURLException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new MalformedURLException();
    }

    private static char hexChar(int n) {
        if (n < 0 || n > 15) {
            return 'x';
        }
        if (n < 10) {
            return (char)(n + 48);
        }
        return (char)(n - 10 + 97);
    }

    public static String decode(String string) throws MalformedURLException {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = 0;
        try {
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) != '%') {
                    if (n != n2) {
                        stringBuffer.setCharAt(n2, stringBuffer.charAt(n));
                    }
                    ++n;
                    ++n2;
                    continue;
                }
                stringBuffer.setCharAt(n2, (char)(LDAPUrl.hexValue(stringBuffer.charAt(n + 1)) << 4 | LDAPUrl.hexValue(stringBuffer.charAt(n + 2))));
                ++n2;
                n += 3;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new MalformedURLException();
        }
        stringBuffer.setLength(n2);
        return stringBuffer.toString();
    }

    public static String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || "$-_.+!*'(),".indexOf(c) > 0) {
                stringBuffer.append(c);
            } else {
                stringBuffer.append("%");
                stringBuffer.append(LDAPUrl.hexChar((c & 0xF0) >> 4));
                stringBuffer.append(LDAPUrl.hexChar(c & 0xF));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getUrl();
    }

    public boolean equals(LDAPUrl lDAPUrl) {
        if (this.getHost() == null ? lDAPUrl.getHost() != null : !this.getHost().equals(lDAPUrl.getHost())) {
            return false;
        }
        if (this.getPort() != lDAPUrl.getPort()) {
            return false;
        }
        if (this.getDN() == null ? lDAPUrl.getDN() != null : !this.getDN().equals(lDAPUrl.getDN())) {
            return false;
        }
        if (this.getFilter() == null ? lDAPUrl.getFilter() != null : !this.getFilter().equals(lDAPUrl.getFilter())) {
            return false;
        }
        if (this.getScope() != lDAPUrl.getScope()) {
            return false;
        }
        if (this.attributes == null) {
            if (lDAPUrl.attributes != null) {
                return false;
            }
        } else {
            if (this.attributes.size() != lDAPUrl.attributes.size()) {
                return false;
            }
            int n = 0;
            while (n < this.attributes.size()) {
                if (this.attributes.elementAt(n) != lDAPUrl.attributes.elementAt(n)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }
}

